/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.ldap;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
public class LdapConfiguration {
    @Value(value="${taskana.ldap.serverUrl:ldap://localhost:10389}")
    private String ldapServerUrl;
    @Value(value="${taskana.ldap.baseDn:OU=Test,O=TASKANA}")
    private String ldapBaseDn;
    @Value(value="${taskana.ldap.bindDn:uid=admin}")
    private String ldapBindDn;
    @Value(value="${taskana.ldap.bindPassword:secret}")
    private String ldapBindPassowrd;
    private final Environment env;

    public LdapConfiguration(Environment env) {
        this.env = env;
    }

    @Bean
    public LdapContextSource ldapContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapServerUrl);
        contextSource.setBase(this.ldapBaseDn);
        contextSource.setUserDn(this.ldapBindDn);
        contextSource.setPassword(this.ldapBindPassowrd);
        return contextSource;
    }

    @Bean(name={"ldapTemplate"})
    public LdapTemplate getActiveLdapTemplate() {
        return new LdapTemplate((ContextSource)this.ldapContextSource());
    }
}

