/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.resource.rest;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.resource.rest.PageLinks;

@Configuration
@Aspect
public class PageLinksAspect {
    @Around(value="@annotation(pro.taskana.resource.rest.PageLinks) && args(data, page, ..)")
    public <T extends RepresentationModel<? extends T>> RepresentationModel<T> addLinksToPageResource(ProceedingJoinPoint joinPoint, List<?> data, PagedModel.PageMetadata page) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        PageLinks pageLinks = method.getAnnotation(PageLinks.class);
        String relativeUrl = pageLinks.value();
        UriComponentsBuilder original = this.originalUri(relativeUrl, request);
        RepresentationModel resourceSupport = (RepresentationModel)joinPoint.proceed();
        resourceSupport.add(Link.of((String)original.toUriString()).withSelfRel());
        if (page != null) {
            resourceSupport.add(Link.of((String)original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel(IanaLinkRelations.FIRST));
            resourceSupport.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getTotalPages()}).toUriString()).withRel(IanaLinkRelations.LAST));
            if (page.getNumber() > 1L) {
                resourceSupport.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() - 1L}).toUriString()).withRel(IanaLinkRelations.PREV));
            }
            if (page.getNumber() < page.getTotalPages()) {
                resourceSupport.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() + 1L}).toUriString()).withRel(IanaLinkRelations.NEXT));
            }
        }
        return resourceSupport;
    }

    private UriComponentsBuilder originalUri(String relativeUrl, HttpServletRequest request) {
        UriComponentsBuilder baseUri = WebMvcLinkBuilder.linkTo(PageLinksAspect.class).toUriComponentsBuilder();
        baseUri.path(relativeUrl);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                baseUri.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        return baseUri;
    }
}

