/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.AbstractPagingController;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.WorkbasketType;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketSummaryRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketSummaryRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketController.class);
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String NAME_LIKE = "name-like";
    private static final String KEY = "key";
    private static final String KEY_LIKE = "key-like";
    private static final String OWNER = "owner";
    private static final String OWNER_LIKE = "owner-like";
    private static final String DESCRIPTION_LIKE = "description-like";
    private static final String DOMAIN = "domain";
    private static final String REQUIRED_PERMISSION = "required-permission";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String SORT_BY = "sort-by";
    private static final String SORT_DIRECTION = "order";
    private final WorkbasketService workbasketService;
    private final WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler;
    private final WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler;

    WorkbasketController(WorkbasketService workbasketService, WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler, WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler, WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler) {
        this.workbasketService = workbasketService;
        this.workbasketRepresentationModelAssembler = workbasketRepresentationModelAssembler;
        this.workbasketSummaryRepresentationModelAssembler = workbasketSummaryRepresentationModelAssembler;
        this.workbasketAccessItemRepresentationModelAssembler = workbasketAccessItemRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/workbaskets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketSummaryRepresentationModel>> getWorkbaskets(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getWorkbaskets(params= {})", params);
        }
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        query = this.applySortingParams(query, params);
        this.applyFilterParams(query, params);
        PagedModel.PageMetadata pageMetadata = this.getPageMetadata(params, (BaseQuery<?, ?>)query);
        List<WorkbasketSummary> workbasketSummaries = this.getQueryList(query, pageMetadata);
        TaskanaPagedModel<WorkbasketSummaryRepresentationModel> pagedModels = this.workbasketSummaryRepresentationModelAssembler.toPageModel((Iterable<WorkbasketSummary>)workbasketSummaries, pageMetadata);
        ResponseEntity response = ResponseEntity.ok(pagedModels);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbaskets(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getWorkbasket(workbasketId= {})", (Object)workbasketId);
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasket(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={WorkbasketNotFoundException.class})
    public ResponseEntity<WorkbasketRepresentationModel> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException, WorkbasketInUseException {
        ResponseEntity response;
        LOGGER.debug("Entry to markWorkbasketForDeletion(workbasketId= {})", (Object)workbasketId);
        boolean workbasketDeleted = this.workbasketService.deleteWorkbasket(workbasketId);
        if (workbasketDeleted) {
            LOGGER.debug("Workbasket successfully deleted.");
            response = ResponseEntity.noContent().build();
        } else {
            LOGGER.debug("Workbasket was only marked for deletion and will be physically deleted later on.");
            response = ResponseEntity.accepted().build();
        }
        LOGGER.debug("Exit from markWorkbasketForDeletion(), returning {}", (Object)response);
        return response;
    }

    @PostMapping(path={"/api/v1/workbaskets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> createWorkbasket(@RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createWorkbasket(workbasketResource= {})", (Object)workbasketRepresentationModel);
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        ResponseEntity response = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createWorkbasket(), returning {}", (Object)response);
        }
        return response;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidWorkbasketException, WorkbasketNotFoundException, NotAuthorizedException, ConcurrencyException {
        LOGGER.debug("Entry to updateWorkbasket(workbasketId= {})", (Object)workbasketId);
        if (!workbasketId.equals(workbasketRepresentationModel.getWorkbasketId())) {
            throw new InvalidWorkbasketException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketRepresentationModel.getWorkbasketId() + "')");
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateWorkbasket(), returning {}", (Object)result);
        }
        return result;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketAccessItemRepresentationModel>> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("Entry to getWorkbasketAccessItems(workbasketId= {})", (Object)workbasketId);
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity result = ResponseEntity.ok(this.workbasketAccessItemRepresentationModelAssembler.toPageModelForSingleWorkbasket(workbasketId, accessItems, null));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasketAccessItems(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketAccessItemRepresentationModel>> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody List<WorkbasketAccessItemRepresentationModel> workbasketAccessResourceItems) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException {
        LOGGER.debug("Entry to setWorkbasketAccessItems(workbasketId= {})", (Object)workbasketId);
        if (workbasketAccessResourceItems == null) {
            throw new InvalidArgumentException("Can\u00b4t create something with NULL body-value.");
        }
        ArrayList wbAccessItems = new ArrayList();
        workbasketAccessResourceItems.forEach(item -> wbAccessItems.add(this.workbasketAccessItemRepresentationModelAssembler.toEntityModel((WorkbasketAccessItemRepresentationModel)((Object)item))));
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity response = ResponseEntity.ok(this.workbasketAccessItemRepresentationModelAssembler.toPageModelForSingleWorkbasket(workbasketId, updatedWbAccessItems, null));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from setWorkbasketAccessItems(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketSummaryRepresentationModel>> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getDistributionTargets(workbasketId= {})", (Object)workbasketId);
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        TaskanaPagedModel<WorkbasketSummaryRepresentationModel> distributionTargetListResource = this.workbasketSummaryRepresentationModelAssembler.toDistributionTargetPageModel(distributionTargets, null);
        ResponseEntity result = ResponseEntity.ok(distributionTargetListResource);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getDistributionTargets(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketSummaryRepresentationModel>> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTasksStatusReport(workbasketId= {}, targetWorkbasketIds\u00b4= {})", (Object)sourceWorkbasketId, targetWorkbasketIds);
        }
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        ResponseEntity response = ResponseEntity.ok(this.workbasketSummaryRepresentationModelAssembler.toDistributionTargetPageModel(distributionTargets, null));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksStatusReport(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketSummaryRepresentationModel>> removeDistributionTargetForWorkbasketId(@PathVariable(value="workbasketId") String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to removeDistributionTargetForWorkbasketId(workbasketId= {})", (Object)targetWorkbasketId);
        List sourceWorkbaskets = this.workbasketService.getDistributionSources(targetWorkbasketId);
        for (WorkbasketSummary source : sourceWorkbaskets) {
            this.workbasketService.removeDistributionTarget(source.getId(), targetWorkbasketId);
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from removeDistributionTargetForWorkbasketId(), returning {}", (Object)response);
        return response;
    }

    private WorkbasketQuery applySortingParams(WorkbasketQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String sortBy;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(query= {}, params={})", (Object)query, params);
        }
        if ((sortBy = (String)params.getFirst((Object)SORT_BY)) != null) {
            BaseQuery.SortDirection sortDirection = params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION)) ? BaseQuery.SortDirection.DESCENDING : BaseQuery.SortDirection.ASCENDING;
            switch (sortBy) {
                case "name": {
                    query = query.orderByName(sortDirection);
                    break;
                }
                case "key": {
                    query = query.orderByKey(sortDirection);
                    break;
                }
                case "owner": {
                    query = query.orderByOwner(sortDirection);
                    break;
                }
                case "type": {
                    query = query.orderByType(sortDirection);
                    break;
                }
                case "description": {
                    query = query.orderByDescription(sortDirection);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }
        params.remove((Object)SORT_BY);
        params.remove((Object)SORT_DIRECTION);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", (Object)query);
        }
        return query;
    }

    private void applyFilterParams(WorkbasketQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String[] names;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(query= {}, params= {})", (Object)query, params);
        }
        if (params.containsKey((Object)NAME)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)NAME));
            query.nameIn(names);
            params.remove((Object)NAME);
        }
        if (params.containsKey((Object)NAME_LIKE)) {
            query.nameLike(new String[]{LIKE + (String)((List)params.get((Object)NAME_LIKE)).get(0) + LIKE});
            params.remove((Object)NAME_LIKE);
        }
        if (params.containsKey((Object)KEY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)KEY));
            query.keyIn(names);
            params.remove((Object)KEY);
        }
        if (params.containsKey((Object)KEY_LIKE)) {
            query.keyLike(new String[]{LIKE + (String)((List)params.get((Object)KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)KEY_LIKE);
        }
        if (params.containsKey((Object)OWNER)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)OWNER));
            query.ownerIn(names);
            params.remove((Object)OWNER);
        }
        if (params.containsKey((Object)OWNER_LIKE)) {
            query.ownerLike(new String[]{LIKE + (String)((List)params.get((Object)OWNER_LIKE)).get(0) + LIKE});
            params.remove((Object)OWNER_LIKE);
        }
        if (params.containsKey((Object)DESCRIPTION_LIKE)) {
            query.descriptionLike(new String[]{LIKE + (String)((List)params.get((Object)DESCRIPTION_LIKE)).get(0) + LIKE});
            params.remove((Object)DESCRIPTION_LIKE);
        }
        if (params.containsKey((Object)DOMAIN)) {
            query.domainIn(this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN)));
            params.remove((Object)DOMAIN);
        }
        if (params.containsKey((Object)TYPE)) {
            switch ((String[])params.getFirst((Object)TYPE)) {
                case "PERSONAL": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.PERSONAL});
                    break;
                }
                case "GROUP": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.GROUP});
                    break;
                }
                case "CLEARANCE": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.CLEARANCE});
                    break;
                }
                case "TOPIC": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.TOPIC});
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown Workbasket type '" + (String)params.getFirst((Object)TYPE) + "'");
                }
            }
            params.remove((Object)TYPE);
        }
        if (params.containsKey((Object)REQUIRED_PERMISSION)) {
            block50: for (String authorization : ((String)params.getFirst((Object)REQUIRED_PERMISSION)).split(",")) {
                switch (authorization.trim()) {
                    case "READ": {
                        query.callerHasPermission(WorkbasketPermission.READ);
                        continue block50;
                    }
                    case "OPEN": {
                        query.callerHasPermission(WorkbasketPermission.OPEN);
                        continue block50;
                    }
                    case "APPEND": {
                        query.callerHasPermission(WorkbasketPermission.APPEND);
                        continue block50;
                    }
                    case "TRANSFER": {
                        query.callerHasPermission(WorkbasketPermission.TRANSFER);
                        continue block50;
                    }
                    case "DISTRIBUTE": {
                        query.callerHasPermission(WorkbasketPermission.DISTRIBUTE);
                        continue block50;
                    }
                    case "CUSTOM_1": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_1);
                        continue block50;
                    }
                    case "CUSTOM_2": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_2);
                        continue block50;
                    }
                    case "CUSTOM_3": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_3);
                        continue block50;
                    }
                    case "CUSTOM_4": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_4);
                        continue block50;
                    }
                    case "CUSTOM_5": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_5);
                        continue block50;
                    }
                    case "CUSTOM_6": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_6);
                        continue block50;
                    }
                    case "CUSTOM_7": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_7);
                        continue block50;
                    }
                    case "CUSTOM_8": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_8);
                        continue block50;
                    }
                    case "CUSTOM_9": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_9);
                        continue block50;
                    }
                    case "CUSTOM_10": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_10);
                        continue block50;
                    }
                    case "CUSTOM_11": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_11);
                        continue block50;
                    }
                    case "CUSTOM_12": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_12);
                        continue block50;
                    }
                    default: {
                        throw new InvalidArgumentException("Unknown authorization '" + authorization + "'");
                    }
                }
            }
            params.remove((Object)REQUIRED_PERMISSION);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)query);
        }
    }
}

