/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.models.WorkbasketImpl;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketDefinitionRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketDefinitionController.class);
    private final WorkbasketService workbasketService;
    private final WorkbasketDefinitionRepresentationModelAssembler workbasketDefinitionAssembler;
    private final WorkbasketRepresentationModelAssembler workbasketAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler;
    private final ObjectMapper mapper;

    @Autowired
    WorkbasketDefinitionController(WorkbasketService workbasketService, WorkbasketDefinitionRepresentationModelAssembler workbasketDefinitionAssembler, WorkbasketRepresentationModelAssembler workbasketAssembler, WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler, ObjectMapper mapper) {
        this.workbasketService = workbasketService;
        this.workbasketDefinitionAssembler = workbasketDefinitionAssembler;
        this.workbasketAssembler = workbasketAssembler;
        this.accessItemAssembler = accessItemAssembler;
        this.mapper = mapper;
    }

    @GetMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<WorkbasketDefinitionRepresentationModel>> exportWorkbaskets(@RequestParam(required=false) String domain) {
        LOGGER.debug("Entry to exportWorkbaskets(domain= {})", (Object)domain);
        WorkbasketQuery workbasketQuery = this.workbasketService.createWorkbasketQuery();
        List workbasketSummaryList = domain != null ? workbasketQuery.domainIn(new String[]{domain}).list() : workbasketQuery.list();
        TaskanaPagedModel pageModel = workbasketSummaryList.stream().map(WorkbasketSummary::getId).map(CheckedFunction.wrap(arg_0 -> ((WorkbasketService)this.workbasketService).getWorkbasket(arg_0))).collect(Collectors.collectingAndThen(Collectors.toList(), this.workbasketDefinitionAssembler::toPageModel));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pageModel));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportWorkbaskets(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importWorkbaskets(@RequestParam(value="file") MultipartFile file) throws IOException, NotAuthorizedException, DomainNotFoundException, InvalidWorkbasketException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, InvalidArgumentException, WorkbasketAccessItemAlreadyExistException, ConcurrencyException {
        LOGGER.debug("Entry to importWorkbaskets()");
        TaskanaPagedModel definitions = (TaskanaPagedModel)((Object)this.mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<TaskanaPagedModel<WorkbasketDefinitionRepresentationModel>>(){}));
        Map<String, String> systemIds = this.workbasketService.createWorkbasketQuery().list().stream().collect(Collectors.toMap(this::logicalId, WorkbasketSummary::getId));
        this.checkForDuplicates(definitions.getContent());
        HashMap<String, String> idConversion = new HashMap<String, String>();
        for (WorkbasketDefinitionRepresentationModel definition : definitions.getContent()) {
            String newId;
            Workbasket importedWb = this.workbasketAssembler.toEntityModel(definition.getWorkbasket());
            WorkbasketImpl wbWithoutId = (WorkbasketImpl)this.removeId(importedWb);
            if (systemIds.containsKey(this.logicalId(importedWb))) {
                Workbasket modifiedWb = this.workbasketService.getWorkbasket(importedWb.getKey(), importedWb.getDomain());
                wbWithoutId.setModified(modifiedWb.getModified());
                this.workbasketService.updateWorkbasket((Workbasket)wbWithoutId);
                newId = systemIds.get(this.logicalId(importedWb));
            } else {
                newId = this.workbasketService.createWorkbasket((Workbasket)wbWithoutId).getId();
            }
            boolean authenticated = definition.getAuthorizations().stream().anyMatch(access -> access.getWorkbasketId().equals(importedWb.getId()) && access.getWorkbasketKey().equals(importedWb.getKey()));
            if (!authenticated && !definition.getAuthorizations().isEmpty()) {
                throw new InvalidWorkbasketException("The given Authentications for Workbasket " + importedWb.getId() + " don't match in WorkbasketId and WorkbasketKey. Please provide consistent WorkbasketDefinitions");
            }
            for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(newId)) {
                this.workbasketService.deleteWorkbasketAccessItem(accessItem.getId());
            }
            for (WorkbasketAccessItemRepresentationModel authorization : definition.getAuthorizations()) {
                authorization.setWorkbasketId(newId);
                this.workbasketService.createWorkbasketAccessItem(this.accessItemAssembler.toEntityModel(authorization));
            }
            idConversion.put(importedWb.getId(), newId);
        }
        for (WorkbasketDefinitionRepresentationModel definition : definitions.getContent()) {
            ArrayList<Object> distributionTargets = new ArrayList<Object>();
            for (String oldId : definition.getDistributionTargets()) {
                if (idConversion.containsKey(oldId)) {
                    distributionTargets.add(idConversion.get(oldId));
                    continue;
                }
                if (systemIds.containsValue(oldId)) {
                    distributionTargets.add(oldId);
                    continue;
                }
                throw new InvalidWorkbasketException(String.format("invalid import state: Workbasket '%s' does not exist in the given import list", oldId));
            }
            this.workbasketService.setDistributionTargets((String)idConversion.get(definition.getWorkbasket().getWorkbasketId()), distributionTargets);
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from importWorkbaskets(), returning {}", (Object)response);
        return response;
    }

    private Workbasket removeId(Workbasket importedWb) {
        WorkbasketRepresentationModel wbRes = this.workbasketAssembler.toModel(importedWb);
        wbRes.setWorkbasketId(null);
        return this.workbasketAssembler.toEntityModel(wbRes);
    }

    private void checkForDuplicates(Collection<WorkbasketDefinitionRepresentationModel> definitions) {
        ArrayList<String> identifiers = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (WorkbasketDefinitionRepresentationModel definition : definitions) {
            String identifier = this.logicalId(this.workbasketAssembler.toEntityModel(definition.getWorkbasket()));
            if (identifiers.contains(identifier)) {
                duplicates.add(identifier);
                continue;
            }
            identifiers.add(identifier);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException("The 'key|domain'-identifier is not unique for the value(s): " + ((Object)duplicates).toString());
        }
    }

    private String logicalId(WorkbasketSummary workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(Workbasket workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(String key, String domain) {
        return key + "|" + domain;
    }
}

