/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskState;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class MonitorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorController.class);
    private final MonitorService monitorService;
    private final ReportRepresentationModelAssembler reportRepresentationModelAssembler;

    @Autowired
    MonitorController(MonitorService monitorService, ReportRepresentationModelAssembler reportRepresentationModelAssembler) {
        this.monitorService = monitorService;
        this.reportRepresentationModelAssembler = reportRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-status-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTasksStatusReport(@RequestParam(required=false) List<String> domains, @RequestParam(required=false) List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksStatusReport()");
        ResponseEntity response = ResponseEntity.ok((Object)((Object)this.reportRepresentationModelAssembler.toModel(this.monitorService.createTaskStatusReportBuilder().stateIn(states).domainIn(domains).buildReport(), domains, states)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksStatusReport(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-workbasket-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTasksWorkbasketReport(@RequestParam(value="states") List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksWorkbasketReport()");
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((WorkbasketReport.Builder)this.monitorService.createWorkbasketReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).buildReport(), states);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksWorkbasketReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/api/v1/monitor/tasks-workbasket-planned-date-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTasksWorkbasketPlannedDateReport(@RequestParam(value="daysInPast") int daysInPast, @RequestParam(value="states") List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksWorkbasketPlannedDateReport()");
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((WorkbasketReport.Builder)((WorkbasketReport.Builder)this.monitorService.createWorkbasketReportBuilder().stateIn(states)).withColumnHeaders(this.getDateTimeInterval(daysInPast))).buildPlannedDateBasedReport(), daysInPast, states);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksWorkbasketPlannedDateReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/api/v1/monitor/tasks-classification-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTasksClassificationReport() throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksClassificationReport()");
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((ClassificationReport.Builder)this.monitorService.createClassificationReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).buildReport());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksClassificationReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/api/v1/monitor/timestamp-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getDailyEntryExitReport() throws NotAuthorizedException, InvalidArgumentException {
        List columnHeaders = IntStream.range(-14, 0).mapToObj(TimeIntervalColumnHeader.Date::new).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.reportRepresentationModelAssembler.toModel(((TimestampReport.Builder)this.monitorService.createTimestampReportBuilder().withColumnHeaders(columnHeaders)).buildReport()));
    }

    private List<TimeIntervalColumnHeader> getRangeTimeInterval() {
        return Stream.concat(Stream.concat(Stream.of(new TimeIntervalColumnHeader.Range(Integer.MIN_VALUE, -10), new TimeIntervalColumnHeader.Range(-10, -5)), Stream.of(-4, -3, -2, -1, 0, 1, 2, 3, 4).map(TimeIntervalColumnHeader.Range::new)), Stream.of(new TimeIntervalColumnHeader.Range(5, 10), new TimeIntervalColumnHeader.Range(10, Integer.MAX_VALUE))).collect(Collectors.toList());
    }

    private List<TimeIntervalColumnHeader> getDateTimeInterval(int daysInPast) {
        ArrayList<TimeIntervalColumnHeader> columnHeaders = new ArrayList<TimeIntervalColumnHeader>();
        for (int i = 0; i <= daysInPast; ++i) {
            columnHeaders.add((TimeIntervalColumnHeader)new TimeIntervalColumnHeader.Date(i - daysInPast));
        }
        return columnHeaders;
    }
}

