/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.rest.assembler.TaskCommentRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCommentController.class);
    private static final String SORT_BY = "sort-by";
    private static final String SORT_DIRECTION = "order";
    private static final String CREATED = "created";
    private static final String MODIFIED = "modified";
    private final TaskService taskService;
    private final TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler;

    @Autowired
    TaskCommentController(TaskService taskService, TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskCommentRepresentationModelAssembler = taskCommentRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> getTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentRepresentationModel taskCommentRepresentationModel = this.taskCommentRepresentationModelAssembler.toModel(taskComment);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)taskCommentRepresentationModel));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComment(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<TaskCommentRepresentationModel>> getTaskComments(@PathVariable String taskId, @RequestParam(required=false) MultiValueMap<String, String> params) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComments(taskId= {})", (Object)taskId);
        }
        List taskComments = this.taskService.getTaskComments(taskId);
        this.applySortingParams(taskComments, params);
        TaskanaPagedModel<TaskCommentRepresentationModel> taskCommentListResource = this.taskCommentRepresentationModelAssembler.toPageModel(taskComments, (PagedModel.PageMetadata)null);
        ResponseEntity response = ResponseEntity.ok(taskCommentListResource);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComments(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> deleteTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to deleteTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity result = ResponseEntity.noContent().build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from deleteTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> updateTaskComment(@PathVariable String taskCommentId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to updateTaskComment(taskCommentId= {}, taskCommentResource= {})", (Object)taskCommentId, (Object)taskCommentRepresentationModel);
        }
        ResponseEntity result = null;
        if (!taskCommentId.equals(taskCommentRepresentationModel.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        taskComment = this.taskService.updateTaskComment(taskComment);
        result = ResponseEntity.ok((Object)((Object)this.taskCommentRepresentationModelAssembler.toModel(taskComment)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> createTaskComment(@PathVariable String taskId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, InvalidArgumentException, TaskNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createTaskComment(taskId= {}, taskCommentResource= {})", (Object)taskId, (Object)taskCommentRepresentationModel);
        }
        taskCommentRepresentationModel.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskCommentRepresentationModelAssembler.toModel(createdTaskComment));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    private List<TaskComment> applySortingParams(List<TaskComment> taskComments, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String sortBy;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(taskComments= {}, params= {})", taskComments, params);
        }
        if ((sortBy = (String)params.getFirst((Object)SORT_BY)) != null) {
            switch (sortBy) {
                case "created": {
                    if (params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION))) {
                        taskComments.sort(Comparator.comparing(TaskComment::getCreated).reversed());
                        break;
                    }
                    taskComments.sort(Comparator.comparing(TaskComment::getCreated));
                    break;
                }
                case "modified": {
                    if (params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION))) {
                        taskComments.sort(Comparator.comparing(TaskComment::getModified).reversed());
                        break;
                    }
                    taskComments.sort(Comparator.comparing(TaskComment::getModified));
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown sort attribute: " + sortBy);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", taskComments);
        }
        return taskComments;
    }
}

