/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest.assembler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.internal.models.WorkbasketImpl;
import pro.taskana.workbasket.rest.WorkbasketController;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;

@Component
public class WorkbasketRepresentationModelAssembler
implements RepresentationModelAssembler<Workbasket, WorkbasketRepresentationModel> {
    private final WorkbasketService workbasketService;

    @Autowired
    public WorkbasketRepresentationModelAssembler(WorkbasketService workbasketService) {
        this.workbasketService = workbasketService;
    }

    @NonNull
    public WorkbasketRepresentationModel toModel(@NonNull Workbasket workbasket) {
        WorkbasketRepresentationModel repModel = new WorkbasketRepresentationModel();
        repModel.setWorkbasketId(workbasket.getId());
        repModel.setKey(workbasket.getKey());
        repModel.setName(workbasket.getName());
        repModel.setDomain(workbasket.getDomain());
        repModel.setType(workbasket.getType());
        repModel.setDescription(workbasket.getDescription());
        repModel.setOwner(workbasket.getOwner());
        repModel.setMarkedForDeletion(workbasket.isMarkedForDeletion());
        repModel.setCustom1(workbasket.getCustom1());
        repModel.setCustom2(workbasket.getCustom2());
        repModel.setCustom3(workbasket.getCustom3());
        repModel.setCustom4(workbasket.getCustom4());
        repModel.setOrgLevel1(workbasket.getOrgLevel1());
        repModel.setOrgLevel2(workbasket.getOrgLevel2());
        repModel.setOrgLevel3(workbasket.getOrgLevel3());
        repModel.setOrgLevel4(workbasket.getOrgLevel4());
        repModel.setCreated(workbasket.getCreated());
        repModel.setModified(workbasket.getModified());
        try {
            return this.addLinks(repModel, workbasket);
        }
        catch (Exception e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
    }

    public Workbasket toEntityModel(WorkbasketRepresentationModel repModel) {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(repModel.getKey(), repModel.getDomain());
        workbasket.setId(repModel.getWorkbasketId());
        workbasket.setName(repModel.getName());
        workbasket.setType(repModel.getType());
        workbasket.setDescription(repModel.getDescription());
        workbasket.setOwner(repModel.getOwner());
        workbasket.setMarkedForDeletion(repModel.getMarkedForDeletion());
        workbasket.setCustom1(repModel.getCustom1());
        workbasket.setCustom2(repModel.getCustom2());
        workbasket.setCustom3(repModel.getCustom3());
        workbasket.setCustom4(repModel.getCustom4());
        workbasket.setOrgLevel1(repModel.getOrgLevel1());
        workbasket.setOrgLevel2(repModel.getOrgLevel2());
        workbasket.setOrgLevel3(repModel.getOrgLevel3());
        workbasket.setOrgLevel4(repModel.getOrgLevel4());
        workbasket.setCreated(repModel.getCreated());
        workbasket.setModified(repModel.getModified());
        return workbasket;
    }

    private WorkbasketRepresentationModel addLinks(WorkbasketRepresentationModel resource, Workbasket wb) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidArgumentException {
        resource.add(WebMvcLinkBuilder.linkTo(((WorkbasketController)WebMvcLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wb.getId())).withSelfRel());
        resource.add(WebMvcLinkBuilder.linkTo(((WorkbasketController)WebMvcLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(wb.getId())).withRel("distributionTargets"));
        resource.add(WebMvcLinkBuilder.linkTo(((WorkbasketController)WebMvcLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasketAccessItems(wb.getId())).withRel("accessItems"));
        resource.add(WebMvcLinkBuilder.linkTo(((WorkbasketController)WebMvcLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbaskets((MultiValueMap<String, String>)new LinkedMultiValueMap())).withRel("allWorkbaskets"));
        resource.add(WebMvcLinkBuilder.linkTo(((WorkbasketController)WebMvcLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).removeDistributionTargetForWorkbasketId(wb.getId())).withRel("removeDistributionTargets"));
        return resource;
    }
}

