/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.assembler.ClassificationRepresentationModelAssembler;
import pro.taskana.classification.rest.assembler.ClassificationSummaryRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.classification.rest.models.ClassificationSummaryRepresentationModel;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedBiConsumer;
import pro.taskana.common.rest.AbstractPagingController;
import pro.taskana.common.rest.QueryHelper;
import pro.taskana.common.rest.models.TaskanaPagedModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationController.class);
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String NAME_LIKE = "name-like";
    private static final String KEY = "key";
    private static final String DOMAIN = "domain";
    private static final String CATEGORY = "category";
    private static final String TYPE = "type";
    private final ClassificationService classificationService;
    private final ClassificationRepresentationModelAssembler modelAssembler;
    private final ClassificationSummaryRepresentationModelAssembler summaryModelAssembler;

    @Autowired
    ClassificationController(ClassificationService classificationService, ClassificationRepresentationModelAssembler modelAssembler, ClassificationSummaryRepresentationModelAssembler summaryModelAssembler) {
        this.classificationService = classificationService;
        this.modelAssembler = modelAssembler;
        this.summaryModelAssembler = summaryModelAssembler;
    }

    @GetMapping(path={"/api/v1/classifications"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<ClassificationSummaryRepresentationModel>> getClassifications(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getClassifications(params= {})", params);
        }
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        this.applyFilterParams(query, params);
        this.applySortingParams(query, params);
        PagedModel.PageMetadata pageMetadata = this.getPageMetadata(params, (BaseQuery<?, ?>)query);
        List<ClassificationSummary> classificationSummaries = this.getQueryList(query, pageMetadata);
        ResponseEntity response = ResponseEntity.ok(this.summaryModelAssembler.toPageModel((Iterable<ClassificationSummary>)classificationSummaries, pageMetadata));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassifications(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/classifications/{classificationId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> getClassification(@PathVariable String classificationId) throws ClassificationNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getClassification(classificationId= {})", (Object)classificationId);
        }
        Classification classification = this.classificationService.getClassification(classificationId);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassification(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/classifications"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> createClassification(@RequestBody ClassificationRepresentationModel resource) throws NotAuthorizedException, ClassificationAlreadyExistException, DomainNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createClassification(resource= {})", (Object)resource);
        }
        Classification classification = this.modelAssembler.toEntityModel(resource);
        classification = this.classificationService.createClassification(classification);
        ResponseEntity response = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.modelAssembler.toModel(classification));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createClassification(), returning {}", (Object)response);
        }
        return response;
    }

    @PutMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> updateClassification(@PathVariable(value="classificationId") String classificationId, @RequestBody ClassificationRepresentationModel resource) throws NotAuthorizedException, ClassificationNotFoundException, ConcurrencyException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to updateClassification(classificationId= {}, resource= {})", (Object)classificationId, (Object)resource);
        }
        if (!classificationId.equals(resource.getClassificationId())) {
            throw new InvalidArgumentException("ClassificationId ('" + classificationId + "') of the URI is not identical with the classificationId ('" + resource.getClassificationId() + "') of the object in the payload.");
        }
        Classification classification = this.modelAssembler.toEntityModel(resource);
        classification = this.classificationService.updateClassification(classification);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateClassification(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> deleteClassification(@PathVariable String classificationId) throws ClassificationNotFoundException, ClassificationInUseException, NotAuthorizedException {
        LOGGER.debug("Entry to deleteClassification(classificationId= {})", (Object)classificationId);
        this.classificationService.deleteClassification(classificationId);
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from deleteClassification(), returning {}", (Object)response);
        return response;
    }

    private void applySortingParams(ClassificationQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(query= {}, params= {})", (Object)query, params);
        }
        QueryHelper.applyAndRemoveSortingParams(params, (CheckedBiConsumer<String, BaseQuery.SortDirection, InvalidArgumentException>)((CheckedBiConsumer)(sortBy, sortDirection) -> {
            switch (sortBy) {
                case "category": {
                    query.orderByCategory(sortDirection);
                    break;
                }
                case "domain": {
                    query.orderByDomain(sortDirection);
                    break;
                }
                case "key": {
                    query.orderByKey(sortDirection);
                    break;
                }
                case "name": {
                    query.orderByName(sortDirection);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", (Object)query);
        }
    }

    private void applyFilterParams(ClassificationQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String[] names;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(query= {}, params= {})", (Object)query, params);
        }
        if (params.containsKey((Object)NAME)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)NAME));
            query.nameIn(names);
            params.remove((Object)NAME);
        }
        if (params.containsKey((Object)NAME_LIKE)) {
            query.nameLike(new String[]{LIKE + (String)((List)params.get((Object)NAME_LIKE)).get(0) + LIKE});
            params.remove((Object)NAME_LIKE);
        }
        if (params.containsKey((Object)KEY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)KEY));
            query.keyIn(names);
            params.remove((Object)KEY);
        }
        if (params.containsKey((Object)CATEGORY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)CATEGORY));
            query.categoryIn(names);
            params.remove((Object)CATEGORY);
        }
        if (params.containsKey((Object)DOMAIN)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN));
            query.domainIn(names);
            params.remove((Object)DOMAIN);
        }
        if (params.containsKey((Object)TYPE)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)TYPE));
            query.typeIn(names);
            params.remove((Object)TYPE);
        }
        for (ClassificationCustomField customField : ClassificationCustomField.values()) {
            List customFieldParams = (List)params.remove((Object)(customField.name().replace("_", "-").toLowerCase() + "-like"));
            if (customFieldParams == null) continue;
            String[] customValues = this.extractCommaSeparatedFields(customFieldParams);
            for (int i = 0; i < customValues.length; ++i) {
                customValues[i] = LIKE + customValues[i] + LIKE;
            }
            query.customAttributeLike(customField, customValues);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)query);
        }
    }
}

