/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;

public class PagedResources<T>
extends RepresentationModel<PagedResources<T>> {
    private final Collection<T> content;
    private final PagedModel.PageMetadata metadata;

    protected PagedResources() {
        this(new ArrayList(), null, new Link[0]);
    }

    public PagedResources(Collection<T> content, PagedModel.PageMetadata metadata, Link ... links) {
        this(content, metadata, Arrays.asList(links));
    }

    public PagedResources(Collection<T> content, PagedModel.PageMetadata metadata, Iterable<Link> links) {
        this.content = content;
        this.metadata = metadata;
        this.add(links);
    }

    @JsonProperty(value="page")
    public PagedModel.PageMetadata getMetadata() {
        if (Objects.isNull(this.metadata)) {
            Collection<T> contentCollection = this.getContent();
            return new PagedModel.PageMetadata((long)contentCollection.size(), 0L, (long)contentCollection.size());
        }
        return this.metadata;
    }

    @JsonProperty(value="content")
    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }
}

