/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedBiConsumer;
import pro.taskana.common.rest.AbstractPagingController;
import pro.taskana.common.rest.QueryHelper;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.WildcardSearchField;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.rest.assembler.TaskRepresentationModelAssembler;
import pro.taskana.task.rest.assembler.TaskSummaryRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskRepresentationModel;
import pro.taskana.task.rest.models.TaskSummaryRepresentationModel;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    private static final String LIKE = "%";
    private static final String STATE = "state";
    private static final String STATE_VALUE_CLAIMED = "CLAIMED";
    private static final String STATE_VALUE_COMPLETED = "COMPLETED";
    private static final String STATE_VALUE_READY = "READY";
    private static final String PRIORITY = "priority";
    private static final String NAME = "name";
    private static final String NAME_LIKE = "name-like";
    private static final String OWNER = "owner";
    private static final String OWNER_LIKE = "owner-like";
    private static final String DOMAIN = "domain";
    private static final String TASK_ID = "task-id";
    private static final String WORKBASKET_ID = "workbasket-id";
    private static final String WORKBASKET_KEY = "workbasket-key";
    private static final String CLASSIFICATION_KEY = "classification.key";
    private static final String POR_VALUE = "por.value";
    private static final String POR_TYPE = "por.type";
    private static final String POR_SYSTEM_INSTANCE = "por.instance";
    private static final String POR_SYSTEM = "por.system";
    private static final String POR_COMPANY = "por.company";
    private static final String DUE = "due";
    private static final String DUE_TO = "due-until";
    private static final String DUE_FROM = "due-from";
    private static final String PLANNED = "planned";
    private static final String PLANNED_UNTIL = "planned-until";
    private static final String PLANNED_FROM = "planned-from";
    private static final String EXTERNAL_ID = "external-id";
    private static final String WILDCARD_SEARCH_VALUE = "wildcard-search-value";
    private static final String WILDCARD_SEARCH_FIELDS = "wildcard-search-fields";
    private static final String INDEFINITE = "";
    private final TaskService taskService;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler;

    @Autowired
    TaskController(TaskService taskService, TaskRepresentationModelAssembler taskRepresentationModelAssembler, TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.taskSummaryRepresentationModelAssembler = taskSummaryRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<TaskSummaryRepresentationModel>> getTasks(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTasks(params= {})", params);
        }
        TaskQuery query = this.taskService.createTaskQuery();
        this.applyFilterParams(query, params);
        this.applySortingParams(query, params);
        PagedModel.PageMetadata pageMetadata = this.getPageMetadata(params, (BaseQuery<?, ?>)query);
        List<TaskSummary> taskSummaries = this.getQueryList(query, pageMetadata);
        TaskanaPagedModel<TaskSummaryRepresentationModel> pagedModels = this.taskSummaryRepresentationModelAssembler.toPageModel(taskSummaries, pageMetadata);
        ResponseEntity response = ResponseEntity.ok(pagedModels);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasks(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<TaskSummaryRepresentationModel>> deleteTasks(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException, NotAuthorizedException {
        LOGGER.debug("Entry to deleteTasks(params= {})", params);
        TaskQuery query = this.taskService.createTaskQuery();
        this.applyFilterParams(query, params);
        this.validateNoInvalidParameterIsLeft(params);
        List taskSummaries = this.getQueryList(query, (PagedModel.PageMetadata)null);
        List taskIdsToDelete = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
        BulkOperationResults result = this.taskService.deleteTasks(taskIdsToDelete);
        List successfullyDeletedTaskSummaries = taskSummaries.stream().filter(summary -> !result.getFailedIds().contains(summary.getId())).collect(Collectors.toList());
        ResponseEntity response = ResponseEntity.ok(this.taskSummaryRepresentationModelAssembler.toPageModel(successfullyDeletedTaskSummaries));
        LOGGER.debug("Exit from deleteTasks(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> getTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getTask(taskId= {})", (Object)taskId);
        Task task = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> claimTask(@PathVariable String taskId, @RequestBody String userName) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        LOGGER.debug("Entry to claimTask(taskId= {}, userName= {})", (Object)taskId, (Object)userName);
        this.taskService.claim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from claimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/select-and-claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> selectAndClaimTask(@RequestParam MultiValueMap<String, String> params) throws InvalidOwnerException, NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to selectAndClaimTask");
        TaskQuery query = this.taskService.createTaskQuery();
        this.applyFilterParams(query, params);
        this.applySortingParams(query, params);
        Task selectedAndClaimedTask = this.taskService.selectAndClaim(query);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(selectedAndClaimedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from selectAndClaimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> cancelClaimTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        LOGGER.debug("Entry to cancelClaimTask(taskId= {}", (Object)taskId);
        this.taskService.cancelClaim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from cancelClaimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> completeTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("Entry to completeTask(taskId= {})", (Object)taskId);
        this.taskService.forceCompleteTask(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from completeTask(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> deleteTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("Entry to deleteTask(taskId= {})", (Object)taskId);
        this.taskService.forceDeleteTask(taskId);
        ResponseEntity result = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from deleteTask(), returning {}", (Object)result);
        return result;
    }

    @PostMapping(path={"/api/v1/tasks"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> createTask(@RequestBody TaskRepresentationModel taskRepresentationModel) throws WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException, TaskAlreadyExistException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createTask(params= {})", (Object)taskRepresentationModel);
        }
        Task fromResource = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        Task createdTask = this.taskService.createTask(fromResource);
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskRepresentationModelAssembler.toModel(createdTask));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/transfer/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> transferTask(@PathVariable String taskId, @PathVariable String workbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        LOGGER.debug("Entry to transferTask(taskId= {}, workbasketId= {})", (Object)taskId, (Object)workbasketId);
        Task updatedTask = this.taskService.transfer(taskId, workbasketId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from transferTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> updateTask(@PathVariable(value="taskId") String taskId, @RequestBody TaskRepresentationModel taskRepresentationModel) throws TaskNotFoundException, ClassificationNotFoundException, InvalidArgumentException, ConcurrencyException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException {
        LOGGER.debug("Entry to updateTask(taskId= {}, taskResource= {})", (Object)taskId, (Object)taskRepresentationModel);
        if (!taskId.equals(taskRepresentationModel.getTaskId())) {
            throw new InvalidArgumentException(String.format("TaskId ('%s') is not identical with the taskId of to object in the payload which should be updated. ID=('%s')", taskId, taskRepresentationModel.getTaskId()));
        }
        Task task = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        task = this.taskService.updateTask(task);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateTask(), returning {}", (Object)result);
        }
        return result;
    }

    private void applyFilterParams(TaskQuery taskQuery, MultiValueMap<String, String> params) throws InvalidArgumentException {
        TimeInterval timeInterval;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(taskQuery= {}, params= {})", (Object)taskQuery, params);
        }
        this.checkForIllegalParamCombinations(params);
        if (params.containsKey((Object)NAME)) {
            String[] names = this.extractCommaSeparatedFields((List)params.get((Object)NAME));
            taskQuery.nameIn(names);
            params.remove((Object)NAME);
        }
        if (params.containsKey((Object)NAME_LIKE)) {
            taskQuery.nameLike(new String[]{LIKE + (String)((List)params.get((Object)NAME_LIKE)).get(0) + LIKE});
            params.remove((Object)NAME_LIKE);
        }
        if (params.containsKey((Object)PRIORITY)) {
            String[] prioritiesInString = this.extractCommaSeparatedFields((List)params.get((Object)PRIORITY));
            int[] priorities = this.extractPriorities(prioritiesInString);
            taskQuery.priorityIn(priorities);
            params.remove((Object)PRIORITY);
        }
        if (params.containsKey((Object)STATE)) {
            TaskState[] states = this.extractStates(params);
            taskQuery.stateIn(states);
            params.remove((Object)STATE);
        }
        if (params.containsKey((Object)CLASSIFICATION_KEY)) {
            String[] classificationKeys = this.extractCommaSeparatedFields((List)params.get((Object)CLASSIFICATION_KEY));
            taskQuery.classificationKeyIn(classificationKeys);
            params.remove((Object)CLASSIFICATION_KEY);
        }
        if (params.containsKey((Object)TASK_ID)) {
            String[] taskIds = this.extractCommaSeparatedFields((List)params.get((Object)TASK_ID));
            taskQuery.idIn(taskIds);
            params.remove((Object)TASK_ID);
        }
        if (params.containsKey((Object)WORKBASKET_ID)) {
            String[] workbaskets = this.extractCommaSeparatedFields((List)params.get((Object)WORKBASKET_ID));
            taskQuery.workbasketIdIn(workbaskets);
            params.remove((Object)WORKBASKET_ID);
        }
        if (params.containsKey((Object)WORKBASKET_KEY)) {
            this.updateTaskQueryWithWorkbasketKey(taskQuery, params);
        }
        if (params.containsKey((Object)OWNER)) {
            String[] owners = this.extractCommaSeparatedFields((List)params.get((Object)OWNER));
            taskQuery.ownerIn(owners);
            params.remove((Object)OWNER);
        }
        if (params.containsKey((Object)OWNER_LIKE)) {
            taskQuery.ownerLike(new String[]{LIKE + (String)((List)params.get((Object)OWNER_LIKE)).get(0) + LIKE});
            params.remove((Object)OWNER_LIKE);
        }
        if (params.containsKey((Object)POR_COMPANY)) {
            String[] companies = this.extractCommaSeparatedFields((List)params.get((Object)POR_COMPANY));
            taskQuery.primaryObjectReferenceCompanyIn(companies);
            params.remove((Object)POR_COMPANY);
        }
        if (params.containsKey((Object)POR_SYSTEM)) {
            String[] systems = this.extractCommaSeparatedFields((List)params.get((Object)POR_SYSTEM));
            taskQuery.primaryObjectReferenceSystemIn(systems);
            params.remove((Object)POR_SYSTEM);
        }
        if (params.containsKey((Object)POR_SYSTEM_INSTANCE)) {
            String[] systemInstances = this.extractCommaSeparatedFields((List)params.get((Object)POR_SYSTEM_INSTANCE));
            taskQuery.primaryObjectReferenceSystemInstanceIn(systemInstances);
            params.remove((Object)POR_SYSTEM_INSTANCE);
        }
        if (params.containsKey((Object)POR_TYPE)) {
            taskQuery.primaryObjectReferenceTypeLike(new String[]{LIKE + (String)((List)params.get((Object)POR_TYPE)).get(0) + LIKE});
            params.remove((Object)POR_TYPE);
        }
        if (params.containsKey((Object)POR_VALUE)) {
            taskQuery.primaryObjectReferenceValueLike(new String[]{LIKE + (String)((List)params.get((Object)POR_VALUE)).get(0) + LIKE});
            params.remove((Object)POR_VALUE);
        }
        if (params.containsKey((Object)PLANNED)) {
            this.updateTaskQueryWithPlannedOrDueTimeIntervals(taskQuery, params, PLANNED);
        }
        if (params.containsKey((Object)DUE)) {
            this.updateTaskQueryWithPlannedOrDueTimeIntervals(taskQuery, params, DUE);
        }
        if (params.containsKey((Object)PLANNED_FROM) && params.containsKey((Object)PLANNED_UNTIL)) {
            this.updateTaskQueryWithPlannedOrDueTimeInterval(taskQuery, params, PLANNED_FROM, PLANNED_UNTIL);
        } else if (params.containsKey((Object)PLANNED_FROM) && !params.containsKey((Object)PLANNED_UNTIL)) {
            timeInterval = this.createIndefiniteTimeIntervalFromParam(params, PLANNED_FROM);
            this.updateTaskQueryWithIndefiniteTimeInterval(taskQuery, params, PLANNED_FROM, timeInterval);
        } else if (!params.containsKey((Object)PLANNED_FROM) && params.containsKey((Object)PLANNED_UNTIL)) {
            timeInterval = this.createIndefiniteTimeIntervalFromParam(params, PLANNED_UNTIL);
            this.updateTaskQueryWithIndefiniteTimeInterval(taskQuery, params, PLANNED_UNTIL, timeInterval);
        }
        if (params.containsKey((Object)DUE_FROM) && params.containsKey((Object)DUE_TO)) {
            this.updateTaskQueryWithPlannedOrDueTimeInterval(taskQuery, params, DUE_FROM, DUE_TO);
        } else if (params.containsKey((Object)DUE_FROM) && !params.containsKey((Object)DUE_TO)) {
            TimeInterval indefiniteTimeInterval = this.createIndefiniteTimeIntervalFromParam(params, DUE_FROM);
            this.updateTaskQueryWithIndefiniteTimeInterval(taskQuery, params, DUE_FROM, indefiniteTimeInterval);
        } else if (!params.containsKey((Object)DUE_FROM) && params.containsKey((Object)DUE_TO)) {
            timeInterval = this.createIndefiniteTimeIntervalFromParam(params, DUE_TO);
            this.updateTaskQueryWithIndefiniteTimeInterval(taskQuery, params, DUE_TO, timeInterval);
        }
        if (params.containsKey((Object)WILDCARD_SEARCH_FIELDS) && params.containsKey((Object)WILDCARD_SEARCH_VALUE)) {
            String[] requestedWildcardSearchFields = this.extractCommaSeparatedFields((List)params.get((Object)WILDCARD_SEARCH_FIELDS));
            taskQuery.wildcardSearchFieldsIn(this.createWildcardSearchFields(requestedWildcardSearchFields));
            taskQuery.wildcardSearchValueLike((String)params.getFirst((Object)WILDCARD_SEARCH_VALUE));
            params.remove((Object)WILDCARD_SEARCH_FIELDS);
            params.remove((Object)WILDCARD_SEARCH_VALUE);
        }
        if (params.containsKey((Object)EXTERNAL_ID)) {
            String[] externalIds = this.extractCommaSeparatedFields((List)params.get((Object)EXTERNAL_ID));
            taskQuery.externalIdIn(externalIds);
            params.remove((Object)EXTERNAL_ID);
        }
        for (TaskCustomField customField : TaskCustomField.values()) {
            List customFieldParams = (List)params.remove((Object)customField.name().replace("_", INDEFINITE).toLowerCase());
            if (customFieldParams == null) continue;
            String[] customValues = this.extractCommaSeparatedFields(customFieldParams);
            taskQuery.customAttributeIn(customField, customValues);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)taskQuery);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), query: {}", (Object)taskQuery);
        }
    }

    private WildcardSearchField[] createWildcardSearchFields(String[] wildcardFields) {
        return (WildcardSearchField[])Stream.of(wildcardFields).map(WildcardSearchField::fromString).filter(Objects::nonNull).toArray(WildcardSearchField[]::new);
    }

    private void updateTaskQueryWithWorkbasketKey(TaskQuery taskQuery, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String[] domains = null;
        if (params.get((Object)DOMAIN) != null) {
            domains = this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN));
        }
        if (domains == null || domains.length != 1) {
            throw new InvalidArgumentException("workbasket-key requires excactly one domain as second parameter.");
        }
        String[] workbasketKeys = this.extractCommaSeparatedFields((List)params.get((Object)WORKBASKET_KEY));
        KeyDomain[] keyDomains = new KeyDomain[workbasketKeys.length];
        for (int i = 0; i < workbasketKeys.length; ++i) {
            keyDomains[i] = new KeyDomain(workbasketKeys[i], domains[0]);
        }
        taskQuery.workbasketKeyDomainIn(keyDomains);
        params.remove((Object)WORKBASKET_KEY);
        params.remove((Object)DOMAIN);
    }

    private void checkForIllegalParamCombinations(MultiValueMap<String, String> params) {
        if (params.containsKey((Object)PLANNED) && (params.containsKey((Object)PLANNED_FROM) || params.containsKey((Object)PLANNED_UNTIL))) {
            throw new IllegalArgumentException("It is prohibited to use the param \"planned\" in combination with the params \"planned-from\" and / or \"planned-until\"");
        }
        if (params.containsKey((Object)DUE) && (params.containsKey((Object)DUE_FROM) || params.containsKey((Object)DUE_TO))) {
            throw new IllegalArgumentException("It is prohibited to use the param \"due\" in combination with the params \"planned-from\" and / or \"planned-until\"");
        }
        if (params.containsKey((Object)WILDCARD_SEARCH_FIELDS) && !params.containsKey((Object)WILDCARD_SEARCH_VALUE) || !params.containsKey((Object)WILDCARD_SEARCH_FIELDS) && params.containsKey((Object)WILDCARD_SEARCH_VALUE)) {
            throw new IllegalArgumentException("The params wildcard-search-fields and wildcard-search-value must be used together!");
        }
    }

    private void updateTaskQueryWithIndefiniteTimeInterval(TaskQuery taskQuery, MultiValueMap<String, String> params, String param, TimeInterval timeInterval) {
        if (param.equals(PLANNED_FROM) || param.equals(PLANNED_UNTIL)) {
            taskQuery.plannedWithin(new TimeInterval[]{timeInterval});
        } else {
            taskQuery.dueWithin(new TimeInterval[]{timeInterval});
        }
        params.remove((Object)param);
    }

    private TimeInterval createIndefiniteTimeIntervalFromParam(MultiValueMap<String, String> params, String param) {
        if (param.equals(PLANNED_FROM) || param.equals(DUE_FROM)) {
            return new TimeInterval(Instant.parse((CharSequence)((List)params.get((Object)param)).get(0)), null);
        }
        return new TimeInterval(null, Instant.parse((CharSequence)((List)params.get((Object)param)).get(0)));
    }

    private void updateTaskQueryWithPlannedOrDueTimeInterval(TaskQuery taskQuery, MultiValueMap<String, String> params, String plannedFromOrDueFrom, String plannedToOrDueTo) {
        TimeInterval timeInterval = new TimeInterval(Instant.parse((CharSequence)((List)params.get((Object)plannedFromOrDueFrom)).get(0)), Instant.parse((CharSequence)((List)params.get((Object)plannedToOrDueTo)).get(0)));
        taskQuery.plannedWithin(new TimeInterval[]{timeInterval});
        params.remove((Object)plannedToOrDueTo);
        params.remove((Object)plannedFromOrDueFrom);
    }

    private void updateTaskQueryWithPlannedOrDueTimeIntervals(TaskQuery taskQuery, MultiValueMap<String, String> params, String plannedOrDue) {
        String[] instants = this.extractCommaSeparatedFields((List)params.get((Object)plannedOrDue));
        TimeInterval[] timeIntervals = this.extractTimeIntervals(instants);
        taskQuery.plannedWithin(timeIntervals);
        params.remove((Object)plannedOrDue);
    }

    private TimeInterval[] extractTimeIntervals(String[] instants) {
        ArrayList<TimeInterval> timeIntervalsList = new ArrayList<TimeInterval>();
        for (int i = 0; i < instants.length - 1; i += 2) {
            TimeInterval timeInterval = this.determineTimeInterval(instants, i);
            if (timeInterval == null) continue;
            timeIntervalsList.add(timeInterval);
        }
        TimeInterval[] timeIntervalArray = new TimeInterval[timeIntervalsList.size()];
        return timeIntervalsList.toArray(timeIntervalArray);
    }

    private TimeInterval determineTimeInterval(String[] instants, int i) {
        if (!instants[i].equals(INDEFINITE) && !instants[i + 1].equals(INDEFINITE)) {
            return new TimeInterval(Instant.parse(instants[i]), Instant.parse(instants[i + 1]));
        }
        if (instants[i].equals(INDEFINITE) && !instants[i + 1].equals(INDEFINITE)) {
            return new TimeInterval(null, Instant.parse(instants[i + 1]));
        }
        if (!instants[i].equals(INDEFINITE) && instants[i + 1].equals(INDEFINITE)) {
            return new TimeInterval(Instant.parse(instants[i]), null);
        }
        return null;
    }

    private void applySortingParams(TaskQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(query= {}, params= {})", (Object)query, params);
        }
        QueryHelper.applyAndRemoveSortingParams(params, (CheckedBiConsumer<String, BaseQuery.SortDirection, InvalidArgumentException>)((CheckedBiConsumer)(sortBy, sortDirection) -> {
            switch (sortBy) {
                case "classification.key": {
                    query.orderByClassificationKey(sortDirection);
                    break;
                }
                case "por.type": {
                    query.orderByPrimaryObjectReferenceType(sortDirection);
                    break;
                }
                case "por.value": {
                    query.orderByPrimaryObjectReferenceValue(sortDirection);
                    break;
                }
                case "state": {
                    query.orderByState(sortDirection);
                    break;
                }
                case "name": {
                    query.orderByName(sortDirection);
                    break;
                }
                case "due": {
                    query.orderByDue(sortDirection);
                    break;
                }
                case "planned": {
                    query.orderByPlanned(sortDirection);
                    break;
                }
                case "priority": {
                    query.orderByPriority(sortDirection);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown filter attribute: " + sortBy);
                }
            }
        }));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", (Object)query);
        }
    }

    private int[] extractPriorities(String[] prioritiesInString) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to extractPriorities(prioritiesInString= {})", (Object[])prioritiesInString);
        }
        int[] priorities = new int[prioritiesInString.length];
        for (int i = 0; i < prioritiesInString.length; ++i) {
            priorities[i] = Integer.parseInt(prioritiesInString[i]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from extractPriorities(), returning {}", (Object)priorities);
        }
        return priorities;
    }

    private TaskState[] extractStates(MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to extractStates(params= {})", params);
        }
        ArrayList<TaskState> states = new ArrayList<TaskState>();
        for (String item : (List)params.get((Object)STATE)) {
            String[] stringArray = item.split(",");
            int n = stringArray.length;
            block11: for (int i = 0; i < n; ++i) {
                String state;
                switch (state = stringArray[i]) {
                    case "READY": {
                        states.add(TaskState.READY);
                        continue block11;
                    }
                    case "COMPLETED": {
                        states.add(TaskState.COMPLETED);
                        continue block11;
                    }
                    case "CLAIMED": {
                        states.add(TaskState.CLAIMED);
                        continue block11;
                    }
                    default: {
                        throw new InvalidArgumentException("Unknown status '" + state + "'");
                    }
                }
            }
        }
        LOGGER.debug("Exit from extractStates()");
        return states.toArray(new TaskState[0]);
    }
}

