/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.assembler.ClassificationRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.rest.models.TaskanaPagedModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationDefinitionController.class);
    private final ObjectMapper mapper;
    private final ClassificationService classificationService;
    private final ClassificationRepresentationModelAssembler classificationRepresentationModelAssembler;

    @Autowired
    ClassificationDefinitionController(ObjectMapper mapper, ClassificationService classificationService, ClassificationRepresentationModelAssembler classificationRepresentationModelAssembler) {
        this.mapper = mapper;
        this.classificationService = classificationService;
        this.classificationRepresentationModelAssembler = classificationRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/classification-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaPagedModel<ClassificationRepresentationModel>> exportClassifications(@RequestParam(required=false) String domain) {
        LOGGER.debug("Entry to exportClassifications(domain= {})", (Object)domain);
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        List summaries = domain != null ? query.domainIn(new String[]{domain}).list() : query.list();
        TaskanaPagedModel pageModel = summaries.stream().map(ClassificationSummary::getId).map(CheckedFunction.wrap(arg_0 -> ((ClassificationService)this.classificationService).getClassification(arg_0))).collect(Collectors.collectingAndThen(Collectors.toList(), this.classificationRepresentationModelAssembler::toPageModel));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pageModel));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportClassifications(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/classification-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importClassifications(@RequestParam(value="file") MultipartFile file) throws InvalidArgumentException, NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, ClassificationAlreadyExistException, DomainNotFoundException, IOException {
        LOGGER.debug("Entry to importClassifications()");
        Map<String, String> systemIds = this.getSystemIds();
        TaskanaPagedModel<ClassificationRepresentationModel> classificationsResources = this.extractClassificationResourcesFromFile(file);
        this.checkForDuplicates(classificationsResources.getContent());
        Map<Classification, String> childrenInFile = this.mapChildrenToParentKeys(classificationsResources.getContent(), systemIds);
        this.insertOrUpdateClassificationsWithoutParent(classificationsResources.getContent(), systemIds);
        this.updateParentChildrenRelations(childrenInFile);
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from importClassifications(), returning {}", (Object)response);
        return response;
    }

    private Map<String, String> getSystemIds() {
        return this.classificationService.createClassificationQuery().list().stream().collect(Collectors.toMap(i -> i.getKey() + "|" + i.getDomain(), ClassificationSummary::getId));
    }

    private TaskanaPagedModel<ClassificationRepresentationModel> extractClassificationResourcesFromFile(MultipartFile file) throws IOException {
        return (TaskanaPagedModel)((Object)this.mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<TaskanaPagedModel<ClassificationRepresentationModel>>(){}));
    }

    private void checkForDuplicates(Collection<ClassificationRepresentationModel> classificationList) {
        ArrayList<String> identifiers = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (ClassificationRepresentationModel classification : classificationList) {
            String identifier = classification.getKey() + "|" + classification.getDomain();
            if (identifiers.contains(identifier)) {
                duplicates.add(identifier);
                continue;
            }
            identifiers.add(identifier);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException("The 'key|domain'-identifier is not unique for the value(s): " + ((Object)duplicates).toString());
        }
    }

    private Map<Classification, String> mapChildrenToParentKeys(Collection<ClassificationRepresentationModel> classificationRepresentationModels, Map<String, String> systemIds) {
        LOGGER.debug("Entry to mapChildrenToParentKeys()");
        HashMap<Classification, String> childrenInFile = new HashMap<Classification, String>();
        HashSet newKeysWithDomain = new HashSet();
        classificationRepresentationModels.forEach(cl -> newKeysWithDomain.add(cl.getKey() + "|" + cl.getDomain()));
        for (ClassificationRepresentationModel cl2 : classificationRepresentationModels) {
            cl2.setParentId(cl2.getParentId() == null ? "" : cl2.getParentId());
            cl2.setParentKey(cl2.getParentKey() == null ? "" : cl2.getParentKey());
            if (!cl2.getParentId().equals("") && cl2.getParentKey().equals("")) {
                for (ClassificationRepresentationModel parent : classificationRepresentationModels) {
                    if (!cl2.getParentId().equals(parent.getClassificationId())) continue;
                    cl2.setParentKey(parent.getKey());
                }
            }
            String parentKeyAndDomain = cl2.getParentKey() + "|" + cl2.getDomain();
            if (cl2.getParentKey().isEmpty() || cl2.getParentKey().equals("") || !newKeysWithDomain.contains(parentKeyAndDomain) && !systemIds.containsKey(parentKeyAndDomain)) continue;
            childrenInFile.put(this.classificationRepresentationModelAssembler.toEntityModel(cl2), cl2.getParentKey());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from mapChildrenToParentKeys(), returning {}", childrenInFile);
        }
        return childrenInFile;
    }

    private void insertOrUpdateClassificationsWithoutParent(Collection<ClassificationRepresentationModel> classificationRepresentationModels, Map<String, String> systemIds) throws ClassificationNotFoundException, NotAuthorizedException, InvalidArgumentException, ClassificationAlreadyExistException, DomainNotFoundException, ConcurrencyException {
        LOGGER.debug("Entry to insertOrUpdateClassificationsWithoutParent()");
        for (ClassificationRepresentationModel classificationRepresentationModel : classificationRepresentationModels) {
            classificationRepresentationModel.setParentKey(null);
            classificationRepresentationModel.setParentId(null);
            classificationRepresentationModel.setClassificationId(null);
            String systemId = systemIds.get(classificationRepresentationModel.getKey() + "|" + classificationRepresentationModel.getDomain());
            if (systemId != null) {
                this.updateExistingClassification(classificationRepresentationModel, systemId);
                continue;
            }
            this.classificationService.createClassification(this.classificationRepresentationModelAssembler.toEntityModel(classificationRepresentationModel));
        }
        LOGGER.debug("Exit from insertOrUpdateClassificationsWithoutParent()");
    }

    private void updateParentChildrenRelations(Map<Classification, String> childrenInFile) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateParentChildrenRelations()");
        for (Map.Entry<Classification, String> entry : childrenInFile.entrySet()) {
            Classification childRes = entry.getKey();
            String parentKey = entry.getValue();
            String classificationKey = childRes.getKey();
            String classificationDomain = childRes.getDomain();
            Classification child = this.classificationService.getClassification(classificationKey, classificationDomain);
            String parentId = parentKey == null ? "" : this.classificationService.getClassification(parentKey, classificationDomain).getId();
            child.setParentKey(parentKey);
            child.setParentId(parentId);
            this.classificationService.updateClassification(child);
        }
        LOGGER.debug("Exit from updateParentChildrenRelations()");
    }

    private void updateExistingClassification(ClassificationRepresentationModel cl, String systemId) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateExistingClassification()");
        Classification currentClassification = this.classificationService.getClassification(systemId);
        if (cl.getType() != null && !cl.getType().equals(currentClassification.getType())) {
            throw new InvalidArgumentException("Can not change the type of a classification.");
        }
        currentClassification.setCategory(cl.getCategory());
        currentClassification.setIsValidInDomain(cl.getIsValidInDomain());
        currentClassification.setName(cl.getName());
        currentClassification.setParentId(cl.getParentId());
        currentClassification.setParentKey(cl.getParentKey());
        currentClassification.setDescription(cl.getDescription());
        currentClassification.setPriority(cl.getPriority());
        currentClassification.setServiceLevel(cl.getServiceLevel());
        currentClassification.setApplicationEntryPoint(cl.getApplicationEntryPoint());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_1, cl.getCustom1());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_2, cl.getCustom2());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_3, cl.getCustom3());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_4, cl.getCustom4());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_5, cl.getCustom5());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_6, cl.getCustom6());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_7, cl.getCustom7());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_8, cl.getCustom8());
        this.classificationService.updateClassification(currentClassification);
        LOGGER.debug("Exit from updateExistingClassification()");
    }
}

