/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import pro.taskana.common.rest.models.TaskanaPagedModelKeys;

public class TaskanaPagedModel<T extends RepresentationModel<? super T>>
extends RepresentationModel<TaskanaPagedModel<T>> {
    @JsonIgnore
    private TaskanaPagedModelKeys key;
    @JsonIgnore
    private Collection<? extends T> content;
    @JsonProperty(value="page", access=JsonProperty.Access.WRITE_ONLY)
    private PagedModel.PageMetadata metadata;

    private TaskanaPagedModel() {
    }

    public TaskanaPagedModel(TaskanaPagedModelKeys property, Collection<? extends T> content, PagedModel.PageMetadata metadata) {
        this.content = content;
        this.metadata = metadata;
        this.key = property;
    }

    public TaskanaPagedModel(TaskanaPagedModelKeys property, Collection<? extends T> content) {
        this(property, content, null);
    }

    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }

    public PagedModel.PageMetadata getMetadata() {
        return this.metadata;
    }

    public TaskanaPagedModelKeys getKey() {
        return this.key;
    }

    @JsonAnySetter
    private void deserialize(String propertyName, Collection<T> content) {
        TaskanaPagedModelKeys.getEnumFromPropertyName(propertyName).ifPresent(pagedModelKey -> {
            this.key = pagedModelKey;
            this.content = content;
        });
    }

    @JsonAnyGetter
    private Map<String, Object> serialize() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        if (this.metadata != null) {
            jsonMap.put("page", this.metadata);
        }
        jsonMap.put(this.key.getPropertyName(), this.content);
        return jsonMap;
    }
}

