/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest.assembler;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.Report;
import pro.taskana.monitor.api.reports.TaskStatusReport;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.ColumnHeader;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.FoldableRow;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.api.reports.row.SingleRow;
import pro.taskana.monitor.rest.MonitorController;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskState;

@Component
public class ReportRepresentationModelAssembler {
    @NonNull
    public ReportRepresentationModel toModel(@NonNull TaskStatusReport report, @NonNull List<String> domains, @NonNull List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksStatusReport(domains, states)).withSelfRel().expand(new Object[0]));
        return resource;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull ClassificationReport report) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksClassificationReport()).withSelfRel().expand(new Object[0]));
        return resource;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketReport report, @NonNull List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksWorkbasketReport(states)).withSelfRel().expand(new Object[0]));
        return resource;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketReport report, int daysInPast, @NonNull List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksWorkbasketPlannedDateReport(daysInPast, states)).withSelfRel().expand(new Object[0]));
        return resource;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull TimestampReport report) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getDailyEntryExitReport()).withSelfRel().expand(new Object[0]));
        return resource;
    }

    public <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report, Instant time) {
        String[] header = (String[])report.getColumnHeaders().stream().map(ColumnHeader::getDisplayName).toArray(String[]::new);
        ReportRepresentationModel.MetaInformation meta = new ReportRepresentationModel.MetaInformation(report.getClass().getSimpleName(), time.toString(), header, report.getRowDesc(), report.getSumRow().getKey());
        List<ReportRepresentationModel.RowResource> rows = report.getRows().values().stream().sorted(Comparator.comparing(e -> e.getKey().toLowerCase())).map(i -> this.transformRow((Row)i, new String[report.getRowDesc().length], 0)).flatMap(Collection::stream).collect(Collectors.toList());
        List<ReportRepresentationModel.RowResource> sumRow = this.transformRow(report.getSumRow(), new String[report.getRowDesc().length], 0);
        return new ReportRepresentationModel(meta, rows, sumRow);
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report) {
        return this.toReportResource(report, Instant.now());
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowResource> transformRow(Row<I> row, String[] desc, int depth) {
        if (row.getClass() == SingleRow.class) {
            return Collections.singletonList(this.transformSingleRow((SingleRow)row, desc, depth));
        }
        return this.transformFoldableRow((FoldableRow)row, desc, depth);
    }

    private <I extends QueryItem> ReportRepresentationModel.RowResource transformSingleRow(SingleRow<I> row, String[] previousRowDesc, int depth) {
        String[] rowDesc = new String[previousRowDesc.length];
        System.arraycopy(previousRowDesc, 0, rowDesc, 0, depth);
        rowDesc[depth] = row.getDisplayName();
        return new ReportRepresentationModel.RowResource(row.getCells(), row.getTotalValue(), depth, rowDesc, depth == 0);
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowResource> transformFoldableRow(FoldableRow<I> row, String[] previousRowDesc, int depth) {
        ReportRepresentationModel.RowResource baseRow = this.transformSingleRow((SingleRow<I>)row, previousRowDesc, depth);
        LinkedList<ReportRepresentationModel.RowResource> rowList = new LinkedList<ReportRepresentationModel.RowResource>();
        rowList.add(baseRow);
        row.getFoldableRowKeySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(s -> this.transformRow(row.getFoldableRow(s), baseRow.getDesc(), depth + 1)).flatMap(Collection::stream).forEachOrdered(rowList::add);
        return rowList;
    }
}

