/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest.models;

import java.util.Arrays;
import java.util.List;
import org.springframework.hateoas.RepresentationModel;

public class ReportRepresentationModel
extends RepresentationModel<ReportRepresentationModel> {
    private final MetaInformation meta;
    private final List<RowResource> rows;
    private final List<RowResource> sumRow;

    public ReportRepresentationModel(MetaInformation meta, List<RowResource> rows, List<RowResource> sumRow) {
        this.meta = meta;
        this.rows = rows;
        this.sumRow = sumRow;
    }

    public MetaInformation getMeta() {
        return this.meta;
    }

    public List<RowResource> getRows() {
        return this.rows;
    }

    public List<RowResource> getSumRow() {
        return this.sumRow;
    }

    public static class MetaInformation {
        private final String name;
        private final String date;
        private final String[] header;
        private final String[] rowDesc;
        private final String totalDesc;

        public MetaInformation(String name, String date, String[] header, String[] rowDesc, String totalDesc) {
            this.name = name;
            this.date = date;
            this.header = header;
            this.rowDesc = rowDesc;
            this.totalDesc = totalDesc;
        }

        public String getTotalDesc() {
            return this.totalDesc;
        }

        public String getName() {
            return this.name;
        }

        public String getDate() {
            return this.date;
        }

        public String[] getHeader() {
            return this.header;
        }

        public String[] getRowDesc() {
            return this.rowDesc;
        }

        public String toString() {
            return String.format("MetaInformation [name= %s, date= %s, header= %s, rowDesc= %s]", this.name, this.date, Arrays.toString(this.header), Arrays.toString(this.rowDesc));
        }
    }

    public static class RowResource {
        private final int[] cells;
        private final int total;
        private final int depth;
        private final String[] desc;
        private final boolean display;

        public RowResource(int[] cells, int total, int depth, String[] desc, boolean display) {
            this.cells = cells;
            this.total = total;
            this.depth = depth;
            this.desc = desc;
            this.display = display;
        }

        public int[] getCells() {
            return this.cells;
        }

        public int getTotal() {
            return this.total;
        }

        public int getDepth() {
            return this.depth;
        }

        public String[] getDesc() {
            return this.desc;
        }

        public boolean isDisplay() {
            return this.display;
        }

        public String toString() {
            return String.format("RowResourde [cells=%s, total=%d, depth=%d, desc=%s", Arrays.toString(this.cells), this.total, this.depth, Arrays.toString(this.desc));
        }
    }
}

