/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.assembler;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.models.PageMetadata;
import pro.taskana.common.rest.models.PagedRepresentationModel;

public interface PagedRepresentationModelAssembler<T, D extends RepresentationModel<? super D>, P extends PagedRepresentationModel<D>>
extends RepresentationModelAssembler<T, D> {
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public P buildPageableEntity(Collection<D> var1, PageMetadata var2);

    default public P toPagedModel(Iterable<T> entities, PageMetadata pageMetadata) {
        PagedRepresentationModel pagedRepresentationModel;
        PagedRepresentationModel pagedRepresentationModel2;
        Iterable<T> iterable = entities;
        PageMetadata pageMetadata2 = pageMetadata;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, iterable, (Object)pageMetadata2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PagedRepresentationModel pagedRepresentationModel3 = pagedRepresentationModel2 = (pagedRepresentationModel = StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((PagedRepresentationModelAssembler)this).toModel(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), content -> this.addLinksToPagedModel(this.buildPageableEntity((Collection<D>)content, pageMetadata)))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pagedRepresentationModel2);
        return (P)((Object)pagedRepresentationModel);
    }

    default public P addLinksToPagedModel(P model) {
        P p;
        P p2;
        P p3 = model;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, p3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServletUriComponentsBuilder original = ServletUriComponentsBuilder.fromCurrentRequest();
        PageMetadata page = ((PagedRepresentationModel)((Object)model)).getPageMetadata();
        model.add(Link.of((String)original.toUriString()).withSelfRel());
        if (page != null) {
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel(IanaLinkRelations.FIRST));
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getTotalPages()}).toUriString()).withRel(IanaLinkRelations.LAST));
            if (page.getNumber() > 1L) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() - 1L}).toUriString()).withRel(IanaLinkRelations.PREV));
            }
            if (page.getNumber() < page.getTotalPages()) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() + 1L}).toUriString()).withRel(IanaLinkRelations.NEXT));
            }
        }
        P p4 = p2 = (p = model);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, p2);
        return p;
    }

    static {
        Factory factory = new Factory("PagedRepresentationModelAssembler.java", PagedRepresentationModelAssembler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toPagedModel", "pro.taskana.common.rest.assembler.PagedRepresentationModelAssembler", "java.lang.Iterable:pro.taskana.common.rest.models.PageMetadata", "entities:pageMetadata", "", "pro.taskana.common.rest.models.PagedRepresentationModel"), 22);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addLinksToPagedModel", "pro.taskana.common.rest.assembler.PagedRepresentationModelAssembler", "pro.taskana.common.rest.models.PagedRepresentationModel", "model", "", "pro.taskana.common.rest.models.PagedRepresentationModel"), 31);
    }
}

