/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.user.rest;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.user.api.UserService;
import pro.taskana.user.api.exceptions.UserAlreadyExistException;
import pro.taskana.user.api.exceptions.UserNotFoundException;
import pro.taskana.user.api.models.User;
import pro.taskana.user.rest.assembler.UserRepresentationModelAssembler;
import pro.taskana.user.rest.models.UserRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class UserController {
    private final UserService userService;
    private final UserRepresentationModelAssembler assembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Autowired
    UserController(UserService userService, UserRepresentationModelAssembler assembler) {
        this.userService = userService;
        this.assembler = assembler;
    }

    @GetMapping(value={"/api/v1/users/{userId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> getUser(@PathVariable String userId) throws UserNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        User user = this.userService.getUser(userId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.assembler.toModel(user))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(value={"/api/v1/users"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> createUser(@RequestBody UserRepresentationModel repModel) throws InvalidArgumentException, UserAlreadyExistException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        UserRepresentationModel userRepresentationModel = repModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)userRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        User user = this.assembler.toEntityModel(repModel);
        user = this.userService.createUser(user);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.assembler.toModel(user)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(value={"/api/v1/users/{userId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> updateUser(@PathVariable(value="userId") String userId, @RequestBody UserRepresentationModel repModel) throws InvalidArgumentException, UserNotFoundException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        UserRepresentationModel userRepresentationModel = repModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)((Object)userRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!userId.equals(repModel.getUserId())) {
            throw new InvalidArgumentException(String.format("UserId '%s' of the URI is not identical with the userId '%s' of the object in the payload.", userId, repModel.getUserId()));
        }
        User user = this.assembler.toEntityModel(repModel);
        user = this.userService.updateUser(user);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.assembler.toModel(user))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(value={"/api/v1/users/{userId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> deleteUser(@PathVariable String userId) throws UserNotFoundException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.userService.deleteUser(userId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        UserController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserController.java", UserController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUser", "pro.taskana.user.rest.UserController", "java.lang.String", "userId", "pro.taskana.user.api.exceptions.UserNotFoundException", "org.springframework.http.ResponseEntity"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "pro.taskana.user.rest.UserController", "pro.taskana.user.rest.models.UserRepresentationModel", "repModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.user.api.exceptions.UserAlreadyExistException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 71);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUser", "pro.taskana.user.rest.UserController", "java.lang.String:pro.taskana.user.rest.models.UserRepresentationModel", "userId:repModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "pro.taskana.user.rest.UserController", "java.lang.String", "userId", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 120);
    }
}

