/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.user.jobs;

import java.sql.PreparedStatement;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.util.ApplicationContextProvider;
import pro.taskana.task.internal.jobs.helper.SqlConnectionRunner;
import pro.taskana.user.api.exceptions.UserAlreadyExistException;
import pro.taskana.user.api.exceptions.UserNotFoundException;
import pro.taskana.user.api.models.User;

public class UserInfoRefreshJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private final SqlConnectionRunner sqlConnectionRunner;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        UserInfoRefreshJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(UserInfoRefreshJob.class);
    }

    public UserInfoRefreshJob(TaskanaEngine taskanaEngine) {
        this(taskanaEngine, null, null);
    }

    public UserInfoRefreshJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob, true);
        this.runEvery = taskanaEngine.getConfiguration().getUserRefreshJobRunEvery();
        this.firstRun = taskanaEngine.getConfiguration().getUserRefreshJobFirstRun();
        this.sqlConnectionRunner = new SqlConnectionRunner(taskanaEngine);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        UserInfoRefreshJob job = new UserInfoRefreshJob(taskanaEngine);
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = UserInfoRefreshJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    protected void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running job to refresh all user info");
        LdapClient ldapClient = (LdapClient)ApplicationContextProvider.getApplicationContext().getBean("ldapClient", LdapClient.class);
        try {
            List<User> users = ldapClient.searchUsersInUserRole();
            this.addExistingConfigurationDataToUsers(users);
            this.clearExistingUsers();
            this.insertNewUsers(users);
            LOGGER.info("Job to refresh all user info has finished.");
        }
        catch (Exception e) {
            throw new SystemException("Error while processing UserRefreshJob.", (Throwable)e);
        }
        Object var4_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_5);
    }

    private void clearExistingUsers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.sqlConnectionRunner.runWithConnection(connection -> {
            String sql = "DELETE FROM USER_INFO";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.execute();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        });
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private void insertNewUsers(List<User> users) {
        List<User> list = users;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        users.forEach(user -> {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to insert user {}", user);
                }
                this.taskanaEngineImpl.getUserService().createUser(user);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully inserted user {}", user);
                }
            }
            catch (InvalidArgumentException | NotAuthorizedException | UserAlreadyExistException e) {
                throw new SystemException("Caught Exception while trying to insert new User", e);
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void addExistingConfigurationDataToUsers(List<User> users) {
        List<User> list = users;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        users.forEach(user -> {
            block5: {
                try {
                    String userData = this.taskanaEngineImpl.getUserService().getUser(user.getId()).getData();
                    if (userData != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Trying to set userData {} for user {}", (Object)userData, user);
                        }
                        user.setData(this.taskanaEngineImpl.getUserService().getUser(user.getId()).getData());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Successfully set userData {} for user {}", (Object)userData, user);
                        }
                    }
                }
                catch (UserNotFoundException userNotFoundException) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug(String.format("Failed to fetch configuration data for User with ID '%s' because it doesn't exist", user.getId()));
                }
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserInfoRefreshJob.java", UserInfoRefreshJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.user.jobs.UserInfoRefreshJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.user.jobs.UserInfoRefreshJob", "", "", "", "java.lang.String"), 57);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "execute", "pro.taskana.user.jobs.UserInfoRefreshJob", "", "", "", "void"), 62);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "clearExistingUsers", "pro.taskana.user.jobs.UserInfoRefreshJob", "", "", "", "void"), 82);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertNewUsers", "pro.taskana.user.jobs.UserInfoRefreshJob", "java.util.List", "users", "", "void"), 96);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addExistingConfigurationDataToUsers", "pro.taskana.user.jobs.UserInfoRefreshJob", "java.util.List", "users", "", "void"), 116);
    }
}

