/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.ConfigurationService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.models.CustomAttributesRepresentationModel;
import pro.taskana.common.rest.models.TaskanaUserInfoRepresentationModel;
import pro.taskana.common.rest.models.VersionRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskanaEngineController {
    private final TaskanaEngineConfiguration taskanaEngineConfiguration;
    private final TaskanaEngine taskanaEngine;
    private final CurrentUserContext currentUserContext;
    private final ConfigurationService configurationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    @Autowired
    TaskanaEngineController(TaskanaEngineConfiguration taskanaEngineConfiguration, TaskanaEngine taskanaEngine, CurrentUserContext currentUserContext, ConfigurationService configurationService) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.taskanaEngine = taskanaEngine;
        this.currentUserContext = currentUserContext;
        this.configurationService = configurationService;
    }

    @GetMapping(path={"/api/v1/domains"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<String>> getDomains() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getDomains()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/classification-categories"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<String>> getClassificationCategories(@RequestParam(required=false) String type) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = type != null ? (responseEntity = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByType(type))) : (responseEntity = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getAllClassificationCategories()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/classification-types"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<String>> getClassificationTypes() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationTypes()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/classifications-by-type"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Map<String, List<String>>> getClassificationCategoriesByTypeMap() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByTypeMap()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/current-user-info"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskanaUserInfoRepresentationModel> getCurrentUserInfo() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaUserInfoRepresentationModel resource = new TaskanaUserInfoRepresentationModel();
        resource.setUserId(this.currentUserContext.getUserid());
        resource.setGroupIds(this.currentUserContext.getGroupIds());
        this.taskanaEngineConfiguration.getRoleMap().keySet().stream().filter(taskanaRole -> this.taskanaEngine.isUserInRole(new TaskanaRole[]{taskanaRole})).forEach(resource.getRoles()::add);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)resource)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/history-provider-enabled"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Boolean> getIsHistoryProviderEnabled() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)this.taskanaEngine.isHistoryEnabled()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/config/custom-attributes"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<CustomAttributesRepresentationModel> getCustomAttributes() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map allCustomAttributes = this.configurationService.getAllCustomAttributes();
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)new CustomAttributesRepresentationModel(allCustomAttributes))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/config/custom-attributes"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<CustomAttributesRepresentationModel> setCustomAttributes(@RequestBody CustomAttributesRepresentationModel customAttributes) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        CustomAttributesRepresentationModel customAttributesRepresentationModel = customAttributes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)((Object)customAttributesRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.configurationService.setAllCustomAttributes(customAttributes.getCustomAttributes());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)customAttributes)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/version"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<VersionRepresentationModel> currentVersion() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        VersionRepresentationModel resource = new VersionRepresentationModel();
        resource.setVersion(TaskanaEngineConfiguration.class.getPackage().getImplementationVersion());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)resource)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskanaEngineController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaEngineController.java", TaskanaEngineController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomains", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategories", "pro.taskana.common.rest.TaskanaEngineController", "java.lang.String", "type", "", "org.springframework.http.ResponseEntity"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationTypes", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 81);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByTypeMap", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 93);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentUserInfo", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 104);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIsHistoryProviderEnabled", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 121);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomAttributes", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 133);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCustomAttributes", "pro.taskana.common.rest.TaskanaEngineController", "pro.taskana.common.rest.models.CustomAttributesRepresentationModel", "customAttributes", "", "org.springframework.http.ResponseEntity"), 147);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "currentVersion", "pro.taskana.common.rest.TaskanaEngineController", "", "", "", "org.springframework.http.ResponseEntity"), 160);
    }
}

