/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.NotFoundException;
import pro.taskana.common.rest.TaskanaErrorData;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={InvalidArgumentException.class})
    protected ResponseEntity<TaskanaErrorData> handleInvalidArgument(InvalidArgumentException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST, false);
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    protected ResponseEntity<TaskanaErrorData> handleNotAuthorized(NotAuthorizedException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotFoundException.class})
    protected ResponseEntity<TaskanaErrorData> handleTaskNotFound(NotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class})
    protected ResponseEntity<TaskanaErrorData> handleTaskAlreadyExist(TaskAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<TaskanaErrorData> handleNotAuthorizedToQueryWorkbasket(NotAuthorizedToQueryWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InvalidStateException.class})
    protected ResponseEntity<TaskanaErrorData> handleInvalidState(InvalidStateException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidOwnerException.class})
    protected ResponseEntity<TaskanaErrorData> handleInvalidOwner(InvalidOwnerException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ClassificationAlreadyExistException.class})
    protected ResponseEntity<TaskanaErrorData> handleClassificationAlreadyExist(ClassificationAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ResponseEntity<TaskanaErrorData> handleDuplicateKey(DuplicateKeyException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ConcurrencyException.class})
    protected ResponseEntity<TaskanaErrorData> handleConcurrencyException(ConcurrencyException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketInUseException.class})
    protected ResponseEntity<TaskanaErrorData> handleWorkbasketInUse(WorkbasketInUseException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.LOCKED);
    }

    @ExceptionHandler(value={WorkbasketAlreadyExistException.class})
    protected ResponseEntity<TaskanaErrorData> handleWorkbasketAlreadyExist(WorkbasketAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketAccessItemAlreadyExistException.class})
    protected ResponseEntity<TaskanaErrorData> handleWorkbasketAccessItemAlreadyExist(WorkbasketAccessItemAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidWorkbasketException.class})
    protected ResponseEntity<TaskanaErrorData> handleInvalidWorkbasket(InvalidWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DomainNotFoundException.class})
    protected ResponseEntity<TaskanaErrorData> handleDomainNotFound(DomainNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<TaskanaErrorData> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.PAYLOAD_TOO_LARGE);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<TaskanaErrorData> handleGeneralException(Exception ex, WebRequest req) {
        return this.buildResponse(ex, req, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<TaskanaErrorData> buildResponse(Exception ex, WebRequest req, HttpStatus status) {
        return this.buildResponse(ex, req, status, true);
    }

    private ResponseEntity<TaskanaErrorData> buildResponse(Exception ex, WebRequest req, HttpStatus status, boolean logExceptionOnError) {
        TaskanaErrorData errorData = new TaskanaErrorData(status, ex, req);
        if (logExceptionOnError) {
            this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), (Throwable)ex);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), (Throwable)ex);
        }
        return ResponseEntity.status((HttpStatus)status).body((Object)errorData);
    }
}

