/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.assembler;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.common.rest.models.TaskanaPagedModelKeys;

public interface TaskanaPagingAssembler<T, D extends RepresentationModel<? super D>>
extends RepresentationModelAssembler<T, D> {
    public TaskanaPagedModelKeys getProperty();

    default public TaskanaPagedModel<D> toPageModel(Iterable<T> entities, PagedModel.PageMetadata pageMetadata) {
        return StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((TaskanaPagingAssembler)this).toModel(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), l -> new TaskanaPagedModel(this.getProperty(), l, pageMetadata)));
    }

    default public TaskanaPagedModel<D> toPageModel(Iterable<T> entities) {
        return this.toPageModel(entities, null);
    }

    default public TaskanaPagedModel<D> addLinksToPagedResource(TaskanaPagedModel<D> model) {
        ServletUriComponentsBuilder original = ServletUriComponentsBuilder.fromCurrentRequest();
        PagedModel.PageMetadata page = model.getMetadata();
        model.add(Link.of((String)original.toUriString()).withSelfRel());
        if (page != null) {
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel(IanaLinkRelations.FIRST));
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getTotalPages()}).toUriString()).withRel(IanaLinkRelations.LAST));
            if (page.getNumber() > 1L) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() - 1L}).toUriString()).withRel(IanaLinkRelations.PREV));
            }
            if (page.getNumber() < page.getTotalPages()) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() + 1L}).toUriString()).withRel(IanaLinkRelations.NEXT));
            }
        }
        return model;
    }
}

