/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.security.GroupPrincipal;
import pro.taskana.common.api.security.UserPrincipal;

public class SpringSecurityToJaasFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringSecurityToJaasFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<Authentication> authentication = this.getCurrentAuthentication();
        if (authentication.isPresent()) {
            LOGGER.debug("Authentication found in Spring security context: {}", authentication);
            this.obtainSubject().ifPresent(subject -> {
                this.initializeUserPrincipalFromAuthentication((Authentication)authentication.get(), (Subject)subject);
                this.initializeGroupPrincipalsFromAuthentication((Authentication)authentication.get(), (Subject)subject);
            });
        } else {
            LOGGER.debug("No authentication found in Spring security context. Continuing unauthenticatic.");
        }
        chain.doFilter(request, response);
    }

    protected Optional<Subject> obtainSubject() {
        Optional<Authentication> authentication = this.getCurrentAuthentication();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to obtainSubject using authentication : " + authentication));
        }
        if (!authentication.isPresent()) {
            return Optional.empty();
        }
        if (!authentication.get().isAuthenticated()) {
            return Optional.empty();
        }
        return Optional.of(Subject.getSubject(AccessController.getContext()));
    }

    Optional<Authentication> getCurrentAuthentication() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication());
    }

    private void initializeUserPrincipalFromAuthentication(Authentication authentication, Subject subject) {
        if (!subject.getPrincipals().isEmpty()) {
            LOGGER.debug("Principal of the subject is already set to {}.", subject.getPrincipals());
            throw new SystemException("Finding an existing principal is unexpected. Please investigate.");
        }
        LOGGER.debug("Setting the principal of the subject with {}.", authentication.getPrincipal());
        subject.getPrincipals().add((Principal)new UserPrincipal(((UserDetails)authentication.getPrincipal()).getUsername()));
    }

    private void initializeGroupPrincipalsFromAuthentication(Authentication authentication, Subject subject) {
        LOGGER.debug("Adding roles {} to subject.", (Object)authentication.getAuthorities());
        authentication.getAuthorities().forEach(grantedAuthority -> subject.getPrincipals().add((Principal)new GroupPrincipal(grantedAuthority.getAuthority())));
        LOGGER.debug("{}", subject.getPublicCredentials(GroupPrincipal.class));
    }
}

