/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedBiConsumer;
import pro.taskana.common.rest.AbstractPagingController;
import pro.taskana.common.rest.QueryHelper;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.models.TaskanaPagedModel;
import pro.taskana.workbasket.api.WorkbasketAccessItemQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketAccessItemController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketAccessItemController.class);
    private static final String LIKE = "%";
    private static final String WORKBASKET_KEY = "workbasket-key";
    private static final String WORKBASKET_KEY_LIKE = "workbasket-key-like";
    private static final String ACCESS_ID = "access-id";
    private static final String ACCESS_ID_LIKE = "access-id-like";
    private static final String ACCESS_IDS = "access-ids";
    private final LdapClient ldapClient;
    private final WorkbasketService workbasketService;
    private final WorkbasketAccessItemRepresentationModelAssembler modelAssembler;

    @Autowired
    public WorkbasketAccessItemController(LdapClient ldapClient, WorkbasketService workbasketService, WorkbasketAccessItemRepresentationModelAssembler modelAssembler) {
        this.ldapClient = ldapClient;
        this.workbasketService = workbasketService;
        this.modelAssembler = modelAssembler;
    }

    @GetMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<TaskanaPagedModel<WorkbasketAccessItemRepresentationModel>> getWorkbasketAccessItems(@RequestParam MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getWorkbasketAccessItems(params= {})", params);
        }
        WorkbasketAccessItemQuery query = this.workbasketService.createWorkbasketAccessItemQuery();
        this.applyAccessIdIn(query, params);
        this.applyFilterParams(query, params);
        this.applySortingParams(query, params);
        PagedModel.PageMetadata pageMetadata = this.getPageMetadata(params, (BaseQuery<?, ?>)query);
        List<WorkbasketAccessItem> workbasketAccessItems = this.getQueryList(query, pageMetadata);
        TaskanaPagedModel<WorkbasketAccessItemRepresentationModel> pagedResources = this.modelAssembler.toPageModel(workbasketAccessItems, pageMetadata);
        ResponseEntity response = ResponseEntity.ok(pagedResources);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasketAccessItems(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<Void> removeWorkbasketAccessItems(@RequestParam(value="access-id") String accessId) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to removeWorkbasketAccessItems(access-id= {})", (Object)accessId);
        if (this.ldapClient.isUser(accessId)) {
            List workbasketAccessItemList = this.workbasketService.createWorkbasketAccessItemQuery().accessIdIn(new String[]{accessId}).list();
            if (workbasketAccessItemList != null && !workbasketAccessItemList.isEmpty()) {
                this.workbasketService.deleteWorkbasketAccessItemsForAccessId(accessId);
            }
        } else {
            throw new InvalidArgumentException(String.format("AccessId '%s' is not a user. You can remove all access items for users only.", accessId));
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from removeWorkbasketAccessItems(), returning {}", (Object)response);
        return response;
    }

    private void applyAccessIdIn(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getAccessIds(query= {}, params= {})", (Object)query, params);
        }
        if (params.containsKey((Object)ACCESS_IDS)) {
            String[] accessIds = this.extractVerticalBarSeparatedFields((List)params.get((Object)ACCESS_IDS));
            query.accessIdIn(accessIds);
            params.remove((Object)ACCESS_IDS);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getAccessIds(), returning {}", (Object)query);
        }
    }

    private void applyFilterParams(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(query= {}, params= {})", (Object)query, params);
        }
        if (params.containsKey((Object)WORKBASKET_KEY)) {
            String[] keys = this.extractCommaSeparatedFields((List)params.get((Object)WORKBASKET_KEY));
            query.workbasketKeyIn(keys);
            params.remove((Object)WORKBASKET_KEY);
        }
        if (params.containsKey((Object)WORKBASKET_KEY_LIKE)) {
            query.workbasketKeyLike(new String[]{LIKE + (String)((List)params.get((Object)WORKBASKET_KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)WORKBASKET_KEY_LIKE);
        }
        if (params.containsKey((Object)ACCESS_ID)) {
            String[] accessId = this.extractCommaSeparatedFields((List)params.get((Object)ACCESS_ID));
            query.accessIdIn(accessId);
            params.remove((Object)ACCESS_ID);
        }
        if (params.containsKey((Object)ACCESS_ID_LIKE)) {
            query.accessIdLike(new String[]{LIKE + (String)((List)params.get((Object)ACCESS_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)ACCESS_ID_LIKE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)query);
        }
    }

    private void applySortingParams(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(query= {}, params= {})", (Object)query, params);
        }
        QueryHelper.applyAndRemoveSortingParams(params, (CheckedBiConsumer<String, BaseQuery.SortDirection, InvalidArgumentException>)((CheckedBiConsumer)(sortBy, sortDirection) -> {
            switch (sortBy) {
                case "workbasket-key": {
                    query.orderByWorkbasketKey(sortDirection);
                    break;
                }
                case "access-id": {
                    query.orderByAccessId(sortDirection);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", (Object)query);
        }
    }

    private String[] extractVerticalBarSeparatedFields(List<String> searchFor) {
        ArrayList values = new ArrayList();
        if (searchFor != null) {
            searchFor.forEach(item -> Collections.addAll(values, item.split("\\|")));
        }
        return values.toArray(new String[0]);
    }
}

