/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.assembler.ClassificationDefinitionCollectionRepresentationModel;
import pro.taskana.classification.rest.assembler.ClassificationDefinitionRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationDefinitionRepresentationModel;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.util.CheckedFunction;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationDefinitionController.class);
    private final ObjectMapper mapper;
    private final ClassificationService classificationService;
    private final ClassificationDefinitionRepresentationModelAssembler assembler;

    @Autowired
    ClassificationDefinitionController(ObjectMapper mapper, ClassificationService classificationService, ClassificationDefinitionRepresentationModelAssembler assembler) {
        this.mapper = mapper;
        this.classificationService = classificationService;
        this.assembler = assembler;
    }

    @GetMapping(path={"/api/v1/classification-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationDefinitionCollectionRepresentationModel> exportClassifications(@RequestParam(required=false) String[] domain) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to exportClassifications(domain= {})", (Object)Arrays.toString(domain));
        }
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        List summaries = domain != null ? query.domainIn(domain).list() : query.list();
        ClassificationDefinitionCollectionRepresentationModel collectionModel = summaries.stream().map(ClassificationSummary::getId).map(CheckedFunction.wrap(arg_0 -> ((ClassificationService)this.classificationService).getClassification(arg_0))).collect(Collectors.collectingAndThen(Collectors.toList(), this.assembler::toTaskanaCollectionModel));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)collectionModel));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportClassifications(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/classification-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importClassifications(@RequestParam(value="file") MultipartFile file) throws InvalidArgumentException, NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, ClassificationAlreadyExistException, DomainNotFoundException, IOException {
        LOGGER.debug("Entry to importClassifications()");
        Map<String, String> systemIds = this.getSystemIds();
        ClassificationDefinitionCollectionRepresentationModel collection = this.extractClassificationResourcesFromFile(file);
        this.checkForDuplicates(collection.getContent());
        Map<Classification, String> childrenInFile = this.mapChildrenToParentKeys(collection.getContent(), systemIds);
        this.insertOrUpdateClassificationsWithoutParent(collection.getContent(), systemIds);
        this.updateParentChildrenRelations(childrenInFile);
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from importClassifications(), returning {}", (Object)response);
        return response;
    }

    private Map<String, String> getSystemIds() {
        return this.classificationService.createClassificationQuery().list().stream().collect(Collectors.toMap(i -> i.getKey() + "|" + i.getDomain(), ClassificationSummary::getId));
    }

    private ClassificationDefinitionCollectionRepresentationModel extractClassificationResourcesFromFile(MultipartFile file) throws IOException {
        return (ClassificationDefinitionCollectionRepresentationModel)((Object)this.mapper.readValue(file.getInputStream(), ClassificationDefinitionCollectionRepresentationModel.class));
    }

    private void checkForDuplicates(Collection<ClassificationDefinitionRepresentationModel> definitionList) {
        ArrayList<String> identifiers = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (ClassificationDefinitionRepresentationModel definition : definitionList) {
            ClassificationRepresentationModel classification = definition.getClassification();
            String identifier = classification.getKey() + "|" + classification.getDomain();
            if (identifiers.contains(identifier)) {
                duplicates.add(identifier);
                continue;
            }
            identifiers.add(identifier);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException("The 'key|domain'-identifier is not unique for the value(s): " + ((Object)duplicates).toString());
        }
    }

    private Map<Classification, String> mapChildrenToParentKeys(Collection<ClassificationDefinitionRepresentationModel> definitionList, Map<String, String> systemIds) {
        LOGGER.debug("Entry to mapChildrenToParentKeys()");
        HashMap<Classification, String> childrenInFile = new HashMap<Classification, String>();
        HashSet newKeysWithDomain = new HashSet();
        definitionList.stream().map(ClassificationDefinitionRepresentationModel::getClassification).forEach(cl -> newKeysWithDomain.add(cl.getKey() + "|" + cl.getDomain()));
        for (ClassificationDefinitionRepresentationModel def : definitionList) {
            ClassificationRepresentationModel cl2;
            cl2.setParentId((cl2 = def.getClassification()).getParentId() == null ? "" : cl2.getParentId());
            cl2.setParentKey(cl2.getParentKey() == null ? "" : cl2.getParentKey());
            if (!cl2.getParentId().equals("") && cl2.getParentKey().equals("")) {
                for (ClassificationDefinitionRepresentationModel parentDef : definitionList) {
                    ClassificationRepresentationModel parent = parentDef.getClassification();
                    if (!cl2.getParentId().equals(parent.getClassificationId())) continue;
                    cl2.setParentKey(parent.getKey());
                }
            }
            String parentKeyAndDomain = cl2.getParentKey() + "|" + cl2.getDomain();
            if (cl2.getParentKey().isEmpty() || cl2.getParentKey().equals("") || !newKeysWithDomain.contains(parentKeyAndDomain) && !systemIds.containsKey(parentKeyAndDomain)) continue;
            childrenInFile.put(this.assembler.toEntityModel(def), cl2.getParentKey());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from mapChildrenToParentKeys(), returning {}", childrenInFile);
        }
        return childrenInFile;
    }

    private void insertOrUpdateClassificationsWithoutParent(Collection<ClassificationDefinitionRepresentationModel> definitionList, Map<String, String> systemIds) throws ClassificationNotFoundException, NotAuthorizedException, InvalidArgumentException, ClassificationAlreadyExistException, DomainNotFoundException, ConcurrencyException {
        LOGGER.debug("Entry to insertOrUpdateClassificationsWithoutParent()");
        for (ClassificationDefinitionRepresentationModel definition : definitionList) {
            ClassificationRepresentationModel classificationRepModel = definition.getClassification();
            classificationRepModel.setParentKey(null);
            classificationRepModel.setParentId(null);
            classificationRepModel.setClassificationId(null);
            Classification newClassification = this.assembler.toEntityModel(definition);
            String systemId = systemIds.get(classificationRepModel.getKey() + "|" + classificationRepModel.getDomain());
            if (systemId != null) {
                this.updateExistingClassification(newClassification, systemId);
                continue;
            }
            this.classificationService.createClassification(newClassification);
        }
        LOGGER.debug("Exit from insertOrUpdateClassificationsWithoutParent()");
    }

    private void updateParentChildrenRelations(Map<Classification, String> childrenInFile) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateParentChildrenRelations()");
        for (Map.Entry<Classification, String> entry : childrenInFile.entrySet()) {
            Classification childRes = entry.getKey();
            String parentKey = entry.getValue();
            String classificationKey = childRes.getKey();
            String classificationDomain = childRes.getDomain();
            Classification child = this.classificationService.getClassification(classificationKey, classificationDomain);
            String parentId = parentKey == null ? "" : this.classificationService.getClassification(parentKey, classificationDomain).getId();
            child.setParentKey(parentKey);
            child.setParentId(parentId);
            this.classificationService.updateClassification(child);
        }
        LOGGER.debug("Exit from updateParentChildrenRelations()");
    }

    private void updateExistingClassification(Classification newClassification, String systemId) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateExistingClassification()");
        Classification currentClassification = this.classificationService.getClassification(systemId);
        if (newClassification.getType() != null && !newClassification.getType().equals(currentClassification.getType())) {
            throw new InvalidArgumentException("Can not change the type of a classification.");
        }
        currentClassification.setCategory(newClassification.getCategory());
        currentClassification.setIsValidInDomain(newClassification.getIsValidInDomain());
        currentClassification.setName(newClassification.getName());
        currentClassification.setParentId(newClassification.getParentId());
        currentClassification.setParentKey(newClassification.getParentKey());
        currentClassification.setDescription(newClassification.getDescription());
        currentClassification.setPriority(newClassification.getPriority());
        currentClassification.setServiceLevel(newClassification.getServiceLevel());
        currentClassification.setApplicationEntryPoint(newClassification.getApplicationEntryPoint());
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_1, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_1));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_2, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_2));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_3, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_3));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_4, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_4));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_5, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_5));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_6, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_6));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_7, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_7));
        currentClassification.setCustomAttribute(ClassificationCustomField.CUSTOM_8, newClassification.getCustomAttribute(ClassificationCustomField.CUSTOM_8));
        this.classificationService.updateClassification(currentClassification);
        LOGGER.debug("Exit from updateExistingClassification()");
    }
}

