/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.common.rest.QuerySortBy;

public class QuerySortParameter<Q extends BaseQuery<?, ?>, S extends QuerySortBy<Q>>
implements QueryParameter<Q, Void> {
    private final List<S> sortBy;
    private final List<BaseQuery.SortDirection> order;

    public QuerySortParameter(List<S> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        this.sortBy = sortBy;
        this.order = order;
        QuerySortParameter.verifyNotOnlyOrderByExists(sortBy, order);
        QuerySortParameter.verifyAmountOfSortByAndOrderByMatches(sortBy, order);
    }

    @Override
    public Void applyToQuery(Q query) {
        if (this.sortBy != null) {
            for (int i = 0; i < this.sortBy.size(); ++i) {
                BaseQuery.SortDirection sortDirection = this.order == null || this.order.isEmpty() ? BaseQuery.SortDirection.ASCENDING : this.order.get(i);
                ((QuerySortBy)this.sortBy.get(i)).applySortByForQuery(query, sortDirection);
            }
        }
        return null;
    }

    public static <T> void verifyAmountOfSortByAndOrderByMatches(List<T> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        if (sortBy != null && order != null && sortBy.size() != order.size() && order.size() > 0) {
            throw new InvalidArgumentException("The amount of 'sort-by' and 'order' does not match. Please specify an 'order' for each 'sort-by' or no 'order' parameters at all.");
        }
    }

    public static <T> void verifyNotOnlyOrderByExists(List<T> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        if (sortBy == null && order != null) {
            throw new InvalidArgumentException("Only 'order' parameters were provided. Please also provide 'sort-by' parameter(s)");
        }
    }

    @JsonProperty(value="sort-by")
    public List<S> getSortBy() {
        return this.sortBy;
    }

    public List<BaseQuery.SortDirection> getOrder() {
        return this.order;
    }
}

