/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.workbasket.api.WorkbasketAccessItemQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemPagedRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketAccessItemController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketAccessItemController.class);
    private final LdapClient ldapClient;
    private final WorkbasketService workbasketService;
    private final WorkbasketAccessItemRepresentationModelAssembler modelAssembler;

    @Autowired
    public WorkbasketAccessItemController(LdapClient ldapClient, WorkbasketService workbasketService, WorkbasketAccessItemRepresentationModelAssembler modelAssembler) {
        this.ldapClient = ldapClient;
        this.workbasketService = workbasketService;
        this.modelAssembler = modelAssembler;
    }

    @GetMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<WorkbasketAccessItemPagedRepresentationModel> getWorkbasketAccessItems(WorkbasketAccessItemQueryFilterParameter filterParameter, WorkbasketAccessItemQuerySortParameter sortParameter, QueryPagingParameter<WorkbasketAccessItem, WorkbasketAccessItemQuery> pagingParameter) throws NotAuthorizedException {
        WorkbasketAccessItemQuery query = this.workbasketService.createWorkbasketAccessItemQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Object workbasketAccessItems = pagingParameter.applyToQuery((BaseQuery)query);
        WorkbasketAccessItemPagedRepresentationModel pagedResources = (WorkbasketAccessItemPagedRepresentationModel)this.modelAssembler.toPagedModel((Iterable)workbasketAccessItems, pagingParameter.getPageMetadata());
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pagedResources));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasketAccessItems(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<Void> removeWorkbasketAccessItems(@RequestParam(value="access-id") String accessId) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to removeWorkbasketAccessItems(access-id= {})", (Object)accessId);
        if (this.ldapClient.isUser(accessId)) {
            List workbasketAccessItemList = this.workbasketService.createWorkbasketAccessItemQuery().accessIdIn(new String[]{accessId}).list();
            if (workbasketAccessItemList != null && !workbasketAccessItemList.isEmpty()) {
                this.workbasketService.deleteWorkbasketAccessItemsForAccessId(accessId);
            }
        } else {
            throw new InvalidArgumentException(String.format("AccessId '%s' is not a user. You can remove all access items for users only.", accessId));
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from removeWorkbasketAccessItems(), returning {}", (Object)response);
        return response;
    }

    public static class WorkbasketAccessItemQuerySortParameter
    extends QuerySortParameter<WorkbasketAccessItemQuery, WorkbasketAccessItemSortBy> {
        @ConstructorProperties(value={"sort-by", "order"})
        public WorkbasketAccessItemQuerySortParameter(List<WorkbasketAccessItemSortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<WorkbasketAccessItemSortBy> getSortBy() {
            return super.getSortBy();
        }
    }

    public static enum WorkbasketAccessItemSortBy implements QuerySortBy<WorkbasketAccessItemQuery>
    {
        WORKBASKET_KEY(WorkbasketAccessItemQuery::orderByWorkbasketKey),
        ACCESS_ID(WorkbasketAccessItemQuery::orderByAccessId);

        private final BiConsumer<WorkbasketAccessItemQuery, BaseQuery.SortDirection> consumer;

        private WorkbasketAccessItemSortBy(BiConsumer<WorkbasketAccessItemQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(WorkbasketAccessItemQuery query, BaseQuery.SortDirection sortDirection) {
            this.consumer.accept(query, sortDirection);
        }
    }
}

