/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest.assembler;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.rest.assembler.CollectionRepresentationModelAssembler;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;

@Component
public class WorkbasketDefinitionRepresentationModelAssembler
implements CollectionRepresentationModelAssembler<Workbasket, WorkbasketDefinitionRepresentationModel, WorkbasketDefinitionCollectionRepresentationModel> {
    private final WorkbasketService workbasketService;
    private final WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler;
    private final WorkbasketRepresentationModelAssembler workbasketAssembler;

    @Autowired
    public WorkbasketDefinitionRepresentationModelAssembler(WorkbasketService workbasketService, WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler, WorkbasketRepresentationModelAssembler workbasketAssembler) {
        this.workbasketService = workbasketService;
        this.accessItemAssembler = accessItemAssembler;
        this.workbasketAssembler = workbasketAssembler;
    }

    @NonNull
    public WorkbasketDefinitionRepresentationModel toModel(@NonNull Workbasket workbasket) {
        Set<String> distroTargets;
        Collection authorizations;
        WorkbasketRepresentationModel basket = this.workbasketAssembler.toModel(workbasket);
        try {
            List workbasketAccessItems = this.workbasketService.getWorkbasketAccessItems(basket.getWorkbasketId());
            authorizations = this.accessItemAssembler.toCollectionModel(workbasketAccessItems).getContent();
            distroTargets = this.workbasketService.getDistributionTargets(workbasket.getId()).stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        }
        catch (NotAuthorizedException | WorkbasketNotFoundException e) {
            throw new SystemException("Caught Exception", e);
        }
        WorkbasketDefinitionRepresentationModel repModel = new WorkbasketDefinitionRepresentationModel();
        repModel.setWorkbasket(basket);
        repModel.setAuthorizations(authorizations);
        repModel.setDistributionTargets(distroTargets);
        return repModel;
    }

    @Override
    public WorkbasketDefinitionCollectionRepresentationModel buildCollectionEntity(List<WorkbasketDefinitionRepresentationModel> content) {
        return new WorkbasketDefinitionCollectionRepresentationModel((Collection<WorkbasketDefinitionRepresentationModel>)content);
    }
}

