/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.ClassificationQueryFilterParameter;
import pro.taskana.classification.rest.assembler.ClassificationRepresentationModelAssembler;
import pro.taskana.classification.rest.assembler.ClassificationSummaryRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.classification.rest.models.ClassificationSummaryPagedRepresentationModel;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationController.class);
    private final ClassificationService classificationService;
    private final ClassificationRepresentationModelAssembler modelAssembler;
    private final ClassificationSummaryRepresentationModelAssembler summaryModelAssembler;

    @Autowired
    ClassificationController(ClassificationService classificationService, ClassificationRepresentationModelAssembler modelAssembler, ClassificationSummaryRepresentationModelAssembler summaryModelAssembler) {
        this.classificationService = classificationService;
        this.modelAssembler = modelAssembler;
        this.summaryModelAssembler = summaryModelAssembler;
    }

    @GetMapping(path={"/api/v1/classifications"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationSummaryPagedRepresentationModel> getClassifications(HttpServletRequest request, ClassificationQueryFilterParameter filterParameter, ClassificationQuerySortParameter sortParameter, QueryPagingParameter<ClassificationSummary, ClassificationQuery> pagingParameter) {
        QueryParamsValidator.validateParams(request, ClassificationQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Object classificationSummaries = pagingParameter.applyToQuery((BaseQuery)query);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)((ClassificationSummaryPagedRepresentationModel)((Object)this.summaryModelAssembler.toPagedModel(classificationSummaries, pagingParameter.getPageMetadata())))));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassifications(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/classifications/{classificationId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> getClassification(@PathVariable String classificationId) throws ClassificationNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getClassification(classificationId= {})", (Object)classificationId);
        }
        Classification classification = this.classificationService.getClassification(classificationId);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassification(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/classifications"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> createClassification(@RequestBody ClassificationRepresentationModel repModel) throws NotAuthorizedException, ClassificationAlreadyExistException, DomainNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createClassification(repModel= {})", (Object)repModel);
        }
        Classification classification = this.modelAssembler.toEntityModel(repModel);
        classification = this.classificationService.createClassification(classification);
        ResponseEntity response = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.modelAssembler.toModel(classification));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createClassification(), returning {}", (Object)response);
        }
        return response;
    }

    @PutMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> updateClassification(@PathVariable(value="classificationId") String classificationId, @RequestBody ClassificationRepresentationModel resource) throws NotAuthorizedException, ClassificationNotFoundException, ConcurrencyException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to updateClassification(classificationId= {}, resource= {})", (Object)classificationId, (Object)resource);
        }
        if (!classificationId.equals(resource.getClassificationId())) {
            throw new InvalidArgumentException(String.format("ClassificationId ('%s') of the URI is not identical with the classificationId ('%s') of the object in the payload.", classificationId, resource.getClassificationId()));
        }
        Classification classification = this.modelAssembler.toEntityModel(resource);
        classification = this.classificationService.updateClassification(classification);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateClassification(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> deleteClassification(@PathVariable String classificationId) throws ClassificationNotFoundException, ClassificationInUseException, NotAuthorizedException {
        LOGGER.debug("Entry to deleteClassification(classificationId= {})", (Object)classificationId);
        this.classificationService.deleteClassification(classificationId);
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from deleteClassification(), returning {}", (Object)response);
        return response;
    }

    public static class ClassificationQuerySortParameter
    extends QuerySortParameter<ClassificationQuery, ClassificationQuerySortBy> {
        @ConstructorProperties(value={"sort-by", "order"})
        public ClassificationQuerySortParameter(List<ClassificationQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<ClassificationQuerySortBy> getSortBy() {
            return super.getSortBy();
        }
    }

    static enum ClassificationQuerySortBy implements QuerySortBy<ClassificationQuery>
    {
        DOMAIN(ClassificationQuery::orderByDomain),
        KEY(ClassificationQuery::orderByKey),
        CATEGORY(ClassificationQuery::orderByCategory),
        NAME(ClassificationQuery::orderByName);

        private final BiConsumer<ClassificationQuery, BaseQuery.SortDirection> consumer;

        private ClassificationQuerySortBy(BiConsumer<ClassificationQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(ClassificationQuery query, BaseQuery.SortDirection sortDirection) {
            this.consumer.accept(query, sortDirection);
        }
    }
}

