/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.rest.TaskQueryFilterParameter;
import pro.taskana.task.rest.assembler.TaskRepresentationModelAssembler;
import pro.taskana.task.rest.assembler.TaskSummaryRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskRepresentationModel;
import pro.taskana.task.rest.models.TaskSummaryCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskSummaryPagedRepresentationModel;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    private final TaskService taskService;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler;

    @Autowired
    TaskController(TaskService taskService, TaskRepresentationModelAssembler taskRepresentationModelAssembler, TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.taskSummaryRepresentationModelAssembler = taskSummaryRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskSummaryPagedRepresentationModel> getTasks(HttpServletRequest request, TaskQueryFilterParameter filterParameter, TaskQuerySortParameter sortParameter, QueryPagingParameter<TaskSummary, TaskQuery> pagingParameter) {
        QueryParamsValidator.validateParams(request, TaskQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Object taskSummaries = pagingParameter.applyToQuery((BaseQuery)query);
        TaskSummaryPagedRepresentationModel pagedModels = (TaskSummaryPagedRepresentationModel)((Object)this.taskSummaryRepresentationModelAssembler.toPagedModel(taskSummaries, pagingParameter.getPageMetadata()));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pagedModels));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasks(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskSummaryCollectionRepresentationModel> deleteTasks(TaskQueryFilterParameter filterParameter) throws InvalidArgumentException, NotAuthorizedException {
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.applyToQuery(query);
        List taskSummaries = query.list();
        List taskIdsToDelete = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
        BulkOperationResults result = this.taskService.deleteTasks(taskIdsToDelete);
        List successfullyDeletedTaskSummaries = taskSummaries.stream().filter(summary -> !result.getFailedIds().contains(summary.getId())).collect(Collectors.toList());
        ResponseEntity response = ResponseEntity.ok((Object)((Object)((TaskSummaryCollectionRepresentationModel)this.taskSummaryRepresentationModelAssembler.toTaskanaCollectionModel(successfullyDeletedTaskSummaries))));
        LOGGER.debug("Exit from deleteTasks(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> getTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getTask(taskId= {})", (Object)taskId);
        Task task = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> claimTask(@PathVariable String taskId, @RequestBody(required=false) String userName) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        LOGGER.debug("Entry to claimTask(taskId= {}, userName= {})", (Object)taskId, (Object)userName);
        this.taskService.claim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from claimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/select-and-claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> selectAndClaimTask(TaskQueryFilterParameter filterParameter, TaskQuerySortParameter sortParameter) throws InvalidOwnerException, NotAuthorizedException {
        LOGGER.debug("Entry to selectAndClaimTask");
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Task selectedAndClaimedTask = this.taskService.selectAndClaim(query);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(selectedAndClaimedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from selectAndClaimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> cancelClaimTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        LOGGER.debug("Entry to cancelClaimTask(taskId= {}", (Object)taskId);
        Task updatedTask = this.taskService.cancelClaim(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from cancelClaimTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> completeTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("Entry to completeTask(taskId= {})", (Object)taskId);
        Task updatedTask = this.taskService.forceCompleteTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from completeTask(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> deleteTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("Entry to deleteTask(taskId= {})", (Object)taskId);
        this.taskService.forceDeleteTask(taskId);
        ResponseEntity result = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from deleteTask(), returning {}", (Object)result);
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/cancel"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> cancelTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException, InvalidStateException {
        LOGGER.debug("Entry to cancelTask(taskId= {})", (Object)taskId);
        Task cancelledTask = this.taskService.cancelTask(taskId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(cancelledTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from cancelTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> createTask(@RequestBody TaskRepresentationModel taskRepresentationModel) throws WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException, TaskAlreadyExistException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createTask(params= {})", (Object)taskRepresentationModel);
        }
        Task fromResource = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        Task createdTask = this.taskService.createTask(fromResource);
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskRepresentationModelAssembler.toModel(createdTask));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/transfer/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> transferTask(@PathVariable String taskId, @PathVariable String workbasketId, @RequestBody(required=false) Boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        LOGGER.debug("Entry to transferTask(taskId= {}, workbasketId= {})", (Object)taskId, (Object)workbasketId);
        Task updatedTask = this.taskService.transfer(taskId, workbasketId, setTransferFlag == null || setTransferFlag != false);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from transferTask(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> updateTask(@PathVariable(value="taskId") String taskId, @RequestBody TaskRepresentationModel taskRepresentationModel) throws TaskNotFoundException, ClassificationNotFoundException, InvalidArgumentException, ConcurrencyException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException {
        LOGGER.debug("Entry to updateTask(taskId= {}, taskResource= {})", (Object)taskId, (Object)taskRepresentationModel);
        if (!taskId.equals(taskRepresentationModel.getTaskId())) {
            throw new InvalidArgumentException(String.format("TaskId ('%s') is not identical with the taskId of to object in the payload which should be updated. ID=('%s')", taskId, taskRepresentationModel.getTaskId()));
        }
        Task task = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        task = this.taskService.updateTask(task);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateTask(), returning {}", (Object)result);
        }
        return result;
    }

    public static class TaskQuerySortParameter
    extends QuerySortParameter<TaskQuery, TaskQuerySortBy> {
        @ConstructorProperties(value={"sort-by", "order"})
        public TaskQuerySortParameter(List<TaskQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<TaskQuerySortBy> getSortBy() {
            return super.getSortBy();
        }
    }

    public static enum TaskQuerySortBy implements QuerySortBy<TaskQuery>
    {
        CLASSIFICATION_KEY(TaskQuery::orderByClassificationKey),
        POR_TYPE(TaskQuery::orderByPrimaryObjectReferenceType),
        POR_VALUE(TaskQuery::orderByPrimaryObjectReferenceValue),
        STATE(TaskQuery::orderByState),
        NAME(TaskQuery::orderByName),
        DUE(TaskQuery::orderByDue),
        PLANNED(TaskQuery::orderByPlanned),
        PRIORITY(TaskQuery::orderByPriority);

        private final BiConsumer<TaskQuery, BaseQuery.SortDirection> consumer;

        private TaskQuerySortBy(BiConsumer<TaskQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(TaskQuery query, BaseQuery.SortDirection sortDirection) {
            this.consumer.accept(query, sortDirection);
        }
    }
}

