/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.rest.ldap.LdapSettings;
import pro.taskana.common.rest.models.AccessIdRepresentationModel;

@Component
public class LdapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapClient.class);
    private static final String CN = "cn";
    private final Environment env;
    private final LdapTemplate ldapTemplate;
    private boolean active = false;
    private int minSearchForLength;
    private int maxNumberOfReturnedAccessIds;
    private String message;

    @Autowired
    public LdapClient(Environment env, LdapTemplate ldapTemplate) {
        this.env = env;
        this.ldapTemplate = ldapTemplate;
    }

    public List<AccessIdRepresentationModel> searchUsersAndGroups(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersAndGroups(name = {})", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        ArrayList<AccessIdRepresentationModel> accessIds = new ArrayList<AccessIdRepresentationModel>();
        if (this.nameIsDn(name)) {
            AccessIdRepresentationModel groupByDn = this.searchAccessIdByDn(name);
            if (groupByDn != null) {
                accessIds.add(groupByDn);
            }
        } else {
            accessIds.addAll(this.searchUsersByNameOrAccessId(name));
            accessIds.addAll(this.searchGroupsByName(name));
        }
        this.sortListOfAccessIdResources(accessIds);
        List<AccessIdRepresentationModel> result = this.getFirstPageOfaResultList(accessIds);
        LOGGER.debug("exit from searchUsersAndGroups(name = {}). Returning {} users and groups: {}", new Object[]{name, accessIds.size(), result});
        return result;
    }

    public List<AccessIdRepresentationModel> searchUsersByNameOrAccessId(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersByNameOrAccessId(name = {}).", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFullnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserIdAttribute(), name));
        andFilter.and((Filter)orFilter);
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, this.getLookUpUserAttributesToReturn(), (ContextMapper)new UserContextMapper());
        LOGGER.debug("exit from searchUsersByNameOrAccessId. Retrieved the following users: {}.", (Object)accessIds);
        return accessIds;
    }

    public List<AccessIdRepresentationModel> getUsersByAccessId(String accessId) {
        LOGGER.debug("entry to searchUsersByAccessId(name = {}).", (Object)accessId);
        this.isInitOrFail();
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        andFilter.and((Filter)new EqualsFilter(this.getUserIdAttribute(), accessId));
        String[] userAttributesToReturn = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute()};
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new UserContextMapper());
        LOGGER.debug("exit from searchUsersByAccessId. Retrieved the following users: {}.", (Object)accessIds);
        return accessIds;
    }

    public List<AccessIdRepresentationModel> searchGroupsByName(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsByName(name = {}).", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), name));
        if (!CN.equals(this.getGroupNameAttribute())) {
            orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        }
        andFilter.and((Filter)orFilter);
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, this.getLookUpGroupAttributesToReturn(), (ContextMapper)new GroupContextMapper());
        LOGGER.debug("Exit from searchGroupsByName. Retrieved the following groups: {}", (Object)accessIds);
        return accessIds;
    }

    public AccessIdRepresentationModel searchAccessIdByDn(String dn) {
        LOGGER.debug("entry to searchGroupByDn(name = {}).", (Object)dn);
        this.isInitOrFail();
        String nameWithoutBaseDn = this.getNameWithoutBaseDn(dn);
        LOGGER.debug("Removed baseDN {} from given DN. New DN to be used: {}", (Object)this.getBaseDn(), (Object)nameWithoutBaseDn);
        AccessIdRepresentationModel accessId = (AccessIdRepresentationModel)((Object)this.ldapTemplate.lookup(nameWithoutBaseDn, this.getLookUpUserAndGroupAttributesToReturn(), (ContextMapper)new DnContextMapper()));
        LOGGER.debug("Exit from searchGroupByDn. Retrieved the following group: {}", (Object)accessId);
        return accessId;
    }

    public List<AccessIdRepresentationModel> searchGroupsAccessIdIsMemberOf(String accessId) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsAccessIdIsMemberOf(name = {}).", (Object)accessId);
        this.isInitOrFail();
        this.testMinSearchForLength(accessId);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new EqualsFilter(this.getGroupsOfUser(), accessId));
        orFilter.or((Filter)new EqualsFilter(this.getGroupsOfUser(), LdapNameBuilder.newInstance().add(this.getBaseDn()).add(this.getUserSearchBase()).add("uid", (Object)accessId).build().toString()));
        andFilter.and((Filter)orFilter);
        String[] userAttributesToReturn = new String[]{this.getUserIdAttribute(), this.getGroupNameAttribute()};
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new GroupContextMapper());
        LOGGER.debug("exit from searchGroupsAccessIdIsMemberOf. Retrieved the following accessIds: {}.", (Object)accessIds);
        return accessIds;
    }

    public boolean validateAccessId(String name) {
        LOGGER.debug("entry to validateAccessId(name = {})", (Object)name);
        this.isInitOrFail();
        if (this.nameIsDn(name)) {
            AccessIdRepresentationModel groupByDn = this.searchAccessIdByDn(name);
            return groupByDn != null;
        }
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new EqualsFilter(this.getUserIdAttribute(), name));
        andFilter.and((Filter)orFilter);
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, this.getLookUpUserAttributesToReturn(), (ContextMapper)new UserContextMapper());
        return !accessIds.isEmpty();
    }

    public String getUserSearchBase() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_BASE.getValueFromEnv(this.env);
    }

    public String getUserSearchFilterName() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_NAME.getValueFromEnv(this.env);
    }

    public String getUserSearchFilterValue() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_VALUE.getValueFromEnv(this.env);
    }

    public String getUserFirstnameAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_FIRSTNAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getUserLastnameAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_LASTNAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getUserIdAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_ID_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getGroupSearchBase() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_BASE.getValueFromEnv(this.env);
    }

    public String getBaseDn() {
        return LdapSettings.TASKANA_LDAP_BASE_DN.getValueFromEnv(this.env);
    }

    public String getGroupSearchFilterName() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_NAME.getValueFromEnv(this.env);
    }

    public String getGroupSearchFilterValue() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_VALUE.getValueFromEnv(this.env);
    }

    public String getGroupNameAttribute() {
        return LdapSettings.TASKANA_LDAP_GROUP_NAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public int calcMinSearchForLength(int defaultValue) {
        String envValue = LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH.getValueFromEnv(this.env);
        if (envValue == null || envValue.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(envValue);
    }

    public int getMinSearchForLength() {
        return this.minSearchForLength;
    }

    public int calcMaxNumberOfReturnedAccessIds(int defaultValue) {
        String envValue = LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS.getValueFromEnv(this.env);
        if (envValue == null || envValue.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(envValue);
    }

    public int getMaxNumberOfReturnedAccessIds() {
        return this.maxNumberOfReturnedAccessIds;
    }

    public String getGroupsOfUser() {
        return LdapSettings.TASKANA_LDAP_GROUPS_OF_USER.getValueFromEnv(this.env);
    }

    public boolean isUser(String accessId) {
        return !this.getUsersByAccessId(accessId).isEmpty();
    }

    boolean nameIsDn(String name) {
        return name.toLowerCase().endsWith(this.getBaseDn().toLowerCase());
    }

    List<AccessIdRepresentationModel> getFirstPageOfaResultList(List<AccessIdRepresentationModel> accessIds) {
        return accessIds.subList(0, Math.min(accessIds.size(), this.maxNumberOfReturnedAccessIds));
    }

    void isInitOrFail() {
        if (!this.active) {
            throw new SystemException(String.format("LdapClient was called but is not active due to missing configuration: %s", this.message));
        }
    }

    void sortListOfAccessIdResources(List<AccessIdRepresentationModel> accessIds) {
        accessIds.sort(Comparator.comparing(AccessIdRepresentationModel::getAccessId, String.CASE_INSENSITIVE_ORDER));
    }

    String getNameWithoutBaseDn(String name) {
        return name.replaceAll("(?i)" + Pattern.quote("," + this.getBaseDn()), "");
    }

    String[] getLookUpGroupAttributesToReturn() {
        if (CN.equals(this.getGroupNameAttribute())) {
            return new String[]{CN};
        }
        return new String[]{this.getGroupNameAttribute(), CN};
    }

    String[] getLookUpUserAndGroupAttributesToReturn() {
        return (String[])Stream.concat(Arrays.stream(this.getLookUpUserAttributesToReturn()), Arrays.stream(this.getLookUpGroupAttributesToReturn())).toArray(String[]::new);
    }

    String[] getLookUpUserAttributesToReturn() {
        return new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute()};
    }

    @PostConstruct
    void init() {
        LOGGER.debug("Entry to init()");
        this.minSearchForLength = this.calcMinSearchForLength(3);
        this.maxNumberOfReturnedAccessIds = this.calcMaxNumberOfReturnedAccessIds(50);
        this.ldapTemplate.setDefaultCountLimit(this.maxNumberOfReturnedAccessIds);
        List<LdapSettings> missingConfigurations = this.checkForMissingConfigurations();
        if (!missingConfigurations.isEmpty()) {
            this.message = String.format("LDAP configurations are missing: %s", missingConfigurations);
            throw new SystemException(this.message);
        }
        this.active = true;
        LOGGER.debug("Exit from init()");
    }

    List<LdapSettings> checkForMissingConfigurations() {
        return Arrays.stream(LdapSettings.values()).filter(p -> !p.equals((Object)LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS)).filter(p -> !p.equals((Object)LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH)).filter(p -> p.getValueFromEnv(this.env) == null).collect(Collectors.toList());
    }

    void testMinSearchForLength(String name) throws InvalidArgumentException {
        if (name == null || name.length() < this.minSearchForLength) {
            throw new InvalidArgumentException(String.format("search for string %s is too short. Minimum Length is %s", name, this.getMinSearchForLength()));
        }
    }

    String getDnWithBaseDn(String givenDn) {
        String dn = givenDn;
        if (!dn.toLowerCase().endsWith(this.getBaseDn().toLowerCase())) {
            dn = dn + "," + this.getBaseDn();
        }
        return dn;
    }

    private String getUserFullnameAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_FULLNAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    class DnContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        DnContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            String userId = context.getStringAttribute(LdapClient.this.getUserIdAttribute());
            if (userId != null) {
                accessId.setAccessId(userId);
                String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
                String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
                accessId.setName(String.format("%s, %s", lastName, firstName));
            } else {
                String dn = LdapClient.this.getDnWithBaseDn(context.getDn().toString());
                accessId.setAccessId(dn);
                accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            }
            return accessId;
        }
    }

    class UserContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        UserContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            accessId.setAccessId(context.getStringAttribute(LdapClient.this.getUserIdAttribute()));
            String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
            String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
            accessId.setName(String.format("%s, %s", lastName, firstName));
            return accessId;
        }
    }

    class GroupContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        GroupContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            String dn = LdapClient.this.getDnWithBaseDn(context.getDn().toString());
            accessId.setAccessId(dn);
            accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            return accessId;
        }
    }
}

