/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest.models;

import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.springframework.hateoas.RepresentationModel;

public class ReportRepresentationModel
extends RepresentationModel<ReportRepresentationModel> {
    private final MetaInformation meta;
    private final List<RowRepresentationModel> rows;
    private final List<RowRepresentationModel> sumRow;

    @ConstructorProperties(value={"meta", "rows", "sumRow"})
    public ReportRepresentationModel(MetaInformation meta, List<RowRepresentationModel> rows, List<RowRepresentationModel> sumRow) {
        this.meta = meta;
        this.rows = rows;
        this.sumRow = sumRow;
    }

    public MetaInformation getMeta() {
        return this.meta;
    }

    public List<RowRepresentationModel> getRows() {
        return this.rows;
    }

    public List<RowRepresentationModel> getSumRow() {
        return this.sumRow;
    }

    public static class MetaInformation {
        private final String name;
        private final Instant date;
        private final String[] header;
        private final String[] rowDesc;
        private final String sumRowDesc;

        @ConstructorProperties(value={"name", "date", "header", "rowDesc", "sumRowDesc"})
        public MetaInformation(String name, Instant date, String[] header, String[] rowDesc, String sumRowDesc) {
            this.name = name;
            this.date = date;
            this.header = header;
            this.rowDesc = rowDesc;
            this.sumRowDesc = sumRowDesc;
        }

        public String getSumRowDesc() {
            return this.sumRowDesc;
        }

        public String getName() {
            return this.name;
        }

        public Instant getDate() {
            return this.date;
        }

        public String[] getHeader() {
            return this.header;
        }

        public String[] getRowDesc() {
            return this.rowDesc;
        }

        public String toString() {
            return "MetaInformation [name=" + this.name + ", date=" + this.date + ", header=" + Arrays.toString(this.header) + ", rowDesc=" + Arrays.toString(this.rowDesc) + ", totalDesc=" + this.sumRowDesc + "]";
        }
    }

    public static class RowRepresentationModel {
        private final int[] cells;
        private final int total;
        private final int depth;
        private final String[] desc;
        private final boolean display;

        @ConstructorProperties(value={"cells", "total", "depth", "desc", "display"})
        public RowRepresentationModel(int[] cells, int total, int depth, String[] desc, boolean display) {
            this.cells = cells;
            this.total = total;
            this.depth = depth;
            this.desc = desc;
            this.display = display;
        }

        public int[] getCells() {
            return this.cells;
        }

        public int getTotal() {
            return this.total;
        }

        public int getDepth() {
            return this.depth;
        }

        public String[] getDesc() {
            return this.desc;
        }

        public boolean isDisplay() {
            return this.display;
        }

        public String toString() {
            return "RowResource [cells=" + Arrays.toString(this.cells) + ", total=" + this.total + ", depth=" + this.depth + ", desc=" + Arrays.toString(this.desc) + ", display=" + this.display + "]";
        }
    }
}

