/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.rest.assembler.TaskCommentRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskCommentCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCommentController.class);
    private final TaskService taskService;
    private final TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler;

    @Autowired
    TaskCommentController(TaskService taskService, TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskCommentRepresentationModelAssembler = taskCommentRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> getTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentRepresentationModel taskCommentRepresentationModel = this.taskCommentRepresentationModelAssembler.toModel(taskComment);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)taskCommentRepresentationModel));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComment(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentCollectionRepresentationModel> getTaskComments(@PathVariable String taskId, @RequestParam(name="sort-by", required=false) List<TaskCommentsSortBy> sortBy, @RequestParam(required=false) List<BaseQuery.SortDirection> order) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComments(taskId= {})", (Object)taskId);
        }
        Optional<Comparator<TaskComment>> comparator = this.getTaskCommentComparator(sortBy, order);
        List taskComments = this.taskService.getTaskComments(taskId);
        comparator.ifPresent(taskComments::sort);
        TaskCommentCollectionRepresentationModel taskCommentListResource = (TaskCommentCollectionRepresentationModel)((Object)this.taskCommentRepresentationModelAssembler.toTaskanaCollectionModel(taskComments));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)taskCommentListResource));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComments(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> deleteTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to deleteTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity result = ResponseEntity.noContent().build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from deleteTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> updateTaskComment(@PathVariable String taskCommentId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to updateTaskComment(taskCommentId= {}, taskCommentResource= {})", (Object)taskCommentId, (Object)taskCommentRepresentationModel);
        }
        if (!taskCommentId.equals(taskCommentRepresentationModel.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        taskComment = this.taskService.updateTaskComment(taskComment);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.taskCommentRepresentationModelAssembler.toModel(taskComment)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> createTaskComment(@PathVariable String taskId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, InvalidArgumentException, TaskNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createTaskComment(taskId= {}, taskCommentResource= {})", (Object)taskId, (Object)taskCommentRepresentationModel);
        }
        taskCommentRepresentationModel.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskCommentRepresentationModelAssembler.toModel(createdTaskComment));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    private Optional<Comparator<TaskComment>> getTaskCommentComparator(List<TaskCommentsSortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        QuerySortParameter.verifyNotOnlyOrderByExists(sortBy, order);
        QuerySortParameter.verifyAmountOfSortByAndOrderByMatches(sortBy, order);
        Comparator<TaskComment> comparator = null;
        if (sortBy != null) {
            for (int i = 0; i < sortBy.size(); ++i) {
                BaseQuery.SortDirection sortDirection = order == null ? BaseQuery.SortDirection.ASCENDING : order.get(i);
                Comparator<TaskComment> temp = sortBy.get(i).getComparator();
                if (sortDirection == BaseQuery.SortDirection.DESCENDING) {
                    temp = temp.reversed();
                }
                comparator = comparator == null ? temp : comparator.thenComparing(temp);
            }
        }
        return Optional.ofNullable(comparator);
    }

    static enum TaskCommentsSortBy {
        CREATED(Comparator.comparing(TaskComment::getCreated)),
        MODIFIED(Comparator.comparing(TaskComment::getModified));

        private final Comparator<TaskComment> comparator;

        private TaskCommentsSortBy(Comparator<TaskComment> comparing) {
            this.comparator = comparing;
        }

        public Comparator<TaskComment> getComparator() {
            return this.comparator;
        }
    }
}

