/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.WildcardSearchField;

public class TaskQueryFilterParameter
implements QueryParameter<TaskQuery, Void> {
    private final String[] name;
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    private final int[] priority;
    private final TaskState[] state;
    @JsonProperty(value="classification.key")
    private final String[] classificationKeys;
    @JsonProperty(value="task-id")
    private final String[] taskIds;
    @JsonProperty(value="workbasket-id")
    private final String[] workbasketIds;
    @JsonProperty(value="workbasket-key")
    private final String[] workbasketKeys;
    private final String domain;
    private final String[] owner;
    @JsonProperty(value="owner-like")
    private final String[] ownerLike;
    @JsonProperty(value="por.company")
    private final String[] porCompany;
    @JsonProperty(value="por.system")
    private final String[] porSystem;
    @JsonProperty(value="por.instance")
    private final String[] porInstance;
    @JsonProperty(value="por.type")
    private final String[] porType;
    @JsonProperty(value="por.value")
    private final String[] porValue;
    private final Instant[] planned;
    @JsonProperty(value="planned-from")
    private final Instant plannedFrom;
    @JsonProperty(value="planned-until")
    private final Instant plannedUntil;
    private final Instant[] due;
    @JsonProperty(value="due-from")
    private final Instant dueFrom;
    @JsonProperty(value="due-until")
    private final Instant dueUntil;
    @JsonProperty(value="wildcard-search-fields")
    private final WildcardSearchField[] wildcardSearchFields;
    @JsonProperty(value="wildcard-search-value")
    private final String wildcardSearchValue;
    @JsonProperty(value="external-id")
    private final String[] externalIds;
    @JsonProperty(value="custom-1")
    private final String[] custom1;
    @JsonProperty(value="custom-2")
    private final String[] custom2;
    @JsonProperty(value="custom-3")
    private final String[] custom3;
    @JsonProperty(value="custom-4")
    private final String[] custom4;
    @JsonProperty(value="custom-5")
    private final String[] custom5;
    @JsonProperty(value="custom-6")
    private final String[] custom6;
    @JsonProperty(value="custom-7")
    private final String[] custom7;
    @JsonProperty(value="custom-8")
    private final String[] custom8;
    @JsonProperty(value="custom-9")
    private final String[] custom9;
    @JsonProperty(value="custom-10")
    private final String[] custom10;
    @JsonProperty(value="custom-11")
    private final String[] custom11;
    @JsonProperty(value="custom-12")
    private final String[] custom12;
    @JsonProperty(value="custom-13")
    private final String[] custom13;
    @JsonProperty(value="custom-14")
    private final String[] custom14;
    @JsonProperty(value="custom-15")
    private final String[] custom15;
    @JsonProperty(value="custom-16")
    private final String[] custom16;

    @ConstructorProperties(value={"name", "name-like", "priority", "state", "classification.key", "task-id", "workbasket-id", "workbasket-key", "domain", "owner", "owner-like", "por.company", "por.system", "por.instance", "por.type", "por.value", "planned", "due", "planned-from", "planned-until", "due-from", "due-until", "wildcard-search-fields", "wildcard-search-value", "external-id", "custom-1", "custom-2", "custom-3", "custom-4", "custom-5", "custom-6", "custom-7", "custom-8", "custom-9", "custom-10", "custom-11", "custom-12", "custom-13", "custom-14", "custom-15", "custom-16"})
    public TaskQueryFilterParameter(String[] name, String[] nameLike, int[] priority, TaskState[] state, String[] classificationKeys, String[] taskIds, String[] workbasketIds, String[] workbasketKeys, String domain, String[] owner, String[] ownerLike, String[] porCompany, String[] porSystem, String[] porInstance, String[] porType, String[] porValue, Instant[] planned, Instant[] due, Instant plannedFrom, Instant plannedUntil, Instant dueFrom, Instant dueUntil, WildcardSearchField[] wildcardSearchFields, String wildcardSearchValue, String[] externalIds, String[] custom1, String[] custom2, String[] custom3, String[] custom4, String[] custom5, String[] custom6, String[] custom7, String[] custom8, String[] custom9, String[] custom10, String[] custom11, String[] custom12, String[] custom13, String[] custom14, String[] custom15, String[] custom16) throws InvalidArgumentException {
        this.name = name;
        this.nameLike = nameLike;
        this.priority = priority;
        this.state = state;
        this.classificationKeys = classificationKeys;
        this.taskIds = taskIds;
        this.workbasketIds = workbasketIds;
        this.workbasketKeys = workbasketKeys;
        this.domain = domain;
        this.owner = owner;
        this.ownerLike = ownerLike;
        this.porCompany = porCompany;
        this.porSystem = porSystem;
        this.porInstance = porInstance;
        this.porType = porType;
        this.porValue = porValue;
        this.planned = planned;
        this.due = due;
        this.plannedFrom = plannedFrom;
        this.plannedUntil = plannedUntil;
        this.dueFrom = dueFrom;
        this.dueUntil = dueUntil;
        this.wildcardSearchFields = wildcardSearchFields;
        this.wildcardSearchValue = wildcardSearchValue;
        this.externalIds = externalIds;
        this.custom1 = custom1;
        this.custom2 = custom2;
        this.custom3 = custom3;
        this.custom4 = custom4;
        this.custom5 = custom5;
        this.custom6 = custom6;
        this.custom7 = custom7;
        this.custom8 = custom8;
        this.custom9 = custom9;
        this.custom10 = custom10;
        this.custom11 = custom11;
        this.custom12 = custom12;
        this.custom13 = custom13;
        this.custom14 = custom14;
        this.custom15 = custom15;
        this.custom16 = custom16;
        this.validateFilterParameters();
    }

    @Override
    public Void applyToQuery(TaskQuery query) {
        Optional.ofNullable(this.name).ifPresent(arg_0 -> ((TaskQuery)query).nameIn(arg_0));
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).nameLike(arg_0));
        Optional.ofNullable(this.priority).ifPresent(arg_0 -> ((TaskQuery)query).priorityIn(arg_0));
        Optional.ofNullable(this.state).ifPresent(arg_0 -> ((TaskQuery)query).stateIn(arg_0));
        Optional.ofNullable(this.classificationKeys).ifPresent(arg_0 -> ((TaskQuery)query).classificationKeyIn(arg_0));
        Optional.ofNullable(this.taskIds).ifPresent(arg_0 -> ((TaskQuery)query).idIn(arg_0));
        Optional.ofNullable(this.workbasketIds).ifPresent(arg_0 -> ((TaskQuery)query).workbasketIdIn(arg_0));
        Optional.ofNullable(this.workbasketKeys).map(keys -> (KeyDomain[])Arrays.stream(keys).map(key -> new KeyDomain(key, this.domain)).toArray(KeyDomain[]::new)).ifPresent(arg_0 -> ((TaskQuery)query).workbasketKeyDomainIn(arg_0));
        Optional.ofNullable(this.owner).ifPresent(arg_0 -> ((TaskQuery)query).ownerIn(arg_0));
        Optional.ofNullable(this.ownerLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).ownerLike(arg_0));
        Optional.ofNullable(this.porCompany).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceCompanyIn(arg_0));
        Optional.ofNullable(this.porSystem).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemIn(arg_0));
        Optional.ofNullable(this.porInstance).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemInstanceIn(arg_0));
        Optional.ofNullable(this.porType).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceTypeIn(arg_0));
        Optional.ofNullable(this.porValue).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceValueIn(arg_0));
        Optional.ofNullable(this.planned).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).plannedWithin(arg_0));
        Optional.ofNullable(this.due).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).dueWithin(arg_0));
        if (this.plannedFrom != null || this.plannedUntil != null) {
            query.plannedWithin(new TimeInterval[]{new TimeInterval(this.plannedFrom, this.plannedUntil)});
        }
        if (this.dueFrom != null || this.dueUntil != null) {
            query.dueWithin(new TimeInterval[]{new TimeInterval(this.dueFrom, this.dueUntil)});
        }
        if (this.wildcardSearchFields != null) {
            query.wildcardSearchFieldsIn(this.wildcardSearchFields);
            query.wildcardSearchValueLike("%" + this.wildcardSearchValue + "%");
        }
        Optional.ofNullable(this.externalIds).ifPresent(arg_0 -> ((TaskQuery)query).externalIdIn(arg_0));
        Stream.of(Pair.of((Object)TaskCustomField.CUSTOM_1, (Object)this.custom1), Pair.of((Object)TaskCustomField.CUSTOM_2, (Object)this.custom2), Pair.of((Object)TaskCustomField.CUSTOM_3, (Object)this.custom3), Pair.of((Object)TaskCustomField.CUSTOM_4, (Object)this.custom4), Pair.of((Object)TaskCustomField.CUSTOM_5, (Object)this.custom5), Pair.of((Object)TaskCustomField.CUSTOM_6, (Object)this.custom6), Pair.of((Object)TaskCustomField.CUSTOM_7, (Object)this.custom7), Pair.of((Object)TaskCustomField.CUSTOM_8, (Object)this.custom8), Pair.of((Object)TaskCustomField.CUSTOM_9, (Object)this.custom9), Pair.of((Object)TaskCustomField.CUSTOM_10, (Object)this.custom10), Pair.of((Object)TaskCustomField.CUSTOM_11, (Object)this.custom11), Pair.of((Object)TaskCustomField.CUSTOM_12, (Object)this.custom12), Pair.of((Object)TaskCustomField.CUSTOM_13, (Object)this.custom13), Pair.of((Object)TaskCustomField.CUSTOM_14, (Object)this.custom14), Pair.of((Object)TaskCustomField.CUSTOM_15, (Object)this.custom15), Pair.of((Object)TaskCustomField.CUSTOM_16, (Object)this.custom16)).forEach(pair -> Optional.ofNullable((String[])pair.getRight()).ifPresent(CheckedConsumer.wrap(l -> query.customAttributeIn((TaskCustomField)pair.getLeft(), l))));
        return null;
    }

    private void validateFilterParameters() throws InvalidArgumentException {
        if (this.planned != null && (this.plannedFrom != null || this.plannedUntil != null)) {
            throw new IllegalArgumentException("It is prohibited to use the param 'planned' in combination with the params 'planned-from'  and / or 'planned-until'");
        }
        if (this.due != null && (this.dueFrom != null || this.dueUntil != null)) {
            throw new IllegalArgumentException("It is prohibited to use the param 'due' in combination with the params 'due-from'  and / or 'due-until'");
        }
        if (this.wildcardSearchFields == null ^ this.wildcardSearchValue == null) {
            throw new IllegalArgumentException("The params 'wildcard-search-field' and 'wildcard-search-value' must be used together");
        }
        if (this.workbasketKeys != null && this.domain == null) {
            throw new InvalidArgumentException("'workbasket-key' requires exactly one domain.");
        }
        if (this.planned != null && this.planned.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'planned' is not dividable by 2");
        }
        if (this.due != null && this.due.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'due' is not dividable by 2");
        }
    }
}

