/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest.assembler;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.rest.assembler.CollectionRepresentationModelAssembler;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.internal.models.TaskCommentImpl;
import pro.taskana.task.rest.TaskCommentController;
import pro.taskana.task.rest.models.TaskCommentCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;

@Component
public class TaskCommentRepresentationModelAssembler
implements CollectionRepresentationModelAssembler<TaskComment, TaskCommentRepresentationModel, TaskCommentCollectionRepresentationModel> {
    private final TaskService taskService;

    @Autowired
    public TaskCommentRepresentationModelAssembler(TaskService taskService) {
        this.taskService = taskService;
    }

    @NonNull
    public TaskCommentRepresentationModel toModel(@NonNull TaskComment taskComment) {
        TaskCommentRepresentationModel repModel = new TaskCommentRepresentationModel();
        repModel.setTaskCommentId(taskComment.getId());
        repModel.setTaskId(taskComment.getTaskId());
        repModel.setTextField(taskComment.getTextField());
        repModel.setCreator(taskComment.getCreator());
        repModel.setCreated(taskComment.getCreated());
        repModel.setModified(taskComment.getModified());
        try {
            repModel.add(WebMvcLinkBuilder.linkTo(((TaskCommentController)WebMvcLinkBuilder.methodOn(TaskCommentController.class, (Object[])new Object[0])).getTaskComment(taskComment.getId())).withSelfRel());
        }
        catch (Exception e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
        return repModel;
    }

    @Override
    public TaskCommentCollectionRepresentationModel buildCollectionEntity(List<TaskCommentRepresentationModel> content) {
        return new TaskCommentCollectionRepresentationModel((Collection<TaskCommentRepresentationModel>)content);
    }

    public TaskComment toEntityModel(TaskCommentRepresentationModel repModel) {
        TaskCommentImpl taskComment = (TaskCommentImpl)this.taskService.newTaskComment(repModel.getTaskId());
        taskComment.setId(repModel.getTaskCommentId());
        taskComment.setTextField(repModel.getTextField());
        taskComment.setCreator(repModel.getCreator());
        taskComment.setCreated(repModel.getCreated());
        taskComment.setModified(repModel.getModified());
        return taskComment;
    }
}

