/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketSummaryRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.DistributionTargetsCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketSummaryPagedRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketController.class);
    private final WorkbasketService workbasketService;
    private final WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler;
    private final WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler;

    @Autowired
    WorkbasketController(WorkbasketService workbasketService, WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler, WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler, WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler) {
        this.workbasketService = workbasketService;
        this.workbasketRepresentationModelAssembler = workbasketRepresentationModelAssembler;
        this.workbasketSummaryRepresentationModelAssembler = workbasketSummaryRepresentationModelAssembler;
        this.workbasketAccessItemRepresentationModelAssembler = workbasketAccessItemRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/workbaskets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketSummaryPagedRepresentationModel> getWorkbaskets(HttpServletRequest request, WorkbasketQueryFilterParameter filterParameter, WorkbasketQuerySortParameter sortParameter, QueryPagingParameter<WorkbasketSummary, WorkbasketQuery> pagingParameter) {
        QueryParamsValidator.validateParams(request, WorkbasketQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Object workbasketSummaries = pagingParameter.applyToQuery((BaseQuery)query);
        WorkbasketSummaryPagedRepresentationModel pagedModels = (WorkbasketSummaryPagedRepresentationModel)((Object)this.workbasketSummaryRepresentationModelAssembler.toPagedModel(workbasketSummaries, pagingParameter.getPageMetadata()));
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pagedModels));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbaskets(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getWorkbasket(workbasketId= {})", (Object)workbasketId);
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasket(), returning {}", (Object)result);
        }
        return result;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={WorkbasketNotFoundException.class})
    public ResponseEntity<WorkbasketRepresentationModel> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException, WorkbasketInUseException {
        ResponseEntity response;
        LOGGER.debug("Entry to markWorkbasketForDeletion(workbasketId= {})", (Object)workbasketId);
        boolean workbasketDeleted = this.workbasketService.deleteWorkbasket(workbasketId);
        if (workbasketDeleted) {
            LOGGER.debug("Workbasket successfully deleted.");
            response = ResponseEntity.noContent().build();
        } else {
            LOGGER.debug("Workbasket was only marked for deletion and will be physically deleted later on.");
            response = ResponseEntity.accepted().build();
        }
        LOGGER.debug("Exit from markWorkbasketForDeletion(), returning {}", (Object)response);
        return response;
    }

    @PostMapping(path={"/api/v1/workbaskets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> createWorkbasket(@RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createWorkbasket(workbasketResource= {})", (Object)workbasketRepresentationModel);
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        ResponseEntity response = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createWorkbasket(), returning {}", (Object)response);
        }
        return response;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidWorkbasketException, WorkbasketNotFoundException, NotAuthorizedException, ConcurrencyException {
        LOGGER.debug("Entry to updateWorkbasket(workbasketId= {})", (Object)workbasketId);
        if (!workbasketId.equals(workbasketRepresentationModel.getWorkbasketId())) {
            throw new InvalidWorkbasketException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketRepresentationModel.getWorkbasketId() + "')");
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateWorkbasket(), returning {}", (Object)result);
        }
        return result;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("Entry to getWorkbasketAccessItems(workbasketId= {})", (Object)workbasketId);
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, accessItems)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasketAccessItems(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketAccessItemCollectionRepresentationModel workbasketAccessItemRepModels) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException {
        LOGGER.debug("Entry to setWorkbasketAccessItems(workbasketId= {})", (Object)workbasketId);
        if (workbasketAccessItemRepModels == null) {
            throw new InvalidArgumentException("Can\u00b4t create something with NULL body-value.");
        }
        List wbAccessItems = workbasketAccessItemRepModels.getContent().stream().map(this.workbasketAccessItemRepresentationModelAssembler::toEntityModel).collect(Collectors.toList());
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, updatedWbAccessItems)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from setWorkbasketAccessItems(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to getDistributionTargets(workbasketId= {})", (Object)workbasketId);
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        DistributionTargetsCollectionRepresentationModel distributionTargetRepModels = (DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)distributionTargetRepModels));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getDistributionTargets(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTasksStatusReport(workbasketId= {}, targetWorkbasketIds\u00b4= {})", (Object)sourceWorkbasketId, targetWorkbasketIds);
        }
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)((DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets))));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksStatusReport(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> removeDistributionTargetForWorkbasketId(@PathVariable(value="workbasketId") String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("Entry to removeDistributionTargetForWorkbasketId(workbasketId= {})", (Object)targetWorkbasketId);
        List sourceWorkbaskets = this.workbasketService.getDistributionSources(targetWorkbasketId);
        for (WorkbasketSummary source : sourceWorkbaskets) {
            this.workbasketService.removeDistributionTarget(source.getId(), targetWorkbasketId);
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from removeDistributionTargetForWorkbasketId(), returning {}", (Object)response);
        return response;
    }

    public static class WorkbasketQuerySortParameter
    extends QuerySortParameter<WorkbasketQuery, WorkbasketQuerySortBy> {
        @ConstructorProperties(value={"sort-by", "order"})
        public WorkbasketQuerySortParameter(List<WorkbasketQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<WorkbasketQuerySortBy> getSortBy() {
            return super.getSortBy();
        }
    }

    public static enum WorkbasketQuerySortBy implements QuerySortBy<WorkbasketQuery>
    {
        NAME(WorkbasketQuery::orderByName),
        KEY(WorkbasketQuery::orderByKey),
        OWNER(WorkbasketQuery::orderByOwner),
        TYPE(WorkbasketQuery::orderByType),
        DESCRIPTION(WorkbasketQuery::orderByDescription);

        private final BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer;

        private WorkbasketQuerySortBy(BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(WorkbasketQuery query, BaseQuery.SortDirection sortDirection) {
            this.consumer.accept(query, sortDirection);
        }
    }
}

