/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Optional;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketType;

public class WorkbasketQueryFilterParameter
implements QueryParameter<WorkbasketQuery, Void> {
    private final String[] name;
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    private final String[] key;
    @JsonProperty(value="key-like")
    private final String[] keyLike;
    private final String[] owner;
    @JsonProperty(value="owner-like")
    private final String[] ownerLike;
    @JsonProperty(value="description-like")
    private final String[] descriptionLike;
    private final String[] domain;
    private final WorkbasketType[] type;
    @JsonProperty(value="required-permission")
    private final WorkbasketPermission requiredPermissions;

    @ConstructorProperties(value={"name", "name-like", "key", "key-like", "owner", "owner-like", "description-like", "domain", "type", "required-permission"})
    public WorkbasketQueryFilterParameter(String[] name, String[] nameLike, String[] key, String[] keyLike, String[] owner, String[] ownerLike, String[] descriptionLike, String[] domain, WorkbasketType[] type, WorkbasketPermission requiredPermissions) {
        this.name = name;
        this.nameLike = nameLike;
        this.key = key;
        this.keyLike = keyLike;
        this.owner = owner;
        this.ownerLike = ownerLike;
        this.descriptionLike = descriptionLike;
        this.domain = domain;
        this.type = type;
        this.requiredPermissions = requiredPermissions;
    }

    @Override
    public Void applyToQuery(WorkbasketQuery query) {
        Optional.ofNullable(this.name).ifPresent(arg_0 -> ((WorkbasketQuery)query).nameIn(arg_0));
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((WorkbasketQuery)query).nameLike(arg_0));
        Optional.ofNullable(this.key).ifPresent(arg_0 -> ((WorkbasketQuery)query).keyIn(arg_0));
        Optional.ofNullable(this.keyLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((WorkbasketQuery)query).keyLike(arg_0));
        Optional.ofNullable(this.owner).ifPresent(arg_0 -> ((WorkbasketQuery)query).ownerIn(arg_0));
        Optional.ofNullable(this.ownerLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((WorkbasketQuery)query).ownerLike(arg_0));
        Optional.ofNullable(this.descriptionLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((WorkbasketQuery)query).descriptionLike(arg_0));
        Optional.ofNullable(this.domain).ifPresent(arg_0 -> ((WorkbasketQuery)query).domainIn(arg_0));
        Optional.ofNullable(this.type).ifPresent(arg_0 -> ((WorkbasketQuery)query).typeIn(arg_0));
        Optional.ofNullable(this.requiredPermissions).ifPresent(arg_0 -> ((WorkbasketQuery)query).callerHasPermission(arg_0));
        return null;
    }
}

