/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.Min;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.common.rest.models.PageMetadata;

public class QueryPagingParameter<T, Q extends BaseQuery<T, ?>>
implements QueryParameter<Q, List<T>> {
    @Min(value=1L)
    private final @Min(value=1L) Integer page;
    @JsonProperty(value="page-size")
    @Min(value=1L)
    private final @Min(value=1L) Integer pageSize;
    @JsonIgnore
    private PageMetadata pageMetadata;

    @ConstructorProperties(value={"page", "page-size"})
    public QueryPagingParameter(Integer page, Integer pageSize) {
        if (pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
        this.page = page;
        this.pageSize = pageSize;
    }

    public PageMetadata getPageMetadata() {
        return this.pageMetadata;
    }

    @Override
    public List<T> applyToQuery(Q query) {
        this.initPageMetaData(query);
        List resultList = this.pageMetadata != null ? query.listPage(Math.toIntExact(this.pageMetadata.getNumber()), Math.toIntExact(this.pageMetadata.getSize())) : query.list();
        return resultList;
    }

    private void initPageMetaData(Q query) {
        if (this.page != null) {
            long totalElements = query.count();
            long maxPages = (long)Math.ceil((double)totalElements / this.pageSize.doubleValue());
            this.pageMetadata = new PageMetadata(this.pageSize.intValue(), totalElements, maxPages, Math.min((long)this.page.intValue(), maxPages));
        }
    }
}

