/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.NotFoundException;
import pro.taskana.common.rest.models.TaskanaErrorData;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={InvalidArgumentException.class})
    protected ResponseEntity<Object> handleInvalidArgument(InvalidArgumentException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST, false);
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    protected ResponseEntity<Object> handleNotAuthorized(NotAuthorizedException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotFoundException.class})
    protected ResponseEntity<Object> handleTaskNotFound(NotFoundException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class})
    protected ResponseEntity<Object> handleTaskAlreadyExist(TaskAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<Object> handleNotAuthorizedToQueryWorkbasket(NotAuthorizedToQueryWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InvalidStateException.class})
    protected ResponseEntity<Object> handleInvalidState(InvalidStateException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidOwnerException.class})
    protected ResponseEntity<Object> handleInvalidOwner(InvalidOwnerException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ClassificationAlreadyExistException.class})
    protected ResponseEntity<Object> handleClassificationAlreadyExist(ClassificationAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ResponseEntity<Object> handleDuplicateKey(DuplicateKeyException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ConcurrencyException.class})
    protected ResponseEntity<Object> handleConcurrencyException(ConcurrencyException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketInUseException.class})
    protected ResponseEntity<Object> handleWorkbasketInUse(WorkbasketInUseException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.LOCKED);
    }

    @ExceptionHandler(value={WorkbasketAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAlreadyExist(WorkbasketAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketAccessItemAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAccessItemAlreadyExist(WorkbasketAccessItemAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidWorkbasketException.class})
    protected ResponseEntity<Object> handleInvalidWorkbasket(InvalidWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DomainNotFoundException.class})
    protected ResponseEntity<Object> handleDomainNotFound(DomainNotFoundException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        return this.buildResponse((Throwable)ex, req, HttpStatus.PAYLOAD_TOO_LARGE);
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.buildResponse((Throwable)ex, request, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        return this.buildResponse(ex, req, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> buildResponse(Throwable ex, WebRequest req, HttpStatus status) {
        return this.buildResponse(ex, req, status, true);
    }

    private ResponseEntity<Object> buildResponse(Throwable ex, WebRequest req, HttpStatus status, boolean logExceptionOnError) {
        TaskanaErrorData errorData = new TaskanaErrorData(status, ex, req);
        if (logExceptionOnError) {
            this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), ex);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), ex);
        }
        return ResponseEntity.status((HttpStatus)status).body((Object)errorData);
    }
}

