/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.assembler;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import pro.taskana.common.rest.models.PageMetadata;
import pro.taskana.common.rest.models.PagedRepresentationModel;

public interface PagedRepresentationModelAssembler<T, D extends RepresentationModel<? super D>, P extends PagedRepresentationModel<D>>
extends RepresentationModelAssembler<T, D> {
    public P buildPageableEntity(Collection<D> var1, PageMetadata var2);

    default public P toPagedModel(Iterable<T> entities, PageMetadata pageMetadata) {
        return (P)((Object)StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((PagedRepresentationModelAssembler)this).toModel(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), content -> this.addLinksToPagedModel(this.buildPageableEntity((Collection<D>)content, pageMetadata)))));
    }

    default public P addLinksToPagedModel(P model) {
        ServletUriComponentsBuilder original = ServletUriComponentsBuilder.fromCurrentRequest();
        PageMetadata page = ((PagedRepresentationModel)((Object)model)).getPageMetadata();
        model.add(Link.of((String)original.toUriString()).withSelfRel());
        if (page != null) {
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel(IanaLinkRelations.FIRST));
            model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getTotalPages()}).toUriString()).withRel(IanaLinkRelations.LAST));
            if (page.getNumber() > 1L) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() - 1L}).toUriString()).withRel(IanaLinkRelations.PREV));
            }
            if (page.getNumber() < page.getTotalPages()) {
                model.add(Link.of((String)original.replaceQueryParam("page", new Object[]{page.getNumber() + 1L}).toUriString()).withRel(IanaLinkRelations.NEXT));
            }
        }
        return model;
    }
}

