/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.ldap;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
public class LdapConfiguration {
    private final String ldapServerUrl;
    private final String ldapBaseDn;
    private final String ldapBindDn;
    private final String ldapBindPassword;

    public LdapConfiguration(@Value(value="${taskana.ldap.serverUrl:ldap://localhost:10389}") String ldapServerUrl, @Value(value="${taskana.ldap.baseDn:OU=Test,O=TASKANA}") String ldapBaseDn, @Value(value="${taskana.ldap.bindDn:uid=admin}") String ldapBindDn, @Value(value="${taskana.ldap.bindPassword:secret}") String ldapBindPassword) {
        this.ldapServerUrl = ldapServerUrl;
        this.ldapBaseDn = ldapBaseDn;
        this.ldapBindDn = ldapBindDn;
        this.ldapBindPassword = ldapBindPassword;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapContextSource.class})
    public LdapContextSource ldapContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapServerUrl);
        contextSource.setBase(this.ldapBaseDn);
        contextSource.setUserDn(this.ldapBindDn);
        contextSource.setPassword(this.ldapBindPassword);
        return contextSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapTemplate.class})
    public LdapTemplate ldapTemplate(LdapContextSource ldapContextSource) {
        return new LdapTemplate((ContextSource)ldapContextSource);
    }
}

