/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.WildcardSearchField;
import pro.taskana.task.api.models.ObjectReference;

public class TaskQueryFilterParameter
implements QueryParameter<TaskQuery, Void> {
    private final String[] name;
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    private final int[] priority;
    private final TaskState[] state;
    @JsonProperty(value="classification-id")
    private final String[] classificationId;
    @JsonProperty(value="classification.key")
    private final String[] classificationKeys;
    @JsonProperty(value="classification-key-like")
    private final String[] classificationKeysLike;
    @JsonProperty(value="classification-key-not-in")
    private final String[] classificationKeysNotIn;
    @JsonProperty(value="is-read")
    private final Boolean isRead;
    @JsonProperty(value="is-transferred")
    private final Boolean isTransferred;
    @JsonProperty(value="object-reference")
    private final ObjectReference[] objectReferences;
    @JsonProperty(value="callback-state")
    private final CallbackState[] callbackStates;
    @JsonProperty(value="attachment-classification-key")
    private final String[] attachmentClassificationKeys;
    @JsonProperty(value="attachment-classification-key-like")
    private final String[] attachmentClassificationKeysLike;
    @JsonProperty(value="attachment-classification-id")
    private final String[] attachmentClassificationId;
    @JsonProperty(value="attachment-classification-id-like")
    private final String[] attachmentClassificationIdLike;
    @JsonProperty(value="attachment-channel")
    private final String[] attachmentChannel;
    @JsonProperty(value="attachment-channel-like")
    private final String[] attachmentChannelLike;
    @JsonProperty(value="attachment-reference")
    private final String[] attachmentReference;
    @JsonProperty(value="attachment-reference-like")
    private final String[] attachmentReferenceLike;
    @JsonProperty(value="attachment-received")
    private final Instant[] attachmentReceived;
    private final Instant[] created;
    private final Instant[] claimed;
    private final Instant[] completed;
    private final Instant[] modified;
    @JsonProperty(value="classification-category")
    private final String[] classificationCategories;
    @JsonProperty(value="classification-category-like")
    private final String[] classificationCategoriesLike;
    @JsonProperty(value="classification-name")
    private final String[] classificationNames;
    @JsonProperty(value="classification-name-like")
    private final String[] classificationNamesLike;
    @JsonProperty(value="attachment-classification-name")
    private final String[] attachmentClassificationNames;
    @JsonProperty(value="attachment-classification-name-like")
    private final String[] attachmentClassificationNamesLike;
    @JsonProperty(value="parent-business-process-id")
    private final String[] parentBusinessProcessIds;
    @JsonProperty(value="parent-business-process-id-like")
    private final String[] parentBusinessProcessIdsLike;
    @JsonProperty(value="business-process-id")
    private final String[] businessProcessIds;
    @JsonProperty(value="business-process-id-like")
    private final String[] businessProcessIdsLike;
    @JsonProperty(value="task-id")
    private final String[] taskIds;
    @JsonProperty(value="workbasket-id")
    private final String[] workbasketIds;
    @JsonProperty(value="workbasket-key")
    private final String[] workbasketKeys;
    private final String domain;
    private final String[] owner;
    @JsonProperty(value="owner-like")
    private final String[] ownerLike;
    private final String[] creator;
    @JsonProperty(value="creator-like")
    private final String[] creatorLike;
    @JsonProperty(value="note-like")
    private final String[] noteLike;
    @JsonProperty(value="por.company")
    private final String[] porCompany;
    @JsonProperty(value="por-company-like")
    private final String[] porCompanyLike;
    @JsonProperty(value="por.system")
    private final String[] porSystem;
    @JsonProperty(value="por-system-like")
    private final String[] porSystemLike;
    @JsonProperty(value="por.instance")
    private final String[] porInstance;
    @JsonProperty(value="por-instance-like")
    private final String[] porInstanceLike;
    @JsonProperty(value="por.type")
    private final String[] porType;
    @JsonProperty(value="por-type-like")
    private final String[] porTypeLike;
    @JsonProperty(value="por.value")
    private final String[] porValue;
    @JsonProperty(value="por-value-like")
    private final String[] porValueLike;
    private final Instant[] planned;
    @JsonProperty(value="planned-from")
    private final Instant plannedFrom;
    @JsonProperty(value="planned-until")
    private final Instant plannedUntil;
    private final Instant[] due;
    @JsonProperty(value="due-from")
    private final Instant dueFrom;
    @JsonProperty(value="due-until")
    private final Instant dueUntil;
    @JsonProperty(value="wildcard-search-fields")
    private final WildcardSearchField[] wildcardSearchFields;
    @JsonProperty(value="wildcard-search-value")
    private final String wildcardSearchValue;
    @JsonProperty(value="external-id")
    private final String[] externalIds;
    @JsonProperty(value="external-id-like")
    private final String[] externalIdsLike;
    @JsonProperty(value="custom-1")
    private final String[] custom1;
    @JsonProperty(value="custom-1-like")
    private final String[] custom1Like;
    @JsonProperty(value="custom-2")
    private final String[] custom2;
    @JsonProperty(value="custom-2-like")
    private final String[] custom2Like;
    @JsonProperty(value="custom-3")
    private final String[] custom3;
    @JsonProperty(value="custom-3-like")
    private final String[] custom3Like;
    @JsonProperty(value="custom-4")
    private final String[] custom4;
    @JsonProperty(value="custom-4-like")
    private final String[] custom4Like;
    @JsonProperty(value="custom-5")
    private final String[] custom5;
    @JsonProperty(value="custom-5-like")
    private final String[] custom5Like;
    @JsonProperty(value="custom-6")
    private final String[] custom6;
    @JsonProperty(value="custom-6-like")
    private final String[] custom6Like;
    @JsonProperty(value="custom-7")
    private final String[] custom7;
    @JsonProperty(value="custom-7-like")
    private final String[] custom7Like;
    @JsonProperty(value="custom-8")
    private final String[] custom8;
    @JsonProperty(value="custom-8-like")
    private final String[] custom8Like;
    @JsonProperty(value="custom-9")
    private final String[] custom9;
    @JsonProperty(value="custom-9-like")
    private final String[] custom9Like;
    @JsonProperty(value="custom-10")
    private final String[] custom10;
    @JsonProperty(value="custom-10-like")
    private final String[] custom10Like;
    @JsonProperty(value="custom-11")
    private final String[] custom11;
    @JsonProperty(value="custom-11-like")
    private final String[] custom11Like;
    @JsonProperty(value="custom-12")
    private final String[] custom12;
    @JsonProperty(value="custom-12-like")
    private final String[] custom12Like;
    @JsonProperty(value="custom-13")
    private final String[] custom13;
    @JsonProperty(value="custom-13-like")
    private final String[] custom13Like;
    @JsonProperty(value="custom-14")
    private final String[] custom14;
    @JsonProperty(value="custom-14-like")
    private final String[] custom14Like;
    @JsonProperty(value="custom-15")
    private final String[] custom15;
    @JsonProperty(value="custom-15-like")
    private final String[] custom15Like;
    @JsonProperty(value="custom-16")
    private final String[] custom16;
    @JsonProperty(value="custom-16-like")
    private final String[] custom16Like;

    @ConstructorProperties(value={"name", "name-like", "priority", "state", "classification-id", "classification.key", "classification-key-like", "classification-key-not-in", "is-read", "is-transferred", "object-reference", "callback-state", "attachment-classification-key", "attachment-classification-key-like", "attachment-classification-id", "attachment-classification-id-like", "attachment-channel", "attachment-channel-like", "attachment-reference", "attachment-reference-like", "attachment-received", "created", "claimed", "completed", "modified", "classification-category", "classification-category-like", "classification-name", "classification-name-like", "attachment-classification-name", "attachment-classification-name-like", "parent-business-process-id", "parent-business-process-id-like", "business-process-id", "business-process-id-like", "task-id", "workbasket-id", "workbasket-key", "domain", "owner", "owner-like", "creator", "creator-like", "note-like", "por.company", "por-company-like", "por.system", "por-system-like", "por.instance", "por-instance-like", "por.type", "por-type-like", "por.value", "por-value-like", "planned", "planned-from", "planned-until", "due", "due-from", "due-until", "wildcard-search-fields", "wildcard-search-value", "external-id", "external-id-like", "custom-1", "custom-1-like", "custom-2", "custom-2-like", "custom-3", "custom-3-like", "custom-4", "custom-4-like", "custom-5", "custom-5-like", "custom-6", "custom-6-like", "custom-7", "custom-7-like", "custom-8", "custom-8-like", "custom-9", "custom-9-like", "custom-10", "custom-10-like", "custom-11", "custom-11-like", "custom-12", "custom-12-like", "custom-13", "custom-13-like", "custom-14", "custom-14-like", "custom-15", "custom-15-like", "custom-16", "custom-16-like"})
    public TaskQueryFilterParameter(String[] name, String[] nameLike, int[] priority, TaskState[] state, String[] classificationId, String[] classificationKeys, String[] classificationKeysLike, String[] classificationKeysNotIn, Boolean isRead, Boolean isTransferred, ObjectReference[] objectReferences, CallbackState[] callbackStates, String[] attachmentClassificationKeys, String[] attachmentClassificationKeysLike, String[] attachmentClassificationId, String[] attachmentClassificationIdLike, String[] attachmentChannel, String[] attachmentChannelLike, String[] attachmentReference, String[] attachmentReferenceLike, Instant[] attachmentReceived, Instant[] created, Instant[] claimed, Instant[] completed, Instant[] modified, String[] classificationCategories, String[] classificationCategoriesLike, String[] classificationNames, String[] classificationNamesLike, String[] attachmentClassificationNames, String[] attachmentClassificationNamesLike, String[] parentBusinessProcessIds, String[] parentBusinessProcessIdsLike, String[] businessProcessIds, String[] businessProcessIdsLike, String[] taskIds, String[] workbasketIds, String[] workbasketKeys, String domain, String[] owner, String[] ownerLike, String[] creator, String[] creatorLike, String[] noteLike, String[] porCompany, String[] porCompanyLike, String[] porSystem, String[] porSystemLike, String[] porInstance, String[] porInstanceLike, String[] porType, String[] porTypeLike, String[] porValue, String[] porValueLike, Instant[] planned, Instant plannedFrom, Instant plannedUntil, Instant[] due, Instant dueFrom, Instant dueUntil, WildcardSearchField[] wildcardSearchFields, String wildcardSearchValue, String[] externalIds, String[] externalIdsLike, String[] custom1, String[] custom1Like, String[] custom2, String[] custom2Like, String[] custom3, String[] custom3Like, String[] custom4, String[] custom4Like, String[] custom5, String[] custom5Like, String[] custom6, String[] custom6Like, String[] custom7, String[] custom7Like, String[] custom8, String[] custom8Like, String[] custom9, String[] custom9Like, String[] custom10, String[] custom10Like, String[] custom11, String[] custom11Like, String[] custom12, String[] custom12Like, String[] custom13, String[] custom13Like, String[] custom14, String[] custom14Like, String[] custom15, String[] custom15Like, String[] custom16, String[] custom16Like) throws InvalidArgumentException {
        this.name = name;
        this.nameLike = nameLike;
        this.priority = priority;
        this.state = state;
        this.classificationId = classificationId;
        this.classificationKeys = classificationKeys;
        this.classificationKeysLike = classificationKeysLike;
        this.classificationKeysNotIn = classificationKeysNotIn;
        this.isRead = isRead;
        this.isTransferred = isTransferred;
        this.objectReferences = objectReferences;
        this.callbackStates = callbackStates;
        this.attachmentClassificationKeys = attachmentClassificationKeys;
        this.attachmentClassificationKeysLike = attachmentClassificationKeysLike;
        this.attachmentClassificationId = attachmentClassificationId;
        this.attachmentClassificationIdLike = attachmentClassificationIdLike;
        this.attachmentChannel = attachmentChannel;
        this.attachmentChannelLike = attachmentChannelLike;
        this.attachmentReference = attachmentReference;
        this.attachmentReferenceLike = attachmentReferenceLike;
        this.attachmentReceived = attachmentReceived;
        this.created = created;
        this.claimed = claimed;
        this.completed = completed;
        this.modified = modified;
        this.classificationCategories = classificationCategories;
        this.classificationCategoriesLike = classificationCategoriesLike;
        this.classificationNames = classificationNames;
        this.classificationNamesLike = classificationNamesLike;
        this.attachmentClassificationNames = attachmentClassificationNames;
        this.attachmentClassificationNamesLike = attachmentClassificationNamesLike;
        this.parentBusinessProcessIds = parentBusinessProcessIds;
        this.parentBusinessProcessIdsLike = parentBusinessProcessIdsLike;
        this.businessProcessIds = businessProcessIds;
        this.businessProcessIdsLike = businessProcessIdsLike;
        this.taskIds = taskIds;
        this.workbasketIds = workbasketIds;
        this.workbasketKeys = workbasketKeys;
        this.domain = domain;
        this.owner = owner;
        this.ownerLike = ownerLike;
        this.creator = creator;
        this.creatorLike = creatorLike;
        this.noteLike = noteLike;
        this.porCompany = porCompany;
        this.porCompanyLike = porCompanyLike;
        this.porSystem = porSystem;
        this.porSystemLike = porSystemLike;
        this.porInstance = porInstance;
        this.porInstanceLike = porInstanceLike;
        this.porType = porType;
        this.porTypeLike = porTypeLike;
        this.porValue = porValue;
        this.porValueLike = porValueLike;
        this.planned = planned;
        this.plannedFrom = plannedFrom;
        this.plannedUntil = plannedUntil;
        this.due = due;
        this.dueFrom = dueFrom;
        this.dueUntil = dueUntil;
        this.wildcardSearchFields = wildcardSearchFields;
        this.wildcardSearchValue = wildcardSearchValue;
        this.externalIds = externalIds;
        this.externalIdsLike = externalIdsLike;
        this.custom1 = custom1;
        this.custom1Like = custom1Like;
        this.custom2 = custom2;
        this.custom2Like = custom2Like;
        this.custom3 = custom3;
        this.custom3Like = custom3Like;
        this.custom4 = custom4;
        this.custom4Like = custom4Like;
        this.custom5 = custom5;
        this.custom5Like = custom5Like;
        this.custom6 = custom6;
        this.custom6Like = custom6Like;
        this.custom7 = custom7;
        this.custom7Like = custom7Like;
        this.custom8 = custom8;
        this.custom8Like = custom8Like;
        this.custom9 = custom9;
        this.custom9Like = custom9Like;
        this.custom10 = custom10;
        this.custom10Like = custom10Like;
        this.custom11 = custom11;
        this.custom11Like = custom11Like;
        this.custom12 = custom12;
        this.custom12Like = custom12Like;
        this.custom13 = custom13;
        this.custom13Like = custom13Like;
        this.custom14 = custom14;
        this.custom14Like = custom14Like;
        this.custom15 = custom15;
        this.custom15Like = custom15Like;
        this.custom16 = custom16;
        this.custom16Like = custom16Like;
        this.validateFilterParameters();
    }

    @Override
    public Void applyToQuery(TaskQuery query) {
        Optional.ofNullable(this.name).ifPresent(arg_0 -> ((TaskQuery)query).nameIn(arg_0));
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).nameLike(arg_0));
        Optional.ofNullable(this.priority).ifPresent(arg_0 -> ((TaskQuery)query).priorityIn(arg_0));
        Optional.ofNullable(this.state).ifPresent(arg_0 -> ((TaskQuery)query).stateIn(arg_0));
        Optional.ofNullable(this.classificationId).ifPresent(arg_0 -> ((TaskQuery)query).classificationIdIn(arg_0));
        Optional.ofNullable(this.classificationKeys).ifPresent(arg_0 -> ((TaskQuery)query).classificationKeyIn(arg_0));
        Optional.ofNullable(this.classificationKeysLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).classificationKeyLike(arg_0));
        Optional.ofNullable(this.classificationKeysNotIn).ifPresent(arg_0 -> ((TaskQuery)query).classificationKeyNotIn(arg_0));
        Optional.ofNullable(this.isRead).ifPresent(arg_0 -> ((TaskQuery)query).readEquals(arg_0));
        Optional.ofNullable(this.isTransferred).ifPresent(arg_0 -> ((TaskQuery)query).transferredEquals(arg_0));
        Optional.ofNullable(this.objectReferences).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceIn(arg_0));
        Optional.ofNullable(this.callbackStates).ifPresent(arg_0 -> ((TaskQuery)query).callbackStateIn(arg_0));
        Optional.ofNullable(this.attachmentClassificationKeys).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationKeyIn(arg_0));
        Optional.ofNullable(this.attachmentClassificationKeysLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationKeyLike(arg_0));
        Optional.ofNullable(this.attachmentClassificationId).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationIdIn(arg_0));
        Optional.ofNullable(this.attachmentClassificationIdLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationIdLike(arg_0));
        Optional.ofNullable(this.attachmentChannel).ifPresent(arg_0 -> ((TaskQuery)query).attachmentChannelIn(arg_0));
        Optional.ofNullable(this.attachmentChannelLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).attachmentChannelLike(arg_0));
        Optional.ofNullable(this.attachmentReference).ifPresent(arg_0 -> ((TaskQuery)query).attachmentReferenceValueIn(arg_0));
        Optional.ofNullable(this.attachmentReferenceLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).attachmentReferenceValueLike(arg_0));
        Optional.ofNullable(this.attachmentReceived).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).attachmentReceivedWithin(arg_0));
        Optional.ofNullable(this.created).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).createdWithin(arg_0));
        Optional.ofNullable(this.claimed).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).claimedWithin(arg_0));
        Optional.ofNullable(this.completed).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).completedWithin(arg_0));
        Optional.ofNullable(this.modified).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).modifiedWithin(arg_0));
        Optional.ofNullable(this.classificationCategories).ifPresent(arg_0 -> ((TaskQuery)query).classificationCategoryIn(arg_0));
        Optional.ofNullable(this.classificationCategoriesLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).classificationCategoryLike(arg_0));
        Optional.ofNullable(this.classificationNames).ifPresent(arg_0 -> ((TaskQuery)query).classificationNameIn(arg_0));
        Optional.ofNullable(this.classificationNamesLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).classificationNameLike(arg_0));
        Optional.ofNullable(this.attachmentClassificationNames).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationNameIn(arg_0));
        Optional.ofNullable(this.attachmentClassificationNamesLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).attachmentClassificationNameLike(arg_0));
        Optional.ofNullable(this.parentBusinessProcessIds).ifPresent(arg_0 -> ((TaskQuery)query).parentBusinessProcessIdIn(arg_0));
        Optional.ofNullable(this.parentBusinessProcessIdsLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).parentBusinessProcessIdLike(arg_0));
        Optional.ofNullable(this.businessProcessIds).ifPresent(arg_0 -> ((TaskQuery)query).businessProcessIdIn(arg_0));
        Optional.ofNullable(this.businessProcessIdsLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).businessProcessIdLike(arg_0));
        Optional.ofNullable(this.taskIds).ifPresent(arg_0 -> ((TaskQuery)query).idIn(arg_0));
        Optional.ofNullable(this.workbasketIds).ifPresent(arg_0 -> ((TaskQuery)query).workbasketIdIn(arg_0));
        Optional.ofNullable(this.workbasketKeys).map(keys -> (KeyDomain[])Arrays.stream(keys).map(key -> new KeyDomain(key, this.domain)).toArray(KeyDomain[]::new)).ifPresent(arg_0 -> ((TaskQuery)query).workbasketKeyDomainIn(arg_0));
        Optional.ofNullable(this.owner).ifPresent(arg_0 -> ((TaskQuery)query).ownerIn(arg_0));
        Optional.ofNullable(this.ownerLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).ownerLike(arg_0));
        Optional.ofNullable(this.creator).ifPresent(arg_0 -> ((TaskQuery)query).creatorIn(arg_0));
        Optional.ofNullable(this.creatorLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).creatorLike(arg_0));
        Optional.ofNullable(this.noteLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).noteLike(arg_0));
        Optional.ofNullable(this.porCompany).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceCompanyIn(arg_0));
        Optional.ofNullable(this.porCompanyLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceCompanyLike(arg_0));
        Optional.ofNullable(this.porSystem).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemIn(arg_0));
        Optional.ofNullable(this.porSystemLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemLike(arg_0));
        Optional.ofNullable(this.porInstance).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemInstanceIn(arg_0));
        Optional.ofNullable(this.porInstanceLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceSystemInstanceLike(arg_0));
        Optional.ofNullable(this.porType).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceTypeIn(arg_0));
        Optional.ofNullable(this.porTypeLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceTypeLike(arg_0));
        Optional.ofNullable(this.porValue).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceValueIn(arg_0));
        Optional.ofNullable(this.porValueLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).primaryObjectReferenceValueLike(arg_0));
        Optional.ofNullable(this.planned).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).plannedWithin(arg_0));
        if (this.plannedFrom != null || this.plannedUntil != null) {
            query.plannedWithin(new TimeInterval[]{new TimeInterval(this.plannedFrom, this.plannedUntil)});
        }
        Optional.ofNullable(this.due).map(this::extractTimeIntervals).ifPresent(arg_0 -> ((TaskQuery)query).dueWithin(arg_0));
        if (this.dueFrom != null || this.dueUntil != null) {
            query.dueWithin(new TimeInterval[]{new TimeInterval(this.dueFrom, this.dueUntil)});
        }
        if (this.wildcardSearchFields != null) {
            query.wildcardSearchFieldsIn(this.wildcardSearchFields);
            query.wildcardSearchValueLike("%" + this.wildcardSearchValue + "%");
        }
        Optional.ofNullable(this.externalIds).ifPresent(arg_0 -> ((TaskQuery)query).externalIdIn(arg_0));
        Optional.ofNullable(this.externalIdsLike).map(this::wrapElementsInLikeStatement).ifPresent(arg_0 -> ((TaskQuery)query).externalIdLike(arg_0));
        Stream.of(Pair.of((Object)TaskCustomField.CUSTOM_1, (Object)this.custom1), Pair.of((Object)TaskCustomField.CUSTOM_2, (Object)this.custom2), Pair.of((Object)TaskCustomField.CUSTOM_3, (Object)this.custom3), Pair.of((Object)TaskCustomField.CUSTOM_4, (Object)this.custom4), Pair.of((Object)TaskCustomField.CUSTOM_5, (Object)this.custom5), Pair.of((Object)TaskCustomField.CUSTOM_6, (Object)this.custom6), Pair.of((Object)TaskCustomField.CUSTOM_7, (Object)this.custom7), Pair.of((Object)TaskCustomField.CUSTOM_8, (Object)this.custom8), Pair.of((Object)TaskCustomField.CUSTOM_9, (Object)this.custom9), Pair.of((Object)TaskCustomField.CUSTOM_10, (Object)this.custom10), Pair.of((Object)TaskCustomField.CUSTOM_11, (Object)this.custom11), Pair.of((Object)TaskCustomField.CUSTOM_12, (Object)this.custom12), Pair.of((Object)TaskCustomField.CUSTOM_13, (Object)this.custom13), Pair.of((Object)TaskCustomField.CUSTOM_14, (Object)this.custom14), Pair.of((Object)TaskCustomField.CUSTOM_15, (Object)this.custom15), Pair.of((Object)TaskCustomField.CUSTOM_16, (Object)this.custom16)).forEach(pair -> Optional.ofNullable((String[])pair.getRight()).ifPresent(CheckedConsumer.wrap(l -> query.customAttributeIn((TaskCustomField)pair.getLeft(), l))));
        Stream.of(Pair.of((Object)TaskCustomField.CUSTOM_1, (Object)this.custom1Like), Pair.of((Object)TaskCustomField.CUSTOM_2, (Object)this.custom2Like), Pair.of((Object)TaskCustomField.CUSTOM_3, (Object)this.custom3Like), Pair.of((Object)TaskCustomField.CUSTOM_4, (Object)this.custom4Like), Pair.of((Object)TaskCustomField.CUSTOM_5, (Object)this.custom5Like), Pair.of((Object)TaskCustomField.CUSTOM_6, (Object)this.custom6Like), Pair.of((Object)TaskCustomField.CUSTOM_7, (Object)this.custom7Like), Pair.of((Object)TaskCustomField.CUSTOM_8, (Object)this.custom8Like), Pair.of((Object)TaskCustomField.CUSTOM_9, (Object)this.custom9Like), Pair.of((Object)TaskCustomField.CUSTOM_10, (Object)this.custom10Like), Pair.of((Object)TaskCustomField.CUSTOM_11, (Object)this.custom11Like), Pair.of((Object)TaskCustomField.CUSTOM_12, (Object)this.custom12Like), Pair.of((Object)TaskCustomField.CUSTOM_13, (Object)this.custom13Like), Pair.of((Object)TaskCustomField.CUSTOM_14, (Object)this.custom14Like), Pair.of((Object)TaskCustomField.CUSTOM_15, (Object)this.custom15Like), Pair.of((Object)TaskCustomField.CUSTOM_16, (Object)this.custom16Like)).forEach(pair -> Optional.ofNullable((String[])pair.getRight()).map(this::wrapElementsInLikeStatement).ifPresent(CheckedConsumer.wrap(l -> query.customAttributeLike((TaskCustomField)pair.getLeft(), l))));
        return null;
    }

    private void validateFilterParameters() throws InvalidArgumentException {
        if (this.planned != null && (this.plannedFrom != null || this.plannedUntil != null)) {
            throw new IllegalArgumentException("It is prohibited to use the param 'planned' in combination with the params 'planned-from'  and / or 'planned-until'");
        }
        if (this.due != null && (this.dueFrom != null || this.dueUntil != null)) {
            throw new IllegalArgumentException("It is prohibited to use the param 'due' in combination with the params 'due-from'  and / or 'due-until'");
        }
        if (this.wildcardSearchFields == null ^ this.wildcardSearchValue == null) {
            throw new IllegalArgumentException("The params 'wildcard-search-field' and 'wildcard-search-value' must be used together");
        }
        if (this.workbasketKeys != null && this.domain == null) {
            throw new InvalidArgumentException("'workbasket-key' requires exactly one domain.");
        }
        if (this.planned != null && this.planned.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'planned' is not dividable by 2");
        }
        if (this.due != null && this.due.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'due' is not dividable by 2");
        }
        if (this.modified != null && this.modified.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'modified' is not dividable by 2");
        }
        if (this.created != null && this.created.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'created' is not dividable by 2");
        }
        if (this.completed != null && this.completed.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'completed' is not dividable by 2");
        }
        if (this.claimed != null && this.claimed.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'claimed' is not dividable by 2");
        }
        if (this.attachmentReceived != null && this.attachmentReceived.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'attachmentReceived' is not dividable by 2");
        }
    }
}

