/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.ClassificationQueryFilterParameter;
import pro.taskana.classification.rest.assembler.ClassificationRepresentationModelAssembler;
import pro.taskana.classification.rest.assembler.ClassificationSummaryRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.classification.rest.models.ClassificationSummaryPagedRepresentationModel;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationController {
    private final ClassificationService classificationService;
    private final ClassificationRepresentationModelAssembler modelAssembler;
    private final ClassificationSummaryRepresentationModelAssembler summaryModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Autowired
    ClassificationController(ClassificationService classificationService, ClassificationRepresentationModelAssembler modelAssembler, ClassificationSummaryRepresentationModelAssembler summaryModelAssembler) {
        this.classificationService = classificationService;
        this.modelAssembler = modelAssembler;
        this.summaryModelAssembler = summaryModelAssembler;
    }

    @GetMapping(path={"/api/v1/classifications"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationSummaryPagedRepresentationModel> getClassifications(HttpServletRequest request, ClassificationQueryFilterParameter filterParameter, ClassificationQuerySortParameter sortParameter, QueryPagingParameter<ClassificationSummary, ClassificationQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        ClassificationQueryFilterParameter classificationQueryFilterParameter = filterParameter;
        ClassificationQuerySortParameter classificationQuerySortParameter = sortParameter;
        QueryPagingParameter<ClassificationSummary, ClassificationQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, classificationQueryFilterParameter, classificationQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, ClassificationQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        Object classificationSummaries = pagingParameter.applyToQuery((BaseQuery)query);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)((ClassificationSummaryPagedRepresentationModel)((Object)this.summaryModelAssembler.toPagedModel(classificationSummaries, pagingParameter.getPageMetadata()))))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/classifications/{classificationId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> getClassification(@PathVariable String classificationId) throws ClassificationNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Classification classification = this.classificationService.getClassification(classificationId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/classifications"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> createClassification(@RequestBody ClassificationRepresentationModel repModel) throws NotAuthorizedException, ClassificationAlreadyExistException, DomainNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ClassificationRepresentationModel classificationRepresentationModel = repModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)((Object)classificationRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Classification classification = this.modelAssembler.toEntityModel(repModel);
        classification = this.classificationService.createClassification(classification);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.modelAssembler.toModel(classification)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> updateClassification(@PathVariable(value="classificationId") String classificationId, @RequestBody ClassificationRepresentationModel resource) throws NotAuthorizedException, ClassificationNotFoundException, ConcurrencyException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = classificationId;
        ClassificationRepresentationModel classificationRepresentationModel = resource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)((Object)classificationRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!classificationId.equals(resource.getClassificationId())) {
            throw new InvalidArgumentException(String.format("ClassificationId ('%s') of the URI is not identical with the classificationId ('%s') of the object in the payload.", classificationId, resource.getClassificationId()));
        }
        Classification classification = this.modelAssembler.toEntityModel(resource);
        classification = this.classificationService.updateClassification(classification);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.modelAssembler.toModel(classification))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/classifications/{classificationId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationRepresentationModel> deleteClassification(@PathVariable String classificationId) throws ClassificationNotFoundException, ClassificationInUseException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationService.deleteClassification(classificationId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        ClassificationController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationController.java", ClassificationController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassifications", "pro.taskana.classification.rest.ClassificationController", "javax.servlet.http.HttpServletRequest:pro.taskana.classification.rest.ClassificationQueryFilterParameter:pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassification", "pro.taskana.classification.rest.ClassificationController", "java.lang.String", "classificationId", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "org.springframework.http.ResponseEntity"), 107);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClassification", "pro.taskana.classification.rest.ClassificationController", "pro.taskana.classification.rest.models.ClassificationRepresentationModel", "repModel", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException:pro.taskana.common.api.exceptions.DomainNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 128);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClassification", "pro.taskana.classification.rest.ClassificationController", "java.lang.String:pro.taskana.classification.rest.models.ClassificationRepresentationModel", "classificationId:resource", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 153);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteClassification", "pro.taskana.classification.rest.ClassificationController", "java.lang.String", "classificationId", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.classification.api.exceptions.ClassificationInUseException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 184);
    }

    static final class ClassificationQuerySortBy
    extends Enum<ClassificationQuerySortBy>
    implements QuerySortBy<ClassificationQuery> {
        public static final /* enum */ ClassificationQuerySortBy DOMAIN;
        public static final /* enum */ ClassificationQuerySortBy KEY;
        public static final /* enum */ ClassificationQuerySortBy CATEGORY;
        public static final /* enum */ ClassificationQuerySortBy NAME;
        private final BiConsumer<ClassificationQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ ClassificationQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            ClassificationQuerySortBy.ajc$preClinit();
            DOMAIN = new ClassificationQuerySortBy(ClassificationQuery::orderByDomain);
            KEY = new ClassificationQuerySortBy(ClassificationQuery::orderByKey);
            CATEGORY = new ClassificationQuerySortBy(ClassificationQuery::orderByCategory);
            NAME = new ClassificationQuerySortBy(ClassificationQuery::orderByName);
            ENUM$VALUES = new ClassificationQuerySortBy[]{DOMAIN, KEY, CATEGORY, NAME};
        }

        private ClassificationQuerySortBy(BiConsumer<ClassificationQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(ClassificationQuery query, BaseQuery.SortDirection sortDirection) {
            ClassificationQuery classificationQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)classificationQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static ClassificationQuerySortBy[] values() {
            ClassificationQuerySortBy[] classificationQuerySortByArray;
            ClassificationQuerySortBy[] classificationQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ClassificationQuerySortBy[] classificationQuerySortByArray3 = ENUM$VALUES;
            int n = classificationQuerySortByArray3.length;
            ClassificationQuerySortBy[] classificationQuerySortByArray4 = new ClassificationQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, classificationQuerySortByArray4, 0, n);
            ClassificationQuerySortBy[] classificationQuerySortByArray5 = classificationQuerySortByArray2 = (classificationQuerySortByArray = classificationQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationQuerySortByArray2);
            return classificationQuerySortByArray;
        }

        public static ClassificationQuerySortBy valueOf(String arg0) {
            ClassificationQuerySortBy classificationQuerySortBy;
            ClassificationQuerySortBy classificationQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ClassificationQuerySortBy classificationQuerySortBy3 = classificationQuerySortBy2 = (classificationQuerySortBy = Enum.valueOf(ClassificationQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationQuerySortBy2);
            return classificationQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ClassificationController.java", ClassificationQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortBy", "pro.taskana.classification.api.ClassificationQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 204);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortBy", "", "", "", "[Lpro.taskana.classification.rest.ClassificationController$ClassificationQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortBy"), 1);
        }
    }

    public static class ClassificationQuerySortParameter
    extends QuerySortParameter<ClassificationQuery, ClassificationQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public ClassificationQuerySortParameter(List<ClassificationQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<ClassificationQuerySortBy> getSortBy() {
            List<ClassificationQuerySortBy> list;
            List<ClassificationQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<ClassificationQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            ClassificationQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ClassificationController.java", ClassificationQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.classification.rest.ClassificationController$ClassificationQuerySortParameter", "", "", "", "java.util.List"), 223);
        }
    }
}

