/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.NotFoundException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.models.TaskanaErrorData;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    @ExceptionHandler(value={InvalidArgumentException.class})
    protected ResponseEntity<Object> handleInvalidArgument(InvalidArgumentException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        InvalidArgumentException invalidArgumentException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)invalidArgumentException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    protected ResponseEntity<Object> handleNotAuthorized(NotAuthorizedException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        NotAuthorizedException notAuthorizedException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)notAuthorizedException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.FORBIDDEN));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={NotFoundException.class})
    protected ResponseEntity<Object> handleTaskNotFound(NotFoundException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        NotFoundException notFoundException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)notFoundException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.NOT_FOUND));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class})
    protected ResponseEntity<Object> handleTaskAlreadyExist(TaskAlreadyExistException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskAlreadyExistException taskAlreadyExistException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)taskAlreadyExistException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<Object> handleNotAuthorizedToQueryWorkbasket(NotAuthorizedToQueryWorkbasketException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        NotAuthorizedToQueryWorkbasketException notAuthorizedToQueryWorkbasketException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)notAuthorizedToQueryWorkbasketException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.FORBIDDEN));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={InvalidStateException.class})
    protected ResponseEntity<Object> handleInvalidState(InvalidStateException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        InvalidStateException invalidStateException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)invalidStateException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={InvalidOwnerException.class})
    protected ResponseEntity<Object> handleInvalidOwner(InvalidOwnerException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        InvalidOwnerException invalidOwnerException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)invalidOwnerException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={ClassificationAlreadyExistException.class})
    protected ResponseEntity<Object> handleClassificationAlreadyExist(ClassificationAlreadyExistException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        ClassificationAlreadyExistException classificationAlreadyExistException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)classificationAlreadyExistException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ResponseEntity<Object> handleDuplicateKey(DuplicateKeyException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        DuplicateKeyException duplicateKeyException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)duplicateKeyException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={ConcurrencyException.class})
    protected ResponseEntity<Object> handleConcurrencyException(ConcurrencyException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        ConcurrencyException concurrencyException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)concurrencyException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={WorkbasketInUseException.class})
    protected ResponseEntity<Object> handleWorkbasketInUse(WorkbasketInUseException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        WorkbasketInUseException workbasketInUseException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)workbasketInUseException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.LOCKED));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={WorkbasketAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAlreadyExist(WorkbasketAlreadyExistException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        WorkbasketAlreadyExistException workbasketAlreadyExistException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)workbasketAlreadyExistException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={WorkbasketAccessItemAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAccessItemAlreadyExist(WorkbasketAccessItemAlreadyExistException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        WorkbasketAccessItemAlreadyExistException workbasketAccessItemAlreadyExistException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)workbasketAccessItemAlreadyExistException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={InvalidWorkbasketException.class})
    protected ResponseEntity<Object> handleInvalidWorkbasket(InvalidWorkbasketException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        InvalidWorkbasketException invalidWorkbasketException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)invalidWorkbasketException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={DomainNotFoundException.class})
    protected ResponseEntity<Object> handleDomainNotFound(DomainNotFoundException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        DomainNotFoundException domainNotFoundException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)domainNotFoundException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        MaxUploadSizeExceededException maxUploadSizeExceededException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this), (Object)maxUploadSizeExceededException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, req, HttpStatus.PAYLOAD_TOO_LARGE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        BindException bindException = ex;
        HttpHeaders httpHeaders = headers;
        HttpStatus httpStatus = status;
        WebRequest webRequest = request;
        Object[] objectArray = new Object[]{bindException, httpHeaders, httpStatus, webRequest};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse((Throwable)ex, request, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        Exception exception = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)((Object)this), (Object)((Object)this), (Object)exception, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex, req, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    private ResponseEntity<Object> buildResponse(Throwable ex, WebRequest req, HttpStatus status) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        Throwable throwable = ex;
        WebRequest webRequest = req;
        HttpStatus httpStatus = status;
        Object[] objectArray = new Object[]{throwable, webRequest, httpStatus};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex, req, status, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    private ResponseEntity<Object> buildResponse(Throwable ex, WebRequest req, HttpStatus status, boolean logExceptionOnError) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        Throwable throwable = ex;
        WebRequest webRequest = req;
        HttpStatus httpStatus = status;
        boolean bl = logExceptionOnError;
        Object[] objectArray = new Object[]{throwable, webRequest, httpStatus, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaErrorData errorData = new TaskanaErrorData(status, ex, req);
        if (logExceptionOnError) {
            this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), ex);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Error occurred during processing of rest request: %s", errorData.toString()), ex);
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)status).body((Object)errorData));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskanaRestExceptionHandler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaRestExceptionHandler.java", TaskanaRestExceptionHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleInvalidArgument", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.InvalidArgumentException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleNotAuthorized", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.NotAuthorizedException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 44);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleWorkbasketInUse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.workbasket.api.exceptions.WorkbasketInUseException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 93);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleWorkbasketAlreadyExist", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 99);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleWorkbasketAccessItemAlreadyExist", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 105);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleInvalidWorkbasket", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 111);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleDomainNotFound", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.DomainNotFoundException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 117);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleMaxUploadSizeExceededException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.web.multipart.MaxUploadSizeExceededException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 123);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBindException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.BindException:org.springframework.http.HttpHeaders:org.springframework.http.HttpStatus:org.springframework.web.context.request.WebRequest", "ex:headers:status:request", "", "org.springframework.http.ResponseEntity"), 129);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleGeneralException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Exception:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 135);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildResponse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Throwable:org.springframework.web.context.request.WebRequest:org.springframework.http.HttpStatus", "ex:req:status", "", "org.springframework.http.ResponseEntity"), 139);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildResponse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Throwable:org.springframework.web.context.request.WebRequest:org.springframework.http.HttpStatus:boolean", "ex:req:status:logExceptionOnError", "", "org.springframework.http.ResponseEntity"), 143);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskNotFound", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.NotFoundException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 49);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskAlreadyExist", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.task.api.exceptions.TaskAlreadyExistException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 54);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleNotAuthorizedToQueryWorkbasket", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 60);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleInvalidState", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.task.api.exceptions.InvalidStateException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 66);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleInvalidOwner", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.task.api.exceptions.InvalidOwnerException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 71);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleClassificationAlreadyExist", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 76);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleDuplicateKey", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.dao.DuplicateKeyException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 82);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleConcurrencyException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.ConcurrencyException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 87);
    }
}

