/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskState;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class MonitorController {
    private final MonitorService monitorService;
    private final ReportRepresentationModelAssembler reportRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Autowired
    MonitorController(MonitorService monitorService, ReportRepresentationModelAssembler reportRepresentationModelAssembler) {
        this.monitorService = monitorService;
        this.reportRepresentationModelAssembler = reportRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-status-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTaskStatusReport(@RequestParam(required=false) List<String> domains, @RequestParam(required=false) List<TaskState> states, @RequestParam(name="workbasket-ids", required=false) List<String> workbasketIds, @RequestParam(name="priority-minimum", required=false) Integer priorityMinimum) throws NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        List<String> list = domains;
        List<TaskState> list2 = states;
        List<String> list3 = workbasketIds;
        Integer n = priorityMinimum;
        Object[] objectArray = new Object[]{list, list2, list3, n};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.reportRepresentationModelAssembler.toModel(this.monitorService.createTaskStatusReportBuilder().stateIn(states).domainIn(domains).workbasketIdsIn(workbasketIds).priorityMinimum(priorityMinimum).buildReport(), domains, states, workbasketIds, priorityMinimum))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-workbasket-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getWorkbasketReport(@RequestParam List<TaskState> states, @RequestParam(required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        List<TaskState> list = states;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((WorkbasketReport.Builder)((WorkbasketReport.Builder)this.monitorService.createWorkbasketReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).stateIn(states)).buildReport(taskTimestamp), states, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-workbasket-planned-date-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTasksWorkbasketPlannedDateReport(@RequestParam(value="daysInPast") int daysInPast, @RequestParam(value="states") List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        int n = daysInPast;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((WorkbasketReport.Builder)((WorkbasketReport.Builder)this.monitorService.createWorkbasketReportBuilder().stateIn(states)).withColumnHeaders(this.getDateTimeInterval(daysInPast))).buildReport(TaskTimestamp.PLANNED), daysInPast, states);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/tasks-classification-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getClassificationReport(@RequestParam(required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(((ClassificationReport.Builder)this.monitorService.createClassificationReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).buildReport(taskTimestamp), taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/timestamp-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> getTimestampReport() throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List columnHeaders = IntStream.range(-14, 0).mapToObj(TimeIntervalColumnHeader.Date::new).collect(Collectors.toList());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.reportRepresentationModelAssembler.toModel(((TimestampReport.Builder)this.monitorService.createTimestampReportBuilder().withColumnHeaders(columnHeaders)).buildReport())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private List<TimeIntervalColumnHeader> getRangeTimeInterval() {
        List<TimeIntervalColumnHeader> list;
        List<TimeIntervalColumnHeader> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TimeIntervalColumnHeader> list3 = list2 = (list = Stream.concat(Stream.concat(Stream.of(new TimeIntervalColumnHeader.Range(Integer.MIN_VALUE, -10), new TimeIntervalColumnHeader.Range(-10, -5)), Stream.of(-4, -3, -2, -1, 0, 1, 2, 3, 4).map(TimeIntervalColumnHeader.Range::new)), Stream.of(new TimeIntervalColumnHeader.Range(5, 10), new TimeIntervalColumnHeader.Range(10, Integer.MAX_VALUE))).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private List<TimeIntervalColumnHeader> getDateTimeInterval(int daysInPast) {
        ArrayList<TimeIntervalColumnHeader> arrayList;
        ArrayList<TimeIntervalColumnHeader> arrayList2;
        int n = daysInPast;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<TimeIntervalColumnHeader> columnHeaders = new ArrayList<TimeIntervalColumnHeader>();
        int i = 0;
        while (i <= daysInPast) {
            columnHeaders.add((TimeIntervalColumnHeader)new TimeIntervalColumnHeader.Date(i - daysInPast));
            ++i;
        }
        ArrayList<TimeIntervalColumnHeader> arrayList3 = arrayList2 = (arrayList = columnHeaders);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    static {
        MonitorController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MonitorController.java", MonitorController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskStatusReport", "pro.taskana.monitor.rest.MonitorController", "java.util.List:java.util.List:java.util.List:java.lang.Integer", "domains:states:workbasketIds:priorityMinimum", "pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketReport", "pro.taskana.monitor.rest.MonitorController", "java.util.List:pro.taskana.monitor.api.TaskTimestamp", "states:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 99);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTasksWorkbasketPlannedDateReport", "pro.taskana.monitor.rest.MonitorController", "int:java.util.List", "daysInPast:states", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 123);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.api.TaskTimestamp", "taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 155);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestampReport", "pro.taskana.monitor.rest.MonitorController", "", "", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 187);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRangeTimeInterval", "pro.taskana.monitor.rest.MonitorController", "", "", "", "java.util.List"), 202);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDateTimeInterval", "pro.taskana.monitor.rest.MonitorController", "int", "daysInPast", "", "java.util.List"), 215);
    }
}

