/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest.assembler;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.Report;
import pro.taskana.monitor.api.reports.TaskStatusReport;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.ColumnHeader;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.FoldableRow;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.api.reports.row.SingleRow;
import pro.taskana.monitor.rest.MonitorController;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskState;

@Component
public class ReportRepresentationModelAssembler {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    @NonNull
    public ReportRepresentationModel toModel(@NonNull TaskStatusReport report, @NonNull List<String> domains, @NonNull List<TaskState> states, @NonNull List<String> workbasketIds, @NonNull Integer priorityMinimum) throws NotAuthorizedException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        TaskStatusReport taskStatusReport = report;
        List<String> list = domains;
        List<TaskState> list2 = states;
        List<String> list3 = workbasketIds;
        Integer n = priorityMinimum;
        Object[] objectArray = new Object[]{taskStatusReport, list, list2, list3, n};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTaskStatusReport(domains, states, workbasketIds, priorityMinimum)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull ClassificationReport report, TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        ClassificationReport classificationReport = report;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)classificationReport, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getClassificationReport(taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketReport report, @NonNull List<TaskState> states, @NonNull TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        WorkbasketReport workbasketReport = report;
        List<TaskState> list = states;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{workbasketReport, list, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getWorkbasketReport(states, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketReport report, int daysInPast, @NonNull List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        WorkbasketReport workbasketReport = report;
        int n = daysInPast;
        List<TaskState> list = states;
        Object[] objectArray = new Object[]{workbasketReport, Conversions.intObject((int)n), list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksWorkbasketPlannedDateReport(daysInPast, states)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull TimestampReport report) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        TimestampReport timestampReport = report;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)timestampReport);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTimestampReport()).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    public <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report, Instant time) {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        Report report2 = report;
        Instant instant = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, report2, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] header = (String[])report.getColumnHeaders().stream().map(ColumnHeader::getDisplayName).toArray(String[]::new);
        ReportRepresentationModel.MetaInformation meta = new ReportRepresentationModel.MetaInformation(report.getClass().getSimpleName(), time, header, report.getRowDesc(), report.getSumRow().getKey());
        List<ReportRepresentationModel.RowRepresentationModel> rows = report.getRows().values().stream().sorted(Comparator.comparing(e -> e.getKey().toLowerCase())).map(i -> this.transformRow((Row)i, new String[report.getRowDesc().length], 0)).flatMap(Collection::stream).collect(Collectors.toList());
        List<ReportRepresentationModel.RowRepresentationModel> sumRow = this.transformRow(report.getSumRow(), new String[report.getRowDesc().length], 0);
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = new ReportRepresentationModel(meta, rows, sumRow));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report) {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        Report<I, H> report2 = report;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, report2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = this.toReportResource(report, Instant.now()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowRepresentationModel> transformRow(Row<I> row, String[] desc, int depth) {
        List<ReportRepresentationModel.RowRepresentationModel> list;
        List<ReportRepresentationModel.RowRepresentationModel> list2;
        Row<I> row2 = row;
        String[] stringArray = desc;
        int n = depth;
        Object[] objectArray = new Object[]{row2, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ReportRepresentationModel.RowRepresentationModel> list3 = list2 = row.getClass() == SingleRow.class ? (list = Collections.singletonList(this.transformSingleRow((SingleRow)row, desc, depth))) : (list = this.transformFoldableRow((FoldableRow)row, desc, depth));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private <I extends QueryItem> ReportRepresentationModel.RowRepresentationModel transformSingleRow(SingleRow<I> row, String[] previousRowDesc, int depth) {
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel;
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel2;
        SingleRow<I> singleRow = row;
        String[] stringArray = previousRowDesc;
        int n = depth;
        Object[] objectArray = new Object[]{singleRow, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] rowDesc = new String[previousRowDesc.length];
        System.arraycopy(previousRowDesc, 0, rowDesc, 0, depth);
        rowDesc[depth] = row.getDisplayName();
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel3 = rowRepresentationModel2 = (rowRepresentationModel = new ReportRepresentationModel.RowRepresentationModel(row.getCells(), row.getTotalValue(), depth, rowDesc, depth == 0));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)rowRepresentationModel2);
        return rowRepresentationModel;
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowRepresentationModel> transformFoldableRow(FoldableRow<I> row, String[] previousRowDesc, int depth) {
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList;
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList2;
        FoldableRow foldableRow = row;
        String[] stringArray = previousRowDesc;
        int n = depth;
        Object[] objectArray = new Object[]{foldableRow, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel.RowRepresentationModel baseRow = this.transformSingleRow((SingleRow<I>)row, previousRowDesc, depth);
        LinkedList<ReportRepresentationModel.RowRepresentationModel> rowList = new LinkedList<ReportRepresentationModel.RowRepresentationModel>();
        rowList.add(baseRow);
        row.getFoldableRowKeySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(s -> this.transformRow(row.getFoldableRow(s), baseRow.getDesc(), depth + 1)).flatMap(Collection::stream).forEachOrdered(rowList::add);
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList3 = linkedList2 = (linkedList = rowList);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, linkedList2);
        return linkedList;
    }

    static {
        ReportRepresentationModelAssembler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ReportRepresentationModelAssembler.java", ReportRepresentationModelAssembler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.TaskStatusReport:java.util.List:java.util.List:java.util.List:java.lang.Integer", "report:domains:states:workbasketIds:priorityMinimum", "pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.ClassificationReport:pro.taskana.monitor.api.TaskTimestamp", "report:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 56);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.WorkbasketReport:java.util.List:pro.taskana.monitor.api.TaskTimestamp", "report:states:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.WorkbasketReport:int:java.util.List", "report:daysInPast:states", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 80);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.TimestampReport", "report", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 93);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toReportResource", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.Report:java.time.Instant", "report:time", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 101);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "toReportResource", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.Report", "report", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 127);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.Row:[Ljava.lang.String;:int", "row:desc:depth", "", "java.util.List"), 131);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformSingleRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.SingleRow:[Ljava.lang.String;:int", "row:previousRowDesc:depth", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel$RowRepresentationModel"), 143);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformFoldableRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.FoldableRow:[Ljava.lang.String;:int", "row:previousRowDesc:depth", "", "java.util.List"), 152);
    }
}

