/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.exceptions.MalformedServiceLevelException;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.MismatchedRoleException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.MapCreator;
import pro.taskana.common.rest.models.ExceptionRepresentationModel;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidCallbackStateException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidTaskStateException;
import pro.taskana.task.api.exceptions.MismatchedTaskCommentCreatorException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketMarkedForDeletionException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    public static final String ERROR_KEY_QUERY_MALFORMED = "QUERY_PARAMETER_MALFORMED";
    public static final String ERROR_KEY_PAYLOAD = "PAYLOAD_TOO_LARGE";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    @ExceptionHandler(value={MismatchedRoleException.class, MismatchedWorkbasketPermissionException.class, MismatchedTaskCommentCreatorException.class, NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<Object> handleForbiddenExceptions(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.FORBIDDEN));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={ClassificationNotFoundException.class, TaskCommentNotFoundException.class, TaskNotFoundException.class, TaskanaHistoryEventNotFoundException.class, WorkbasketNotFoundException.class})
    protected ResponseEntity<Object> handleNotFound(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.NOT_FOUND));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class, ClassificationAlreadyExistException.class, ConcurrencyException.class, WorkbasketAlreadyExistException.class, WorkbasketAccessItemAlreadyExistException.class, AttachmentPersistenceException.class, WorkbasketMarkedForDeletionException.class})
    protected ResponseEntity<Object> handleConflictExceptions(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.CONFLICT));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={WorkbasketInUseException.class, ClassificationInUseException.class})
    protected ResponseEntity<Object> handleWorkbasketInUse(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.LOCKED));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        MaxUploadSizeExceededException maxUploadSizeExceededException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)maxUploadSizeExceededException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)ERROR_KEY_PAYLOAD), (Throwable)ex, req, HttpStatus.PAYLOAD_TOO_LARGE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={BeanInstantiationException.class})
    protected ResponseEntity<Object> handleBeanInstantiationException(BeanInstantiationException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        ResponseEntity<Object> responseEntity3;
        BeanInstantiationException beanInstantiationException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)beanInstantiationException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (ex.getCause() instanceof InvalidArgumentException) {
            InvalidArgumentException cause = (InvalidArgumentException)ex.getCause();
            responseEntity2 = responseEntity3 = this.buildResponse(cause.getErrorCode(), (Throwable)ex, req, HttpStatus.BAD_REQUEST);
        } else {
            responseEntity2 = responseEntity3 = this.buildResponse(null, (Throwable)ex, req, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        ResponseEntity<Object> responseEntity4 = responseEntity = responseEntity2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity);
        return responseEntity3;
    }

    @ExceptionHandler(value={InvalidTaskStateException.class, InvalidCallbackStateException.class, InvalidOwnerException.class, InvalidArgumentException.class, DomainNotFoundException.class, MalformedServiceLevelException.class, WrongCustomHolidayFormatException.class})
    protected ResponseEntity<Object> handleBadRequestExceptions(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgumentException(IllegalArgumentException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        IllegalArgumentException illegalArgumentException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)illegalArgumentException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)"INVALID_ARGUMENT"), ex, req, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaRuntimeException.class})
    protected ResponseEntity<Object> handleUnknownTaskanaRuntimeExceptions(TaskanaRuntimeException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaRuntimeException taskanaRuntimeException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)taskanaRuntimeException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.INTERNAL_SERVER_ERROR));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaException.class})
    protected ResponseEntity<Object> handleUnknownTaskanaExceptions(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, HttpStatus.INTERNAL_SERVER_ERROR));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        Exception exception = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)exception, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)"UNKNOWN_ERROR"), ex, req, HttpStatus.INTERNAL_SERVER_ERROR));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @NonNull
    protected ResponseEntity<Object> handleBindException(BindException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest request) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        BindException bindException = ex;
        HttpHeaders httpHeaders = headers;
        HttpStatus httpStatus = status;
        WebRequest webRequest = request;
        Object[] objectArray = new Object[]{bindException, httpHeaders, httpStatus, webRequest};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        MalformedQueryParameter[] wrongQueryParameters = (MalformedQueryParameter[])ex.getBindingResult().getFieldErrors().stream().map(this::extractMalformedQueryParameters).flatMap(Collection::stream).toArray(MalformedQueryParameter[]::new);
        ErrorCode errorCode = wrongQueryParameters.length != 0 ? ErrorCode.of((String)ERROR_KEY_QUERY_MALFORMED, (Map)MapCreator.of((Object)"malformedQueryParameters", (Object)wrongQueryParameters)) : null;
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(errorCode, (Throwable)ex, request, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    private ResponseEntity<Object> buildResponse(ErrorCode errorCode, Throwable ex, WebRequest req, HttpStatus status) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ErrorCode errorCode2 = errorCode;
        Throwable throwable = ex;
        WebRequest webRequest = req;
        HttpStatus httpStatus = status;
        Object[] objectArray = new Object[]{errorCode2, throwable, webRequest, httpStatus};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ExceptionRepresentationModel errorData = new ExceptionRepresentationModel(errorCode, status, ex, req);
        this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData), ex);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)status).body((Object)errorData));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private List<MalformedQueryParameter> extractMalformedQueryParameters(FieldError fieldError) {
        List<MalformedQueryParameter> list;
        List<MalformedQueryParameter> list2;
        List<MalformedQueryParameter> list3;
        ConversionFailedException conversionFailedException;
        Class targetType;
        TypeMismatchException typeMismatchException;
        FieldError fieldError2 = fieldError;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)fieldError2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (fieldError.contains(TypeMismatchException.class) && (typeMismatchException = (TypeMismatchException)fieldError.unwrap(TypeMismatchException.class)).getCause() instanceof ConversionFailedException && (targetType = (conversionFailedException = (ConversionFailedException)typeMismatchException.getCause()).getTargetType().getType()).isEnum()) {
            String queryParameter = fieldError.getField();
            List enumConstants = Arrays.stream(targetType.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            HashSet enumConstantSet = new HashSet(enumConstants);
            list2 = list3 = this.getRejectedValues(typeMismatchException).filter(value -> !enumConstantSet.contains(value)).map(value -> new MalformedQueryParameter(queryParameter, (String)value, enumConstants)).collect(Collectors.toList());
        } else {
            list2 = list3 = Collections.emptyList();
        }
        List<MalformedQueryParameter> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list3;
    }

    private Stream<String> getRejectedValues(TypeMismatchException ex) {
        Stream<String> stream;
        Stream<String> stream2;
        TypeMismatchException typeMismatchException = ex;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)typeMismatchException);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Object value = ex.getValue();
        Stream<String> stream3 = stream2 = value != null && value.getClass().isArray() ? (stream = Arrays.stream((Object[])value).map(Objects::toString)) : (value != null && value.getClass().isAssignableFrom(Collection.class) ? (stream = ((Collection)value).stream().map(Objects::toString)) : (stream = Stream.of(value).map(Objects::toString)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    static {
        TaskanaRestExceptionHandler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaRestExceptionHandler.java", TaskanaRestExceptionHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleForbiddenExceptions", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleNotFound", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 86);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleGeneralException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Exception:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 157);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBindException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.BindException:org.springframework.http.HttpHeaders:org.springframework.http.HttpStatus:org.springframework.web.context.request.WebRequest", "ex:headers:status:request", "", "org.springframework.http.ResponseEntity"), 163);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildResponse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.ErrorCode:java.lang.Throwable:org.springframework.web.context.request.WebRequest:org.springframework.http.HttpStatus", "errorCode:ex:req:status", "", "org.springframework.http.ResponseEntity"), 187);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractMalformedQueryParameters", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.FieldError", "fieldError", "", "java.util.List"), 196);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRejectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.TypeMismatchException", "ex", "", "java.util.stream.Stream"), 224);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleConflictExceptions", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleWorkbasketInUse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 104);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleMaxUploadSizeExceededException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.web.multipart.MaxUploadSizeExceededException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 109);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBeanInstantiationException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.BeanInstantiationException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 115);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBadRequestExceptions", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 133);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleIllegalArgumentException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.IllegalArgumentException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 138);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleUnknownTaskanaRuntimeExceptions", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaRuntimeException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 145);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleUnknownTaskanaExceptions", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 151);
    }

    public static class MalformedQueryParameter
    implements Serializable {
        private final String queryParameter;
        private final String actualValue;
        private final Collection<String> expectedValues;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        MalformedQueryParameter(String queryParameter, String actualValue, Collection<String> expectedValues) {
            this.queryParameter = queryParameter;
            this.actualValue = actualValue;
            this.expectedValues = expectedValues;
        }

        public String getActualValue() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.actualValue);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        public Collection<String> getExpectedValues() {
            Collection<String> collection;
            Collection<String> collection2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Collection<String> collection3 = collection2 = (collection = this.expectedValues);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, collection2);
            return collection;
        }

        public String getQueryParameter() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.queryParameter);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        static {
            MalformedQueryParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaRestExceptionHandler.java", MalformedQueryParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActualValue", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 248);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.util.Collection"), 253);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryParameter", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 258);
        }
    }
}

