/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.rest.assembler.TaskCommentRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskCommentCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private final TaskService taskService;
    private final TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Autowired
    TaskCommentController(TaskService taskService, TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskCommentRepresentationModelAssembler = taskCommentRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> getTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentRepresentationModel taskCommentRepresentationModel = this.taskCommentRepresentationModelAssembler.toModel(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentRepresentationModel)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentCollectionRepresentationModel> getTaskComments(@PathVariable String taskId, @RequestParam(name="sort-by", required=false) List<TaskCommentsSortBy> sortBy, @RequestParam(required=false) List<BaseQuery.SortDirection> order) throws NotAuthorizedException, TaskNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        List<TaskCommentsSortBy> list = sortBy;
        List<BaseQuery.SortDirection> list2 = order;
        Object[] objectArray = new Object[]{string, list, list2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Comparator<TaskComment>> comparator = this.getTaskCommentComparator(sortBy, order);
        List taskComments = this.taskService.getTaskComments(taskId);
        comparator.ifPresent(taskComments::sort);
        TaskCommentCollectionRepresentationModel taskCommentListResource = (TaskCommentCollectionRepresentationModel)((Object)this.taskCommentRepresentationModelAssembler.toTaskanaCollectionModel(taskComments));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentListResource)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> deleteTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> updateTaskComment(@PathVariable String taskCommentId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!taskCommentId.equals(taskCommentRepresentationModel.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        taskComment = this.taskService.updateTaskComment(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskCommentRepresentationModelAssembler.toModel(taskComment))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> createTaskComment(@PathVariable String taskId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, InvalidArgumentException, TaskNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskCommentRepresentationModel.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskCommentRepresentationModelAssembler.toModel(createdTaskComment)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private Optional<Comparator<TaskComment>> getTaskCommentComparator(List<TaskCommentsSortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        Optional<Object> optional;
        Optional<Object> optional2;
        List<TaskCommentsSortBy> list = sortBy;
        List<BaseQuery.SortDirection> list2 = order;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QuerySortParameter.verifyNotOnlyOrderByExists(sortBy, order);
        QuerySortParameter.verifyAmountOfSortByAndOrderByMatches(sortBy, order);
        Comparator<TaskComment> comparator = null;
        if (sortBy != null) {
            int i = 0;
            while (i < sortBy.size()) {
                BaseQuery.SortDirection sortDirection = order == null ? BaseQuery.SortDirection.ASCENDING : order.get(i);
                Comparator<TaskComment> temp = sortBy.get(i).getComparator();
                if (sortDirection == BaseQuery.SortDirection.DESCENDING) {
                    temp = temp.reversed();
                }
                comparator = comparator == null ? temp : comparator.thenComparing(temp);
                ++i;
            }
        }
        Optional<Object> optional3 = optional2 = (optional = Optional.ofNullable(comparator));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    static {
        TaskCommentController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentController.java", TaskCommentController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:java.util.List:java.util.List", "taskId:sortBy:order", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 96);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 125);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskCommentId:taskCommentRepresentationModel", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.ConcurrencyException", "org.springframework.http.ResponseEntity"), 150);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskId:taskCommentRepresentationModel", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.TaskNotFoundException", "org.springframework.http.ResponseEntity"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTaskCommentComparator", "pro.taskana.task.rest.TaskCommentController", "java.util.List:java.util.List", "sortBy:order", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.Optional"), 198);
    }

    static final class TaskCommentsSortBy
    extends Enum<TaskCommentsSortBy> {
        public static final /* enum */ TaskCommentsSortBy CREATED;
        public static final /* enum */ TaskCommentsSortBy MODIFIED;
        private final Comparator<TaskComment> comparator;
        private static final /* synthetic */ TaskCommentsSortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            TaskCommentsSortBy.ajc$preClinit();
            CREATED = new TaskCommentsSortBy(Comparator.comparing(TaskComment::getCreated));
            MODIFIED = new TaskCommentsSortBy(Comparator.comparing(TaskComment::getModified));
            ENUM$VALUES = new TaskCommentsSortBy[]{CREATED, MODIFIED};
        }

        private TaskCommentsSortBy(Comparator<TaskComment> comparing) {
            this.comparator = comparing;
        }

        public Comparator<TaskComment> getComparator() {
            Comparator<TaskComment> comparator;
            Comparator<TaskComment> comparator2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Comparator<TaskComment> comparator3 = comparator2 = (comparator = this.comparator);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, comparator2);
            return comparator;
        }

        public static TaskCommentsSortBy[] values() {
            TaskCommentsSortBy[] taskCommentsSortByArray;
            TaskCommentsSortBy[] taskCommentsSortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentsSortBy[] taskCommentsSortByArray3 = ENUM$VALUES;
            int n = taskCommentsSortByArray3.length;
            TaskCommentsSortBy[] taskCommentsSortByArray4 = new TaskCommentsSortBy[n];
            System.arraycopy(ENUM$VALUES, 0, taskCommentsSortByArray4, 0, n);
            TaskCommentsSortBy[] taskCommentsSortByArray5 = taskCommentsSortByArray2 = (taskCommentsSortByArray = taskCommentsSortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentsSortByArray2);
            return taskCommentsSortByArray;
        }

        public static TaskCommentsSortBy valueOf(String arg0) {
            TaskCommentsSortBy taskCommentsSortBy;
            TaskCommentsSortBy taskCommentsSortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentsSortBy taskCommentsSortBy3 = taskCommentsSortBy2 = (taskCommentsSortBy = Enum.valueOf(TaskCommentsSortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentsSortBy2);
            return taskCommentsSortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskCommentController.java", TaskCommentsSortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getComparator", "pro.taskana.task.rest.TaskCommentController$TaskCommentsSortBy", "", "", "", "java.util.Comparator"), 226);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.task.rest.TaskCommentController$TaskCommentsSortBy", "", "", "", "[Lpro.taskana.task.rest.TaskCommentController$TaskCommentsSortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.task.rest.TaskCommentController$TaskCommentsSortBy", "java.lang.String", "arg0", "", "pro.taskana.task.rest.TaskCommentController$TaskCommentsSortBy"), 1);
        }
    }
}

