/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.MapCreator;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.rest.models.ExceptionRepresentationModel;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    public static final String ERROR_KEY_QUERY_MALFORMED = "QUERY_PARAMETER_MALFORMED";
    public static final String ERROR_KEY_PAYLOAD = "PAYLOAD_TOO_LARGE";
    public static final String ERROR_KEY_UNKNOWN_ERROR = "UNKNOWN_ERROR";
    private static final Map<String, HttpStatus> HTTP_STATUS_BY_ERRORCODE_KEY;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        TaskanaRestExceptionHandler.ajc$preClinit();
        HTTP_STATUS_BY_ERRORCODE_KEY = Stream.of(Pair.of((Object)"CLASSIFICATION_SERVICE_LEVEL_MALFORMED", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"CUSTOM_HOLIDAY_WRONG_FORMAT", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"DOMAIN_NOT_FOUND", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"INVALID_ARGUMENT", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)ERROR_KEY_QUERY_MALFORMED, (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"TASK_INVALID_CALLBACK_STATE", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"TASK_INVALID_OWNER", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"TASK_INVALID_STATE", (Object)HttpStatus.BAD_REQUEST), Pair.of((Object)"ROLE_MISMATCHED", (Object)HttpStatus.FORBIDDEN), Pair.of((Object)"TASK_COMMENT_CREATOR_MISMATCHED", (Object)HttpStatus.FORBIDDEN), Pair.of((Object)"WORKBASKET_WITH_ID_MISMATCHED_PERMISSION", (Object)HttpStatus.FORBIDDEN), Pair.of((Object)"WORKBASKET_WITH_KEY_MISMATCHED_PERMISSION", (Object)HttpStatus.FORBIDDEN), Pair.of((Object)"CLASSIFICATION_WITH_ID_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"CLASSIFICATION_WITH_KEY_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"TASK_COMMENT_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"TASK_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"USER_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"WORKBASKET_WITH_ID_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"WORKBASKET_WITH_KEY_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"HISTORY_EVENT_NOT_FOUND", (Object)HttpStatus.NOT_FOUND), Pair.of((Object)"ATTACHMENT_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"CLASSIFICATION_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"ENTITY_NOT_UP_TO_DATE", (Object)HttpStatus.CONFLICT), Pair.of((Object)"TASK_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"USER_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"WORKBASKET_ACCESS_ITEM_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"WORKBASKET_ALREADY_EXISTS", (Object)HttpStatus.CONFLICT), Pair.of((Object)"WORKBASKET_MARKED_FOR_DELETION", (Object)HttpStatus.CONFLICT), Pair.of((Object)ERROR_KEY_PAYLOAD, (Object)HttpStatus.PAYLOAD_TOO_LARGE), Pair.of((Object)"CLASSIFICATION_IN_USE", (Object)HttpStatus.LOCKED), Pair.of((Object)"WORKBASKET_IN_USE", (Object)HttpStatus.LOCKED), Pair.of((Object)"CONNECTION_AUTOCOMMIT_FAILED", (Object)HttpStatus.INTERNAL_SERVER_ERROR), Pair.of((Object)"CONNECTION_NOT_SET", (Object)HttpStatus.INTERNAL_SERVER_ERROR), Pair.of((Object)"CRITICAL_SYSTEM_ERROR", (Object)HttpStatus.INTERNAL_SERVER_ERROR), Pair.of((Object)"DATABASE_UNSUPPORTED", (Object)HttpStatus.INTERNAL_SERVER_ERROR), Pair.of((Object)ERROR_KEY_UNKNOWN_ERROR, (Object)HttpStatus.INTERNAL_SERVER_ERROR)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        MaxUploadSizeExceededException maxUploadSizeExceededException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)maxUploadSizeExceededException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERRORCODE_KEY.getOrDefault(ERROR_KEY_PAYLOAD, HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)ERROR_KEY_PAYLOAD), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={BeanInstantiationException.class})
    protected ResponseEntity<Object> handleBeanInstantiationException(BeanInstantiationException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        ResponseEntity<Object> responseEntity3;
        BeanInstantiationException beanInstantiationException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)beanInstantiationException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (ex.getCause() instanceof InvalidArgumentException) {
            InvalidArgumentException cause = (InvalidArgumentException)ex.getCause();
            responseEntity2 = responseEntity3 = this.handleTaskanaException((TaskanaException)cause, req);
        } else {
            responseEntity2 = responseEntity3 = this.buildResponse(null, (Throwable)ex, req, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        ResponseEntity<Object> responseEntity4 = responseEntity = responseEntity2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity);
        return responseEntity3;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgumentException(IllegalArgumentException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        IllegalArgumentException illegalArgumentException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)illegalArgumentException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERRORCODE_KEY.getOrDefault("INVALID_ARGUMENT", HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)"INVALID_ARGUMENT"), ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaRuntimeException.class})
    protected ResponseEntity<Object> handleTaskanaRuntimeException(TaskanaRuntimeException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaRuntimeException taskanaRuntimeException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)taskanaRuntimeException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERRORCODE_KEY.getOrDefault(ex.getErrorCode().getKey(), HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaException.class})
    protected ResponseEntity<Object> handleTaskanaException(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERRORCODE_KEY.getOrDefault(ex.getErrorCode().getKey(), HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        Exception exception = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)exception, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)ERROR_KEY_UNKNOWN_ERROR), ex, req, HttpStatus.INTERNAL_SERVER_ERROR));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @NonNull
    protected ResponseEntity<Object> handleBindException(BindException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest request) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        BindException bindException = ex;
        HttpHeaders httpHeaders = headers;
        HttpStatus httpStatus = status;
        WebRequest webRequest = request;
        Object[] objectArray = new Object[]{bindException, httpHeaders, httpStatus, webRequest};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        MalformedQueryParameter[] wrongQueryParameters = (MalformedQueryParameter[])ex.getBindingResult().getFieldErrors().stream().map(this::extractMalformedQueryParameters).flatMap(Collection::stream).toArray(MalformedQueryParameter[]::new);
        ErrorCode errorCode = wrongQueryParameters.length != 0 ? ErrorCode.of((String)ERROR_KEY_QUERY_MALFORMED, (Map)MapCreator.of((Object)"malformedQueryParameters", (Object)wrongQueryParameters)) : null;
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(errorCode, (Throwable)ex, request, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    private ResponseEntity<Object> buildResponse(ErrorCode errorCode, Throwable ex, WebRequest req, HttpStatus status) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ErrorCode errorCode2 = errorCode;
        Throwable throwable = ex;
        WebRequest webRequest = req;
        HttpStatus httpStatus = status;
        Object[] objectArray = new Object[]{errorCode2, throwable, webRequest, httpStatus};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ExceptionRepresentationModel errorData = new ExceptionRepresentationModel(errorCode, status, ex, req);
        this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData), ex);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)status).body((Object)errorData));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private List<MalformedQueryParameter> extractMalformedQueryParameters(FieldError fieldError) {
        List<MalformedQueryParameter> list;
        List<MalformedQueryParameter> list2;
        List<MalformedQueryParameter> list3;
        ConversionFailedException conversionFailedException;
        Class targetType;
        TypeMismatchException typeMismatchException;
        FieldError fieldError2 = fieldError;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)fieldError2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (fieldError.contains(TypeMismatchException.class) && (typeMismatchException = (TypeMismatchException)fieldError.unwrap(TypeMismatchException.class)).getCause() instanceof ConversionFailedException && (targetType = (conversionFailedException = (ConversionFailedException)typeMismatchException.getCause()).getTargetType().getType()).isEnum()) {
            String queryParameter = fieldError.getField();
            List enumConstants = Arrays.stream(targetType.getEnumConstants()).map(Enum.class::cast).map(Enum::name).collect(Collectors.toList());
            HashSet enumConstantSet = new HashSet(enumConstants);
            list2 = list3 = this.getRejectedValues(typeMismatchException).filter(value -> !enumConstantSet.contains(value)).map(value -> new MalformedQueryParameter(queryParameter, (String)value, enumConstants)).collect(Collectors.toList());
        } else {
            list2 = list3 = Collections.emptyList();
        }
        List<MalformedQueryParameter> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list3;
    }

    private Stream<String> getRejectedValues(TypeMismatchException ex) {
        Stream<String> stream;
        Stream<String> stream2;
        TypeMismatchException typeMismatchException = ex;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)typeMismatchException);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Object value = ex.getValue();
        Stream<String> stream3 = stream2 = value != null && value.getClass().isArray() ? (stream = Arrays.stream((Object[])value).map(Objects::toString)) : (value != null && value.getClass().isAssignableFrom(Collection.class) ? (stream = ((Collection)value).stream().map(Objects::toString)) : (stream = Stream.of(value).map(Objects::toString)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaRestExceptionHandler.java", TaskanaRestExceptionHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleMaxUploadSizeExceededException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.web.multipart.MaxUploadSizeExceededException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 125);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBeanInstantiationException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.BeanInstantiationException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 134);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleIllegalArgumentException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.IllegalArgumentException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 146);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskanaRuntimeException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaRuntimeException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 155);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskanaException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 164);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleGeneralException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Exception:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 172);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBindException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.BindException:org.springframework.http.HttpHeaders:org.springframework.http.HttpStatus:org.springframework.web.context.request.WebRequest", "ex:headers:status:request", "", "org.springframework.http.ResponseEntity"), 179);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildResponse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.ErrorCode:java.lang.Throwable:org.springframework.web.context.request.WebRequest:org.springframework.http.HttpStatus", "errorCode:ex:req:status", "", "org.springframework.http.ResponseEntity"), 203);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractMalformedQueryParameters", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.FieldError", "fieldError", "", "java.util.List"), 212);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRejectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.TypeMismatchException", "ex", "", "java.util.stream.Stream"), 241);
    }

    public static class MalformedQueryParameter
    implements Serializable {
        private final String queryParameter;
        private final String actualValue;
        private final Collection<String> expectedValues;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        MalformedQueryParameter(String queryParameter, String actualValue, Collection<String> expectedValues) {
            this.queryParameter = queryParameter;
            this.actualValue = actualValue;
            this.expectedValues = expectedValues;
        }

        public String getActualValue() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.actualValue);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        public Collection<String> getExpectedValues() {
            Collection<String> collection;
            Collection<String> collection2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Collection<String> collection3 = collection2 = (collection = this.expectedValues);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, collection2);
            return collection;
        }

        public String getQueryParameter() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.queryParameter);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        static {
            MalformedQueryParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaRestExceptionHandler.java", MalformedQueryParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActualValue", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 265);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.util.Collection"), 270);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryParameter", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 275);
        }
    }
}

