/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.task.api.TaskCommentQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.rest.TaskCommentQueryFilterParameter;
import pro.taskana.task.rest.assembler.TaskCommentRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskCommentCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private final TaskService taskService;
    private final TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Autowired
    TaskCommentController(TaskService taskService, TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskCommentRepresentationModelAssembler = taskCommentRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> getTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentRepresentationModel taskCommentRepresentationModel = this.taskCommentRepresentationModelAssembler.toModel(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentRepresentationModel)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentCollectionRepresentationModel> getTaskComments(@PathVariable String taskId, HttpServletRequest request, TaskCommentQueryFilterParameter filterParameter, TaskCommentQuerySortParameter sortParameter, QueryPagingParameter<TaskComment, TaskCommentQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        HttpServletRequest httpServletRequest = request;
        TaskCommentQueryFilterParameter taskCommentQueryFilterParameter = filterParameter;
        TaskCommentQuerySortParameter taskCommentQuerySortParameter = sortParameter;
        QueryPagingParameter<TaskComment, TaskCommentQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{string, httpServletRequest, taskCommentQueryFilterParameter, taskCommentQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, TaskCommentQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        TaskCommentQuery query = this.taskService.createTaskCommentQuery();
        query.taskIdIn(new String[]{taskId});
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<TaskComment> taskComments = pagingParameter.apply(query);
        TaskCommentCollectionRepresentationModel taskCommentListResource = (TaskCommentCollectionRepresentationModel)((Object)this.taskCommentRepresentationModelAssembler.toTaskanaCollectionModel(taskComments));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentListResource)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> deleteTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> updateTaskComment(@PathVariable String taskCommentId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!taskCommentId.equals(taskCommentRepresentationModel.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        taskComment = this.taskService.updateTaskComment(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskCommentRepresentationModelAssembler.toModel(taskComment))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> createTaskComment(@PathVariable String taskId, @RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws NotAuthorizedException, InvalidArgumentException, TaskNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskCommentRepresentationModel.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskCommentRepresentationModelAssembler.toModel(createdTaskComment)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskCommentController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentController.java", TaskCommentController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:javax.servlet.http.HttpServletRequest:pro.taskana.task.rest.TaskCommentQueryFilterParameter:pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "taskId:request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 134);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskCommentId:taskCommentRepresentationModel", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.ConcurrencyException", "org.springframework.http.ResponseEntity"), 159);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskId:taskCommentRepresentationModel", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.TaskNotFoundException", "org.springframework.http.ResponseEntity"), 193);
    }

    public static final class TaskCommentQuerySortBy
    extends Enum<TaskCommentQuerySortBy>
    implements QuerySortBy<TaskCommentQuery> {
        public static final /* enum */ TaskCommentQuerySortBy CREATED;
        public static final /* enum */ TaskCommentQuerySortBy MODIFIED;
        private final BiConsumer<TaskCommentQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ TaskCommentQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            TaskCommentQuerySortBy.ajc$preClinit();
            CREATED = new TaskCommentQuerySortBy(TaskCommentQuery::orderByCreated);
            MODIFIED = new TaskCommentQuerySortBy(TaskCommentQuery::orderByModified);
            ENUM$VALUES = new TaskCommentQuerySortBy[]{CREATED, MODIFIED};
        }

        private TaskCommentQuerySortBy(BiConsumer<TaskCommentQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(TaskCommentQuery query, BaseQuery.SortDirection sortDirection) {
            TaskCommentQuery taskCommentQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskCommentQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static TaskCommentQuerySortBy[] values() {
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray;
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray3 = ENUM$VALUES;
            int n = taskCommentQuerySortByArray3.length;
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray4 = new TaskCommentQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, taskCommentQuerySortByArray4, 0, n);
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray5 = taskCommentQuerySortByArray2 = (taskCommentQuerySortByArray = taskCommentQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuerySortByArray2);
            return taskCommentQuerySortByArray;
        }

        public static TaskCommentQuerySortBy valueOf(String arg0) {
            TaskCommentQuerySortBy taskCommentQuerySortBy;
            TaskCommentQuerySortBy taskCommentQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentQuerySortBy taskCommentQuerySortBy3 = taskCommentQuerySortBy2 = (taskCommentQuerySortBy = Enum.valueOf(TaskCommentQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuerySortBy2);
            return taskCommentQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskCommentController.java", TaskCommentQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "pro.taskana.task.api.TaskCommentQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 218);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "", "", "", "[Lpro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy"), 1);
        }
    }

    public static class TaskCommentQuerySortParameter
    extends QuerySortParameter<TaskCommentQuery, TaskCommentQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public TaskCommentQuerySortParameter(List<TaskCommentQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<TaskCommentQuerySortBy> getSortBy() {
            List<TaskCommentQuerySortBy> list;
            List<TaskCommentQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<TaskCommentQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            TaskCommentQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskCommentController.java", TaskCommentQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortParameter", "", "", "", "java.util.List"), 235);
        }
    }
}

