/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.ObjectReferencePersistenceException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.rest.TaskQueryFilterParameter;
import pro.taskana.task.rest.assembler.TaskRepresentationModelAssembler;
import pro.taskana.task.rest.assembler.TaskSummaryRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskRepresentationModel;
import pro.taskana.task.rest.models.TaskSummaryCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskSummaryPagedRepresentationModel;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskController {
    private final TaskService taskService;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    @Autowired
    TaskController(TaskService taskService, TaskRepresentationModelAssembler taskRepresentationModelAssembler, TaskSummaryRepresentationModelAssembler taskSummaryRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.taskSummaryRepresentationModelAssembler = taskSummaryRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskSummaryPagedRepresentationModel> getTasks(HttpServletRequest request, TaskQueryFilterParameter filterParameter, TaskQuerySortParameter sortParameter, QueryPagingParameter<TaskSummary, TaskQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        TaskQueryFilterParameter taskQueryFilterParameter = filterParameter;
        TaskQuerySortParameter taskQuerySortParameter = sortParameter;
        QueryPagingParameter<TaskSummary, TaskQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, taskQueryFilterParameter, taskQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, TaskQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<TaskSummary> taskSummaries = pagingParameter.apply(query);
        TaskSummaryPagedRepresentationModel pagedModels = (TaskSummaryPagedRepresentationModel)((Object)this.taskSummaryRepresentationModelAssembler.toPagedModel(taskSummaries, pagingParameter.getPageMetadata()));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pagedModels)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskSummaryCollectionRepresentationModel> deleteTasks(TaskQueryFilterParameter filterParameter) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TaskQueryFilterParameter taskQueryFilterParameter = filterParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskQueryFilterParameter);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.apply(query);
        List taskSummaries = query.list();
        List taskIdsToDelete = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
        BulkOperationResults result = this.taskService.deleteTasks(taskIdsToDelete);
        List successfullyDeletedTaskSummaries = taskSummaries.stream().filter(summary -> !result.getFailedIds().contains(summary.getId())).collect(Collectors.toList());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)((TaskSummaryCollectionRepresentationModel)this.taskSummaryRepresentationModelAssembler.toTaskanaCollectionModel(successfullyDeletedTaskSummaries)))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> getTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task = this.taskService.getTask(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> claimTask(@PathVariable String taskId, @RequestBody(required=false) String userName) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        String string2 = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskService.claim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/select-and-claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> selectAndClaimTask(TaskQueryFilterParameter filterParameter, TaskQuerySortParameter sortParameter) throws InvalidOwnerException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TaskQueryFilterParameter taskQueryFilterParameter = filterParameter;
        TaskQuerySortParameter taskQuerySortParameter = sortParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskQueryFilterParameter, (Object)taskQuerySortParameter);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskQuery query = this.taskService.createTaskQuery();
        filterParameter.apply(query);
        sortParameter.apply(query);
        Task selectedAndClaimedTask = this.taskService.selectAndClaim(query);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(selectedAndClaimedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> cancelClaimTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task updatedTask = this.taskService.cancelClaim(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}/claim/force"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> forceCancelClaimTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task updatedTask = this.taskService.forceCancelClaim(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> completeTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task updatedTask = this.taskService.forceCompleteTask(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> deleteTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskService.forceDeleteTask(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/cancel"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> cancelTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException, InvalidStateException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task cancelledTask = this.taskService.cancelTask(taskId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(cancelledTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> createTask(@RequestBody TaskRepresentationModel taskRepresentationModel) throws WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException, TaskAlreadyExistException, InvalidArgumentException, AttachmentPersistenceException, ObjectReferencePersistenceException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TaskRepresentationModel taskRepresentationModel2 = taskRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)((Object)taskRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task fromResource = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        Task createdTask = this.taskService.createTask(fromResource);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskRepresentationModelAssembler.toModel(createdTask)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/transfer/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> transferTask(@PathVariable String taskId, @PathVariable String workbasketId, @RequestBody(required=false) Boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        String string2 = workbasketId;
        Boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, bl};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task updatedTask = this.taskService.transfer(taskId, workbasketId, setTransferFlag == null || setTransferFlag != false);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(updatedTask))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/tasks/{taskId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskRepresentationModel> updateTask(@PathVariable(value="taskId") String taskId, @RequestBody TaskRepresentationModel taskRepresentationModel) throws TaskNotFoundException, ClassificationNotFoundException, InvalidArgumentException, ConcurrencyException, NotAuthorizedException, AttachmentPersistenceException, InvalidStateException, ObjectReferencePersistenceException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        TaskRepresentationModel taskRepresentationModel2 = taskRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)((Object)taskRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!taskId.equals(taskRepresentationModel.getTaskId())) {
            throw new InvalidArgumentException(String.format("TaskId ('%s') is not identical with the taskId of to object in the payload which should be updated. ID=('%s')", taskId, taskRepresentationModel.getTaskId()));
        }
        Task task = this.taskRepresentationModelAssembler.toEntityModel(taskRepresentationModel);
        task = this.taskService.updateTask(task);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskRepresentationModelAssembler.toModel(task))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskController.java", TaskController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTasks", "pro.taskana.task.rest.TaskController", "javax.servlet.http.HttpServletRequest:pro.taskana.task.rest.TaskQueryFilterParameter:pro.taskana.task.rest.TaskController$TaskQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTasks", "pro.taskana.task.rest.TaskController", "pro.taskana.task.rest.TaskQueryFilterParameter", "filterParameter", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 119);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "pro.taskana.task.rest.TaskController", "pro.taskana.task.rest.models.TaskRepresentationModel", "taskRepresentationModel", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskAlreadyExistException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.ObjectReferencePersistenceException", "org.springframework.http.ResponseEntity"), 340);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTask", "pro.taskana.task.rest.TaskController", "java.lang.String:java.lang.String:java.lang.Boolean", "taskId:workbasketId:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "org.springframework.http.ResponseEntity"), 367);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "pro.taskana.task.rest.TaskController", "java.lang.String:pro.taskana.task.rest.models.TaskRepresentationModel", "taskId:taskRepresentationModel", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.ObjectReferencePersistenceException", "org.springframework.http.ResponseEntity"), 401);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 154);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claimTask", "pro.taskana.task.rest.TaskController", "java.lang.String:java.lang.String", "taskId:userName", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 176);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAndClaimTask", "pro.taskana.task.rest.TaskController", "pro.taskana.task.rest.TaskQueryFilterParameter:pro.taskana.task.rest.TaskController$TaskQuerySortParameter", "filterParameter:sortParameter", "pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 199);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelClaimTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 227);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCancelClaimTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 249);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 270);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 292);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelTask", "pro.taskana.task.rest.TaskController", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "org.springframework.http.ResponseEntity"), 313);
    }

    public static final class TaskQuerySortBy
    extends Enum<TaskQuerySortBy>
    implements QuerySortBy<TaskQuery> {
        public static final /* enum */ TaskQuerySortBy CLASSIFICATION_KEY;
        public static final /* enum */ TaskQuerySortBy CLASSIFICATION_NAME;
        public static final /* enum */ TaskQuerySortBy POR_TYPE;
        public static final /* enum */ TaskQuerySortBy POR_VALUE;
        public static final /* enum */ TaskQuerySortBy POR_COMPANY;
        public static final /* enum */ TaskQuerySortBy POR_SYSTEM;
        public static final /* enum */ TaskQuerySortBy POR_SYSTEM_INSTANCE;
        public static final /* enum */ TaskQuerySortBy STATE;
        public static final /* enum */ TaskQuerySortBy NAME;
        public static final /* enum */ TaskQuerySortBy DUE;
        public static final /* enum */ TaskQuerySortBy PLANNED;
        public static final /* enum */ TaskQuerySortBy RECEIVED;
        public static final /* enum */ TaskQuerySortBy PRIORITY;
        public static final /* enum */ TaskQuerySortBy CREATED;
        public static final /* enum */ TaskQuerySortBy CLAIMED;
        public static final /* enum */ TaskQuerySortBy DOMAIN;
        public static final /* enum */ TaskQuerySortBy TASK_ID;
        public static final /* enum */ TaskQuerySortBy MODIFIED;
        public static final /* enum */ TaskQuerySortBy CREATOR;
        public static final /* enum */ TaskQuerySortBy NOTE;
        public static final /* enum */ TaskQuerySortBy OWNER;
        public static final /* enum */ TaskQuerySortBy OWNER_LONG_NAME;
        public static final /* enum */ TaskQuerySortBy BUSINESS_PROCESS_ID;
        public static final /* enum */ TaskQuerySortBy PARENT_BUSINESS_PROCESS_ID;
        public static final /* enum */ TaskQuerySortBy WORKBASKET_KEY;
        public static final /* enum */ TaskQuerySortBy CUSTOM_1;
        public static final /* enum */ TaskQuerySortBy CUSTOM_2;
        public static final /* enum */ TaskQuerySortBy CUSTOM_3;
        public static final /* enum */ TaskQuerySortBy CUSTOM_4;
        public static final /* enum */ TaskQuerySortBy CUSTOM_5;
        public static final /* enum */ TaskQuerySortBy CUSTOM_6;
        public static final /* enum */ TaskQuerySortBy CUSTOM_7;
        public static final /* enum */ TaskQuerySortBy CUSTOM_8;
        public static final /* enum */ TaskQuerySortBy CUSTOM_9;
        public static final /* enum */ TaskQuerySortBy CUSTOM_10;
        public static final /* enum */ TaskQuerySortBy CUSTOM_11;
        public static final /* enum */ TaskQuerySortBy CUSTOM_12;
        public static final /* enum */ TaskQuerySortBy CUSTOM_13;
        public static final /* enum */ TaskQuerySortBy CUSTOM_14;
        public static final /* enum */ TaskQuerySortBy CUSTOM_15;
        public static final /* enum */ TaskQuerySortBy CUSTOM_16;
        public static final /* enum */ TaskQuerySortBy WORKBASKET_ID;
        public static final /* enum */ TaskQuerySortBy WORKBASKET_NAME;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_CLASSIFICATION_KEY;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_CLASSIFICATION_NAME;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_CLASSIFICATION_ID;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_CHANNEL;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_REFERENCE;
        public static final /* enum */ TaskQuerySortBy ATTACHMENT_RECEIVED;
        public static final /* enum */ TaskQuerySortBy COMPLETED;
        private final BiConsumer<TaskQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ TaskQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            TaskQuerySortBy.ajc$preClinit();
            CLASSIFICATION_KEY = new TaskQuerySortBy(TaskQuery::orderByClassificationKey);
            CLASSIFICATION_NAME = new TaskQuerySortBy(TaskQuery::orderByClassificationName);
            POR_TYPE = new TaskQuerySortBy(TaskQuery::orderByPrimaryObjectReferenceType);
            POR_VALUE = new TaskQuerySortBy(TaskQuery::orderByPrimaryObjectReferenceValue);
            POR_COMPANY = new TaskQuerySortBy(TaskQuery::orderByPrimaryObjectReferenceCompany);
            POR_SYSTEM = new TaskQuerySortBy(TaskQuery::orderByPrimaryObjectReferenceSystem);
            POR_SYSTEM_INSTANCE = new TaskQuerySortBy(TaskQuery::orderByPrimaryObjectReferenceSystemInstance);
            STATE = new TaskQuerySortBy(TaskQuery::orderByState);
            NAME = new TaskQuerySortBy(TaskQuery::orderByName);
            DUE = new TaskQuerySortBy(TaskQuery::orderByDue);
            PLANNED = new TaskQuerySortBy(TaskQuery::orderByPlanned);
            RECEIVED = new TaskQuerySortBy(TaskQuery::orderByReceived);
            PRIORITY = new TaskQuerySortBy(TaskQuery::orderByPriority);
            CREATED = new TaskQuerySortBy(TaskQuery::orderByCreated);
            CLAIMED = new TaskQuerySortBy(TaskQuery::orderByClaimed);
            DOMAIN = new TaskQuerySortBy(TaskQuery::orderByDomain);
            TASK_ID = new TaskQuerySortBy(TaskQuery::orderByTaskId);
            MODIFIED = new TaskQuerySortBy(TaskQuery::orderByModified);
            CREATOR = new TaskQuerySortBy(TaskQuery::orderByCreator);
            NOTE = new TaskQuerySortBy(TaskQuery::orderByNote);
            OWNER = new TaskQuerySortBy(TaskQuery::orderByOwner);
            OWNER_LONG_NAME = new TaskQuerySortBy(TaskQuery::orderByOwnerLongName);
            BUSINESS_PROCESS_ID = new TaskQuerySortBy(TaskQuery::orderByBusinessProcessId);
            PARENT_BUSINESS_PROCESS_ID = new TaskQuerySortBy(TaskQuery::orderByParentBusinessProcessId);
            WORKBASKET_KEY = new TaskQuerySortBy(TaskQuery::orderByWorkbasketKey);
            CUSTOM_1 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_1, sort);
            });
            CUSTOM_2 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_2, sort);
            });
            CUSTOM_3 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_3, sort);
            });
            CUSTOM_4 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_4, sort);
            });
            CUSTOM_5 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_5, sort);
            });
            CUSTOM_6 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_6, sort);
            });
            CUSTOM_7 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_7, sort);
            });
            CUSTOM_8 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_8, sort);
            });
            CUSTOM_9 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_9, sort);
            });
            CUSTOM_10 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_10, sort);
            });
            CUSTOM_11 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_11, sort);
            });
            CUSTOM_12 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_12, sort);
            });
            CUSTOM_13 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_13, sort);
            });
            CUSTOM_14 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_14, sort);
            });
            CUSTOM_15 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_15, sort);
            });
            CUSTOM_16 = new TaskQuerySortBy((query, sort) -> {
                TaskQuery taskQuery = query.orderByCustomAttribute(TaskCustomField.CUSTOM_16, sort);
            });
            WORKBASKET_ID = new TaskQuerySortBy(TaskQuery::orderByWorkbasketId);
            WORKBASKET_NAME = new TaskQuerySortBy(TaskQuery::orderByWorkbasketName);
            ATTACHMENT_CLASSIFICATION_KEY = new TaskQuerySortBy(TaskQuery::orderByAttachmentClassificationKey);
            ATTACHMENT_CLASSIFICATION_NAME = new TaskQuerySortBy(TaskQuery::orderByAttachmentClassificationName);
            ATTACHMENT_CLASSIFICATION_ID = new TaskQuerySortBy(TaskQuery::orderByAttachmentClassificationId);
            ATTACHMENT_CHANNEL = new TaskQuerySortBy(TaskQuery::orderByAttachmentChannel);
            ATTACHMENT_REFERENCE = new TaskQuerySortBy(TaskQuery::orderByAttachmentReference);
            ATTACHMENT_RECEIVED = new TaskQuerySortBy(TaskQuery::orderByAttachmentReceived);
            COMPLETED = new TaskQuerySortBy(TaskQuery::orderByCompleted);
            ENUM$VALUES = new TaskQuerySortBy[]{CLASSIFICATION_KEY, CLASSIFICATION_NAME, POR_TYPE, POR_VALUE, POR_COMPANY, POR_SYSTEM, POR_SYSTEM_INSTANCE, STATE, NAME, DUE, PLANNED, RECEIVED, PRIORITY, CREATED, CLAIMED, DOMAIN, TASK_ID, MODIFIED, CREATOR, NOTE, OWNER, OWNER_LONG_NAME, BUSINESS_PROCESS_ID, PARENT_BUSINESS_PROCESS_ID, WORKBASKET_KEY, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, CUSTOM_9, CUSTOM_10, CUSTOM_11, CUSTOM_12, CUSTOM_13, CUSTOM_14, CUSTOM_15, CUSTOM_16, WORKBASKET_ID, WORKBASKET_NAME, ATTACHMENT_CLASSIFICATION_KEY, ATTACHMENT_CLASSIFICATION_NAME, ATTACHMENT_CLASSIFICATION_ID, ATTACHMENT_CHANNEL, ATTACHMENT_REFERENCE, ATTACHMENT_RECEIVED, COMPLETED};
        }

        private TaskQuerySortBy(BiConsumer<TaskQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(TaskQuery query, BaseQuery.SortDirection sortDirection) {
            TaskQuery taskQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static TaskQuerySortBy[] values() {
            TaskQuerySortBy[] taskQuerySortByArray;
            TaskQuerySortBy[] taskQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskQuerySortBy[] taskQuerySortByArray3 = ENUM$VALUES;
            int n = taskQuerySortByArray3.length;
            TaskQuerySortBy[] taskQuerySortByArray4 = new TaskQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, taskQuerySortByArray4, 0, n);
            TaskQuerySortBy[] taskQuerySortByArray5 = taskQuerySortByArray2 = (taskQuerySortByArray = taskQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskQuerySortByArray2);
            return taskQuerySortByArray;
        }

        public static TaskQuerySortBy valueOf(String arg0) {
            TaskQuerySortBy taskQuerySortBy;
            TaskQuerySortBy taskQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskQuerySortBy taskQuerySortBy3 = taskQuerySortBy2 = (taskQuerySortBy = Enum.valueOf(TaskQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskQuerySortBy2);
            return taskQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskController.java", TaskQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.task.rest.TaskController$TaskQuerySortBy", "pro.taskana.task.api.TaskQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 478);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.task.rest.TaskController$TaskQuerySortBy", "", "", "", "[Lpro.taskana.task.rest.TaskController$TaskQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.task.rest.TaskController$TaskQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.task.rest.TaskController$TaskQuerySortBy"), 1);
        }
    }

    public static class TaskQuerySortParameter
    extends QuerySortParameter<TaskQuery, TaskQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public TaskQuerySortParameter(List<TaskQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<TaskQuerySortBy> getSortBy() {
            List<TaskQuerySortBy> list;
            List<TaskQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<TaskQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            TaskQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskController.java", TaskQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.task.rest.TaskController$TaskQuerySortParameter", "", "", "", "java.util.List"), 496);
        }
    }
}

