/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.security.GroupPrincipal;
import pro.taskana.common.api.security.UserPrincipal;
import pro.taskana.common.internal.logging.LoggingAspect;

public class SpringSecurityToJaasFilter
extends GenericFilterBean {
    private static final Logger LOGGER;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        SpringSecurityToJaasFilter.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SpringSecurityToJaasFilter.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequest servletRequest = request;
        ServletResponse servletResponse = response;
        FilterChain filterChain = chain;
        Object[] objectArray = new Object[]{servletRequest, servletResponse, filterChain};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Authentication> authentication = this.getCurrentAuthentication();
        if (authentication.isPresent()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication found in Spring security context: {}", authentication);
            }
            this.obtainSubject().ifPresent(subject -> {
                this.initializeUserPrincipalFromAuthentication((Authentication)authentication.get(), (Subject)subject);
                this.initializeGroupPrincipalsFromAuthentication((Authentication)authentication.get(), (Subject)subject);
            });
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No authentication found in Spring security context. Continuing unauthenticatic.");
        }
        chain.doFilter(request, response);
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    protected Optional<Subject> obtainSubject() {
        Optional optional;
        Optional<Object> optional2;
        Optional<Subject> optional3;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Authentication> authentication = this.getCurrentAuthentication();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to obtainSubject using authentication : " + authentication));
        }
        if (authentication.isEmpty() || !authentication.get().isAuthenticated()) {
            optional3 = Optional.empty();
            optional2 = optional3;
        } else {
            optional3 = Optional.of(Subject.getSubject(AccessController.getContext()));
            optional2 = optional3;
        }
        Optional optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    Optional<Authentication> getCurrentAuthentication() {
        Optional<Authentication> optional;
        Optional<Authentication> optional2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Authentication> optional3 = optional2 = (optional = Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    private void initializeUserPrincipalFromAuthentication(Authentication authentication, Subject subject) {
        Authentication authentication2 = authentication;
        Subject subject2 = subject;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)authentication2, (Object)subject2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (subject.getPrincipals().isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting the principal of the subject with {}.", authentication.getPrincipal());
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Principal of the subject is already set to {}.", subject.getPrincipals());
            }
            throw new SystemException("Finding an existing principal is unexpected. Please investigate.");
        }
        subject.getPrincipals().add((Principal)new UserPrincipal(((UserDetails)authentication.getPrincipal()).getUsername()));
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void initializeGroupPrincipalsFromAuthentication(Authentication authentication, Subject subject) {
        Authentication authentication2 = authentication;
        Subject subject2 = subject;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)authentication2, (Object)subject2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding roles {} to subject.", (Object)authentication.getAuthorities());
        }
        authentication.getAuthorities().forEach(grantedAuthority -> {
            boolean bl = subject.getPrincipals().add((Principal)new GroupPrincipal(grantedAuthority.getAuthority()));
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}", subject.getPublicCredentials(GroupPrincipal.class));
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringSecurityToJaasFilter.java", SpringSecurityToJaasFilter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doFilter", "pro.taskana.common.rest.SpringSecurityToJaasFilter", "javax.servlet.ServletRequest:javax.servlet.ServletResponse:javax.servlet.FilterChain", "request:response:chain", "java.io.IOException:javax.servlet.ServletException", "void"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "obtainSubject", "pro.taskana.common.rest.SpringSecurityToJaasFilter", "", "", "", "java.util.Optional"), 62);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCurrentAuthentication", "pro.taskana.common.rest.SpringSecurityToJaasFilter", "", "", "", "java.util.Optional"), 74);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeUserPrincipalFromAuthentication", "pro.taskana.common.rest.SpringSecurityToJaasFilter", "org.springframework.security.core.Authentication:javax.security.auth.Subject", "authentication:subject", "", "void"), 78);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeGroupPrincipalsFromAuthentication", "pro.taskana.common.rest.SpringSecurityToJaasFilter", "org.springframework.security.core.Authentication:javax.security.auth.Subject", "authentication:subject", "", "void"), 96);
    }
}

